/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente.comboBox;

import br.com.bb.plugins.gac.apresentacao.dominio.action.ConsultarListaTipoLeiauteAction;
import br.com.bb.plugins.gac.apresentacao.dominio.form.DominioForm;
import br.com.bb.plugins.gac.factory.ActionFactory;
import br.com.bb.plugins.gac.factory.FabricaDeControladorDeAcesso;
import br.com.bb.plugins.gac.factory.FormFactory;
import br.com.bb.plugins.gac.negocio.to.TipoLeiauteTO;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboBox;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJComboBoxTipoLeiaute
extends BBJComboBox {
    public void carregar() {
        DominioForm dominioForm = this.getDominioForm();
        this.getConsultarListaTipoLeiauteAction().executar(dominioForm);
        this.preencherCombo(dominioForm.getListaTipoLeiaute());
    }

    public void carregarComTiposLeiautesExportacao() {
        DominioForm dominioForm = this.getDominioForm();
        this.getConsultarListaTipoLeiauteAction().executar(dominioForm);
        Collection<TipoLeiauteTO> listaFiltrada = this.filtrarLitaTipoLeiaute(dominioForm.getListaTipoLeiaute());
        this.preencherComboExportacao(listaFiltrada);
    }

    public void carregarQuantoTextoIdentificadorIgualDBT() {
        DominioForm dominioForm = this.getDominioForm();
        this.getConsultarListaTipoLeiauteAction().executar(dominioForm);
        Collection<TipoLeiauteTO> listaFiltrada = this.filtrarLitaComTextoIdentificadorIgualDBT(dominioForm.getListaTipoLeiaute());
        this.preencherCombo(listaFiltrada);
    }

    public void carregarComTipoOperacao() {
        DominioForm dominioForm = this.getDominioForm();
        this.getConsultarListaTipoLeiauteAction().executar(dominioForm);
        this.preencherComboComTipoOperacao(dominioForm.getListaTipoLeiaute());
    }

    public void preencherComboExportacao(Collection<TipoLeiauteTO> listaFiltrada) {
        ArrayList<TipoLeiauteTO> listatemp = new ArrayList<TipoLeiauteTO>();
        for (TipoLeiauteTO lista : listaFiltrada) {
            lista.setTextoTipoOperacao("");
            listatemp.add(lista);
        }
        this.setModel(this.getDefaultComboBoxModel(listatemp));
    }

    public void preencherComboComTipoOperacao(Collection<TipoLeiauteTO> listaTipoDocumento) {
        ArrayList<TipoLeiauteTO> listatemp = new ArrayList<TipoLeiauteTO>();
        for (TipoLeiauteTO lista : listaTipoDocumento) {
            if (!lista.getServicoTO().getTextoIdentificadorServico().equals(FabricaDeControladorDeAcesso.getInstancia().novoPluginControladorDeAcesso().getServico())) continue;
            listatemp.add(lista);
        }
        this.setModel(this.getDefaultComboBoxModel(listatemp));
    }

    private void preencherCombo(Collection<TipoLeiauteTO> listaTipoDocumento) {
        ArrayList<TipoLeiauteTO> listatemp = new ArrayList<TipoLeiauteTO>();
        for (TipoLeiauteTO lista : listaTipoDocumento) {
            if (!lista.getServicoTO().getTextoIdentificadorServico().equals("DBT")) continue;
            listatemp.add(lista);
        }
        this.setModel(this.getDefaultComboBoxModel(listatemp));
    }

    private DefaultComboBoxModel getDefaultComboBoxModel(Collection<TipoLeiauteTO> listaTipoLeiaute) {
        DefaultComboBoxModel defaultComboBoxModel = this.getComboBoxModelPopulada(listaTipoLeiaute);
        this.selecionaPrimeiroItemCombo(defaultComboBoxModel);
        return defaultComboBoxModel;
    }

    public Collection<TipoLeiauteTO> filtrarLitaComTextoIdentificadorIgualDBT(Collection<TipoLeiauteTO> listaTipoLaiaute) {
        ArrayList<TipoLeiauteTO> listaFiltrada = new ArrayList<TipoLeiauteTO>();
        for (TipoLeiauteTO lista : listaTipoLaiaute) {
            if (!lista.getServicoTO().getTextoIdentificadorServico().trim().equals("DBT")) continue;
            listaFiltrada.add(lista);
        }
        return listaFiltrada;
    }

    public Collection<TipoLeiauteTO> filtrarLitaTipoLeiaute(Collection<TipoLeiauteTO> listaTipoLaiaute) {
        ArrayList<TipoLeiauteTO> listaFiltrada = new ArrayList<TipoLeiauteTO>();
        for (TipoLeiauteTO lista : listaTipoLaiaute) {
            if (!lista.getTextoTipoOperacao().trim().equals("EXPORTACAO") || !lista.getTextoDescricaoTipoLeiaute().equals("Recebimento") && !lista.getTextoDescricaoTipoLeiaute().equals("Cliente")) continue;
            listaFiltrada.add(lista);
        }
        return listaFiltrada;
    }

    private DefaultComboBoxModel getComboBoxModelPopulada(Collection<TipoLeiauteTO> listaTipoLeiaute) {
        return new DefaultComboBoxModel<Object>(listaTipoLeiaute.toArray());
    }

    private void selecionaPrimeiroItemCombo(DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.setSelectedItem(defaultComboBoxModel.getElementAt(0));
    }

    private DominioForm getDominioForm() {
        return FormFactory.getInstancia().novoDominioForm();
    }

    private ConsultarListaTipoLeiauteAction getConsultarListaTipoLeiauteAction() {
        return ActionFactory.getInstancia().novoConsultarListaTipoLeiauteAction();
    }
}

