/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.listener;

import br.com.bb.plugins.gac.apresentacao.action.FecharAction;
import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.FabricaDeControladorDeAcesso;
import br.com.bb.plugins.gac.factory.PluginFormularioEstrategiaSwingFactory;
import br.com.bb.plugins.gac.negocio.to.AuditoriaTO;
import br.com.bb.plugins.gac.util.Log;
import br.com.bb.plugins.gac.util.UtilMapeamentoAction;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.bean.ValidacaoBean;
import br.com.bb.plugins.gac.util.controller.view.ControlableListener;
import br.com.bb.plugins.gac.util.controller.view.ControlableView;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.interceptor.ConfiguracaoDaAuditoria;
import br.com.bb.plugins.gac.util.seguranca.PluginControladorDeAcesso;
import br.com.bb.plugins.gac.util.swing.IAcao;
import br.com.bb.plugins.gac.util.swing.IActionDeConfirmacao;
import br.com.bb.plugins.gac.util.swing.IActionMultiThread;
import br.com.bb.plugins.gac.util.swing.IFormulario;
import br.com.bb.plugins.gac.util.swing.UtilAcaoMultiThread;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.politec.estrategiaswing.IFormularioEstrategiaSwing;
import br.com.politec.estrategiaswing.IFormularioEstrategiaSwingFactory;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.excecao.UtilExcecao;
import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.fabrica.DataFactory;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import br.com.politec.generico.validador.UtilValidadorDeNumerosIguais;
import br.com.politec.reflexao.UtilReflexaoInvocarMetodo;
import br.com.politec.reflexao.UtilReflexaoMetodo;
import br.com.politec.reflexao.UtilReflexaoSet;
import br.com.politec.reflexao.exception.ReflexaoException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginListener
implements ActionListener,
ControlableListener {
    private Map contexto;
    private ControlableView visao;

    @Override
    public void actionPerformed(ActionEvent evento) {
        block20: {
            block18: {
                PluginActionAbstrato action;
                block17: {
                    IFormulario frame;
                    block19: {
                        Component componente = this.getComponente(evento);
                        frame = this.getIFormulario(componente);
                        action = this.getAction(componente);
                        if (!this.verificaPermissaoUsuario(action)) break block18;
                        PluginFormAbstrato form = this.getForm(frame);
                        Collection<Component> lista = this.getComponentes((Component)((Object)frame));
                        if (!(action instanceof FecharAction)) {
                            this.processarCarregarForm(frame, form, lista);
                            this.processarLimparMensagens(action);
                            this.processarPreExecucaoDaAcao(action, form);
                        }
                        if (!(action instanceof FecharAction) && !this.isValidado(form)) break block19;
                        if (!this.isAcaoConfirmada(action, frame)) break block17;
                        if (!(action instanceof FecharAction)) {
                            this.processarPreExecutarAcaoNaVisao(frame, componente);
                        }
                        String visao = null;
                        try {
                            visao = this.processarExecutarAcao(frame, componente, form);
                            if (!this.isActionMultiThread(action) && !(action instanceof FecharAction)) {
                                this.processarAuditoria(action);
                            }
                            this.processarMensagensRegistradas(action, frame);
                            if (UtilString.isVazio(visao)) {
                                if (!this.isActionMultiThread(action)) {
                                    this.processarExecutarAcaoNaVisao(frame, componente);
                                }
                            } else {
                                this.processarRedirecionamento(visao, form);
                            }
                        }
                        catch (BBException e) {
                            this.processarMensagemDeErro(frame, e);
                            if (!this.isActionMultiThread(action)) {
                                this.processarExecutarAcaoFinalNaVisao(frame, componente);
                            }
                            break block17;
                        }
                        catch (Throwable e) {
                            try {
                                this.processarMensagemDeErro(frame, e);
                                break block17;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (!this.isActionMultiThread(action)) {
                                    this.processarExecutarAcaoFinalNaVisao(frame, componente);
                                }
                            }
                        }
                        if (!this.isActionMultiThread(action)) {
                            this.processarExecutarAcaoFinalNaVisao(frame, componente);
                        }
                        break block17;
                    }
                    Map<String, Component> componentes = this.getMapaDeComponentes((Component)((Object)frame));
                    this.processarMensagemDeValidacao(frame);
                    this.posicionarFocoNoCampoInvalido(frame, componentes);
                }
                if (!this.isActionMultiThread(action)) {
                    this.processarLimparRecursosDeAuditoria();
                }
                break block20;
            }
            BBJPopupMensagem.exibirMensagemErro(UtilMensagem.getInstancia().getMensagem("MP006", this.novoPluginControladorDeAcesso().getTextoNomeUsuarioSistema()));
        }
    }

    private boolean verificaPermissaoUsuario(PluginActionAbstrato action) {
        UtilMapeamentoAction util = UtilMapeamentoAction.getInstancia();
        String transacao = util.getCodigo(action);
        String textoCodigoOpcaoMenu = this.getConfiguracaoDaAuditoria().getTextoCodigoOpcaoMenu();
        String textoIdentificadorServico = this.getConfiguracaoDaAuditoria().getTextoIdentificadorServico();
        if (textoIdentificadorServico == null || textoIdentificadorServico.equals("")) {
            textoIdentificadorServico = UtilObjeto.getClasse(action).getPackage().toString().substring(26, 29).toUpperCase();
        }
        boolean temAcesso = true;
        if (this.isUsuarioLogado() && !UtilString.isVazio(transacao)) {
            if (!this.EUsuarioAdministrador() && !"GAC".equals(textoIdentificadorServico) && textoCodigoOpcaoMenu == null && "9999".equals(transacao)) {
                textoIdentificadorServico = "GAC";
                textoCodigoOpcaoMenu = "0005";
            }
            temAcesso = this.EUsuarioAdministrador() || transacao.equals("0004") && textoCodigoOpcaoMenu == null ? true : this.novoPluginControladorDeAcesso().isTemAcesso(textoIdentificadorServico, textoCodigoOpcaoMenu, transacao);
        }
        return temAcesso;
    }

    private boolean EUsuarioAdministrador() {
        if (this.novoPluginControladorDeAcesso().getPluginProfile() == null) {
            return false;
        }
        return this.novoPluginControladorDeAcesso().getPluginProfile().EUsuarioAdministrador();
    }

    public void processarAuditoria(PluginActionAbstrato action, ConfiguracaoDaAuditoria configuracaoDaAuditoria) {
        UtilMapeamentoAction util = UtilMapeamentoAction.getInstancia();
        String transacao = util.getCodigo(action);
        if (this.isUsuarioLogado() && !UtilString.isVazio(transacao)) {
            configuracaoDaAuditoria.setTextoCodigoTransacao(transacao);
            AuditoriaTO to = configuracaoDaAuditoria.getAuditoriaTO();
            action.processarAuditoria(to);
        }
    }

    public void processarAuditoria(PluginActionAbstrato action) {
        this.processarAuditoria(action, this.getConfiguracaoDaAuditoria());
    }

    public void processarLimparRecursosDeAuditoria() {
        this.getConfiguracaoDaAuditoria().setTextoCodigoTransacao(null);
    }

    protected DataFactory getDataFactory() {
        return DataFactory.getInstance();
    }

    protected boolean isUsuarioLogado() {
        return this.novoPluginControladorDeAcesso().isExisteProfile();
    }

    protected PluginControladorDeAcesso novoPluginControladorDeAcesso() {
        return this.getFabricaDeControladorDeAcesso().novoPluginControladorDeAcesso();
    }

    protected FabricaDeControladorDeAcesso getFabricaDeControladorDeAcesso() {
        return FabricaDeControladorDeAcesso.getInstancia();
    }

    protected void processarMensagensRegistradas(PluginActionAbstrato action, IFormulario frame) {
        Collection<String> mensagens = action.getColecaoDeMensagens();
        if (!UtilColecao.isVazio(mensagens)) {
            StringBuffer sb = this.novoStringBuffer();
            for (String mensagem : mensagens) {
                sb.append(mensagem).append("\n");
            }
            BBJPopupMensagem.exibirMensagemAlerta(sb.toString());
        }
    }

    protected void processarLimparMensagens(PluginActionAbstrato action) {
        action.limparMensagens();
    }

    protected void processarMensagemDeErro(IFormulario frame, BBException e) {
        BBJPopupMensagem.exibirMensagemErro(e.getMessage());
    }

    protected void processarMensagemDeErro(IFormulario frame, Throwable e) {
        String erro = UtilExcecao.getMensagem(e);
        String mensagem = UtilMensagem.getInstancia().getErroDeSistema(erro);
        BBJPopupMensagem.exibirMensagemErro(mensagem);
        Log.getInstance().logMsg(e);
    }

    protected void processarMensagemDeValidacao(IFormulario frame) {
        PluginFormAbstrato form = this.getForm(frame);
        if (this.isPermitirValidacaoDoFormulario(form)) {
            String mensagens = this.getMensagensDaValidacao(form);
            BBJPopupMensagem.exibirMensagemAlerta(mensagens);
        }
    }

    protected void posicionarFocoNoCampoInvalido(IFormulario frame, Map<String, Component> componentes) {
        Component componente = this.getComponenteInvalido(frame, componentes);
        if (this.isReferencia(componente)) {
            componente.requestFocus();
        }
    }

    protected void processarRedirecionamento(String visao, PluginFormAbstrato form) {
        Map contexto = this.getContexto();
        ControlableView frame = this.getViewController().goToView(visao, contexto);
        frame.setFormAnterior(form);
        frame.inicializaTela();
    }

    protected ViewController getViewController() {
        return ViewController.getInstance();
    }

    public void processarExecutarAcaoNaVisao(IFormulario frame, Component componente) {
        PluginActionAbstrato action = this.getAction(componente);
        if (this.isReferencia(action)) {
            String metodo = this.getNomeDoMetodoPosNaVisao(action);
            Class<?> classe = frame.getClass();
            try {
                if (UtilReflexaoMetodo.isExisteMetodo(classe, metodo)) {
                    UtilReflexaoInvocarMetodo.invocar((Object)frame, metodo);
                }
            }
            catch (ReflexaoException e) {
                Log.getInstance().logMsg(e);
            }
        }
    }

    public void processarExecutarAcaoFinalNaVisao(IFormulario frame, Component componente) {
        PluginActionAbstrato action = this.getAction(componente);
        if (this.isReferencia(action)) {
            String metodo = this.getNomeDoMetodoPosFinalNaVisao(action);
            Class<?> classe = frame.getClass();
            try {
                if (UtilReflexaoMetodo.isExisteMetodo(classe, metodo)) {
                    UtilReflexaoInvocarMetodo.invocar((Object)frame, metodo);
                }
            }
            catch (ReflexaoException e) {
                Log.getInstance().logMsg(e);
            }
        }
    }

    protected String processarExecutarAcao(IFormulario frame, Component componente, PluginFormAbstrato form) throws BBException {
        String resultado = null;
        PluginActionAbstrato action = this.getAction(componente);
        if (this.isReferencia(action)) {
            if (this.isActionMultiThread(action)) {
                UtilAcaoMultiThread.invocar(this, frame, componente, action, form, this.novoPluginControladorDeAcesso().getPluginProfile(), this.getConfiguracaoDaAuditoria().getTextoCodigoOpcaoMenu(), this.getConfiguracaoDaAuditoria().getTextoIdentificadorServico());
            } else {
                resultado = action.executar(form);
            }
        }
        return resultado;
    }

    protected boolean isActionMultiThread(PluginActionAbstrato action) {
        return UtilObjeto.isObjetoDoTipo(action, IActionMultiThread.class);
    }

    protected void processarPreExecutarAcaoNaVisao(IFormulario frame, Component componente) {
        PluginActionAbstrato action = this.getAction(componente);
        if (UtilObjeto.isReferencia(action)) {
            String metodo = this.getNomeDoMetodoPreNaVisao(action);
            Class<?> classe = frame.getClass();
            try {
                if (UtilReflexaoMetodo.isExisteMetodo(classe, metodo)) {
                    UtilReflexaoInvocarMetodo.invocar((Object)frame, metodo);
                }
            }
            catch (ReflexaoException e) {
                Log.getInstance().logMsg(e);
            }
        }
    }

    protected void processarPreExecucaoDaAcao(PluginActionAbstrato action, PluginFormAbstrato form) {
        if (UtilObjeto.isReferencia(action)) {
            action.preExecutar(form);
        }
    }

    protected PluginActionAbstrato getAction(Component componente) {
        IAcao botao = (IAcao)((Object)componente);
        return botao.getAcao();
    }

    public void processarCarregarForm(IFormulario frame, PluginFormAbstrato form, Collection<Component> componentes) {
        IFormularioEstrategiaSwingFactory factory = this.getFormularioEstrategiaSwingFactory();
        for (Component componente : componentes) {
            IFormularioEstrategiaSwing estrategia = factory.getEstrategia(componente);
            Object valor = estrategia.getValor(componente);
            String nome = null;
            try {
                nome = componente.getName();
                if (UtilString.isVazio(nome)) continue;
                UtilReflexaoSet.set(form, nome, valor);
            }
            catch (ReflexaoException e) {
                System.out.println(form);
                System.out.println(nome);
                System.out.println(valor);
                Log.getInstance().logMsg(e);
            }
        }
    }

    protected PluginFormAbstrato getForm(IFormulario frame) {
        return frame.getForm();
    }

    protected IFormulario getIFormulario(Component componente) {
        Component resultado = null;
        if (this.isReferencia(componente)) {
            AccessibleContext ac = componente.getAccessibleContext();
            resultado = (Component)((Object)ac.getAccessibleParent());
            while (!UtilObjeto.isObjetoDoTipo(resultado, IFormulario.class)) {
                ac = resultado.getAccessibleContext();
                resultado = (Component)((Object)ac.getAccessibleParent());
            }
        }
        return (IFormulario)((Object)resultado);
    }

    protected Component getComponente(ActionEvent evento) {
        return (Component)evento.getSource();
    }

    protected Collection<Component> getComponentes(Component componente) {
        List colecao = this.getColecaoFactory().novoArrayList();
        if (this.isReferencia(componente)) {
            AccessibleContext ac = componente.getAccessibleContext();
            int i = 0;
            while (i < ac.getAccessibleChildrenCount() && this.isComponente(ac.getAccessibleChild(i))) {
                Component c = (Component)((Object)ac.getAccessibleChild(i));
                if (this.isObjetoDeFormulario(c)) {
                    colecao.add(c);
                } else {
                    colecao.addAll(this.getComponentes(c));
                }
                ++i;
            }
        }
        return colecao;
    }

    protected Map<String, Component> getMapaDeComponentes(Component componente) {
        Map mapa = this.getColecaoFactory().novoHashMap();
        if (this.isReferencia(componente)) {
            AccessibleContext ac = componente.getAccessibleContext();
            int i = 0;
            while (i < ac.getAccessibleChildrenCount() && this.isComponente(ac.getAccessibleChild(i))) {
                Component c = (Component)((Object)ac.getAccessibleChild(i));
                if (this.isObjetoDeFormulario(c)) {
                    mapa.put(c.getName(), c);
                } else {
                    mapa.putAll(this.getMapaDeComponentes(c));
                }
                ++i;
            }
        }
        return mapa;
    }

    protected String getMensagensDaValidacao(PluginFormAbstrato form) {
        StringBuffer mensagem = this.novoStringBuffer();
        if (UtilObjeto.isReferencia(form)) {
            ValidacaoBean vb = this.getPrimeiroValidacaoBean(form);
            mensagem.append(vb.getMensagem());
        }
        return mensagem.toString();
    }

    protected String getNomeDoMetodoPosNaVisao(PluginActionAbstrato action) {
        String prefixo = this.getNomeDoMetodoPosNaVisao();
        String sufixo = UtilObjeto.getNomeSemPacote(action);
        return this.getNomeDoMetodo(prefixo, sufixo);
    }

    protected String getNomeDoMetodoPosFinalNaVisao(PluginActionAbstrato action) {
        String prefixo = this.getNomeDoMetodoPosFinalNaVisao();
        String sufixo = UtilObjeto.getNomeSemPacote(action);
        return this.getNomeDoMetodo(prefixo, sufixo);
    }

    protected String getNomeDoMetodoPreNaVisao(PluginActionAbstrato action) {
        String prefixo = this.getNomeDoMetodoPreNaVisao();
        String sufixo = UtilObjeto.getNomeSemPacote(action);
        return this.getNomeDoMetodo(prefixo, sufixo);
    }

    protected String getNomeDoMetodo(String prefixo, String sufixo) {
        StringBuffer metodo = this.novoStringBuffer();
        metodo.append(prefixo);
        metodo.append(sufixo);
        return metodo.toString();
    }

    protected String getNomeDoMetodoPosNaVisao() {
        return "posExecucao";
    }

    protected String getNomeDoMetodoPosFinalNaVisao() {
        return "posExecucaoFinal";
    }

    protected String getNomeDoMetodoPreNaVisao() {
        return "preExecucao";
    }

    protected boolean isValidado(PluginFormAbstrato form) {
        boolean validacao = true;
        if (this.isPermitirValidacaoDoFormulario(form)) {
            validacao = form.isValidado();
        }
        return validacao;
    }

    protected boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }

    protected boolean isObjetoDeFormulario(Component componente) {
        return this.getFormularioEstrategiaSwingFactory().isExisteEstrategia(componente);
    }

    protected ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }

    protected IFormularioEstrategiaSwingFactory getFormularioEstrategiaSwingFactory() {
        return PluginFormularioEstrategiaSwingFactory.getInstancia();
    }

    protected boolean isAcaoConfirmada(PluginActionAbstrato action, IFormulario frame) {
        boolean resultado = true;
        if (this.isAcaoDeConfirmacao(action)) {
            String mensagem = ((IActionDeConfirmacao)((Object)action)).getMensagemDeConfirmacao();
            int r = BBJPopupMensagem.exibirMensagemPergunta(mensagem);
            resultado = UtilValidadorDeNumerosIguais.validar(r, 0);
        }
        return resultado;
    }

    protected boolean isAcaoDeConfirmacao(PluginActionAbstrato action) {
        return UtilObjeto.isObjetoDoTipo(action, IActionDeConfirmacao.class);
    }

    @Override
    public void inicialize(Map context) {
        this.setContexto(context);
    }

    @Override
    public void setControlableView(ControlableView visao) {
        this.setVisao(visao);
    }

    public Map getContexto() {
        return this.contexto;
    }

    public void setContexto(Map contexto) {
        this.contexto = contexto;
    }

    public ControlableView getVisao() {
        return this.visao;
    }

    public void setVisao(ControlableView visao) {
        this.visao = visao;
    }

    protected StringBuffer novoStringBuffer() {
        return new StringBuffer();
    }

    protected ConfiguracaoDaAuditoria getConfiguracaoDaAuditoria() {
        return ConfiguracaoDaAuditoria.getInstancia();
    }

    private boolean isPermitirValidacaoDoFormulario(PluginFormAbstrato form) {
        boolean permissao = false;
        if (this.isReferencia(form)) {
            permissao = form.isPermitirValidacao();
        }
        return permissao;
    }

    private boolean isComponente(Object objeto) {
        return UtilObjeto.isObjetoDoTipo(objeto, Component.class);
    }

    private Component getComponenteInvalido(IFormulario frame, Map<String, Component> componentes) {
        ValidacaoBean vb = this.getPrimeiroValidacaoBean(frame);
        return componentes.get(vb.getPropriedade());
    }

    private ValidacaoBean getPrimeiroValidacaoBean(IFormulario frame) {
        PluginFormAbstrato form = this.getForm(frame);
        return this.getPrimeiroValidacaoBean(form);
    }

    private ValidacaoBean getPrimeiroValidacaoBean(PluginFormAbstrato form) {
        Collection<ValidacaoBean> c = form.getColecaoMensagensDeValidacao();
        ValidacaoBean vb = (ValidacaoBean)UtilColecao.getElementoDoIndice(c, 0);
        return vb;
    }
}

