/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.menu;

import br.com.bb.plugins.gac.util.interceptor.ConfiguracaoDaAuditoria;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.menu.BBJAbaServico;
import br.com.politec.generico.objeto.UtilObjeto;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJBarraServicos
extends JPanel {
    private ActionListener listener;
    private ImageIcon imgLogo = null;
    private String image = "/images/BBGestaoMaxbnrTitulo.jpg";
    private JPanel pnlBotoes = null;
    private JPanel pnlSubMenu = null;
    private BBJAbaServico objAtivo = null;
    private BBJAbaServico submenuAtivo = null;
    private Map<String, BBJAbaServico> servicos;
    private BBJEstilos estilo = BBJEstilos.BARRASERVICOS;

    public BBJBarraServicos() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(150, 55));
        this.setMaximumSize(new Dimension(3500, 55));
        this.add((Component)this.getPanelBotoes(), "North");
        this.add((Component)this.getPanelSubMenu(), "Center");
        this.imgLogo = new ImageIcon(this.getClass().getResource(this.image));
    }

    private int getPosicaoLinhaDir() {
        double d_tam = 0.0;
        int icnt = 0;
        while (icnt < this.getPanelBotoes().getComponentCount()) {
            Component cmp = this.getPanelBotoes().getComponent(icnt);
            d_tam += (double)cmp.getWidth();
            if (cmp == this.objAtivo) break;
            ++icnt;
        }
        return (int)d_tam;
    }

    private int getPosicaoLinhaEsq() {
        double d_tam = 0.0;
        int icnt = 0;
        while (icnt < this.getPanelBotoes().getComponentCount()) {
            Component cmp = this.getPanelBotoes().getComponent(icnt);
            if (cmp == this.objAtivo) break;
            d_tam += (double)cmp.getWidth();
            ++icnt;
        }
        return (int)d_tam;
    }

    public void InativaBotaoAtivo() {
        if (this.objAtivo != null) {
            this.objAtivo.setAtivado(false);
        }
    }

    private void InativaSubMenuAtivo() {
        if (this.submenuAtivo != null) {
            this.submenuAtivo.setAtivado(false);
        }
    }

    protected void Refresh(ActionEvent e) {
        this.LimpaSubMenu();
        if (this.objAtivo != null && this.objAtivo.hasChildren()) {
            this.CarregaSubMenus();
            this.updateUI();
            this.fireAction("CLEARDESKTOP:");
        } else {
            this.updateUI();
            this.fireAction(e);
        }
    }

    private void RefreshSubMenu(ActionEvent e) {
        if (this.submenuAtivo != null) {
            this.updateUI();
            this.fireAction(e);
        }
    }

    private void CarregaSubMenus() {
        Iterator<BBJAbaServico> itr = this.objAtivo.getChildren().values().iterator();
        this.getPanelSubMenu().add(Box.createHorizontalStrut(200), 0);
        int icntmnu = 0;
        while (itr.hasNext()) {
            BBJAbaServico abaservsubm = itr.next();
            abaservsubm.setSize();
            abaservsubm.setAtivado(false);
            abaservsubm.setTipobotao(2);
            abaservsubm.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    BBJBarraServicos.this.Refresh();
                }
            });
            abaservsubm.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BBJAbaServico obj = (BBJAbaServico)e.getSource();
                    if (obj == BBJBarraServicos.this.submenuAtivo) {
                        return;
                    }
                    obj.setAtivado(true);
                    BBJBarraServicos.this.InativaSubMenuAtivo();
                    BBJBarraServicos.this.submenuAtivo = obj;
                    BBJBarraServicos.this.RefreshSubMenu(e);
                }
            });
            if (icntmnu > 0) {
                JPanel sep = new JPanel();
                sep.setBackground(Color.GRAY);
                sep.setMaximumSize(new Dimension(1, 10));
                sep.setPreferredSize(new Dimension(1, 10));
                this.getPanelSubMenu().add(sep);
            }
            this.getPanelSubMenu().add(abaservsubm);
            ++icntmnu;
        }
        this.updateUI();
    }

    protected void Refresh() {
        this.updateUI();
    }

    private JPanel getPanelBotoes() {
        if (this.pnlBotoes == null) {
            this.pnlBotoes = new JPanel();
            this.pnlBotoes.setLayout(new BoxLayout(this.pnlBotoes, 0));
            this.pnlBotoes.setAlignmentY(1.0f);
            this.pnlBotoes.setBackground(Color.WHITE);
            this.pnlBotoes.setPreferredSize(new Dimension(0, 32));
            this.pnlBotoes.setMaximumSize(new Dimension(0, 32));
            this.pnlBotoes.add(Box.createHorizontalStrut(200), 0);
        }
        return this.pnlBotoes;
    }

    private JPanel getPanelSubMenu() {
        if (this.pnlSubMenu == null) {
            this.pnlSubMenu = new JPanel();
            this.pnlSubMenu.setLayout(new BoxLayout(this.pnlSubMenu, 0));
            this.pnlSubMenu.setAlignmentY(1.0f);
            this.pnlSubMenu.setBackground(Color.WHITE);
            this.pnlSubMenu.setPreferredSize(new Dimension(0, 23));
            this.pnlSubMenu.setMaximumSize(new Dimension(0, 23));
        }
        return this.pnlSubMenu;
    }

    private void LimpaSubMenu() {
        this.submenuAtivo = null;
        this.getPanelSubMenu().removeAll();
    }

    @Override
    public void paint(Graphics g) {
        int iposdir;
        super.paint(g);
        super.paintChildren(g);
        int posicy = this.imgLogo.getIconHeight() + 18;
        g.setColor(this.estilo.getBackcolor());
        g.drawImage(this.imgLogo.getImage(), 21, 14, null, null);
        if (this.getPosicaoLinhaEsq() > 0) {
            g.fillRect(12, posicy - 2, this.getPosicaoLinhaEsq() - 11, 1);
        }
        if ((iposdir = this.getPosicaoLinhaDir() - 2) < 12) {
            iposdir = 12;
        }
        g.fillRect(iposdir, posicy - 2, (int)this.getSize().getWidth() - 30, 1);
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public void fireAction(ActionEvent event) {
        if (this.listener != null) {
            this.listener.actionPerformed(event);
            this.adicionarCodigoParaAuditoria(event.getSource());
        }
    }

    private void adicionarCodigoParaAuditoria(Object objeto) {
        if (UtilObjeto.isObjetoDoTipo(objeto, BBJAbaServico.class)) {
            BBJAbaServico aba = (BBJAbaServico)objeto;
            String codigo = aba.getCodigoAuditoria();
            this.getConfiguracaoDaAuditoria().setTextoIdentificadorServico(codigo);
        }
    }

    private ConfiguracaoDaAuditoria getConfiguracaoDaAuditoria() {
        return ConfiguracaoDaAuditoria.getInstancia();
    }

    public void fireAction(String command) {
        ActionEvent evt = new ActionEvent(this, 2008, command);
        this.fireAction(evt);
    }

    public Map<String, BBJAbaServico> getServicos() {
        return this.servicos;
    }

    public void setServicos(Map<String, BBJAbaServico> servicos) {
        this.servicos = servicos;
    }

    public void removerServicos() {
        this.getPanelBotoes().removeAll();
        this.getPanelSubMenu().removeAll();
        this.updateUI();
    }

    public void loadServicos() {
        this.getPanelBotoes().removeAll();
        this.getPanelSubMenu().removeAll();
        if (this.servicos == null) {
            this.updateUI();
            return;
        }
        this.objAtivo = null;
        Iterator<BBJAbaServico> itr = this.servicos.values().iterator();
        this.getPanelBotoes().add(Box.createHorizontalStrut(200), 0);
        while (itr.hasNext()) {
            BBJAbaServico abaserv = itr.next();
            abaserv.setSize();
            abaserv.setAtivado(false);
            abaserv.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    BBJBarraServicos.this.Refresh();
                }
            });
            abaserv.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BBJAbaServico obj = (BBJAbaServico)e.getSource();
                    if (obj == BBJBarraServicos.this.objAtivo) {
                        return;
                    }
                    obj.setAtivado(true);
                    BBJBarraServicos.this.InativaBotaoAtivo();
                    BBJBarraServicos.this.objAtivo = obj;
                    BBJBarraServicos.this.Refresh(e);
                }
            });
            this.getPanelBotoes().add(abaserv);
        }
        this.updateUI();
    }
}

