/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.menu;

import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JMenu;

public class BBJMenu
extends JMenu {
    private BBJEstilos estilo;
    private ImageIcon imageFundo = new ImageIcon(this.getClass().getResource("/images/fundoAzulTesteira.jpg"));
    private String texto;
    private int altura = 25;
    private int alturatexto = 6;
    private int tamanhotexto = 30;
    private boolean menuprincipal = false;

    public BBJMenu(String texto) {
        this(texto, false);
    }

    public BBJMenu(String texto, boolean menuprincipal) {
        this.texto = texto;
        this.menuprincipal = menuprincipal;
        this.estilo = BBJEstilos.TEXTOBARRAMENU;
        this.setFont(this.estilo.getFont());
        if (this.isMenuprincipal()) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setForeground(this.estilo.getColor());
            FontRenderContext frc = new FontRenderContext(null, true, false);
            Rectangle2D bounds = this.getFont().getStringBounds(this.texto, frc);
            this.alturatexto = (int)bounds.getHeight();
            this.tamanhotexto = (int)bounds.getWidth();
            this.setSize(new Dimension(this.tamanhotexto + 16, this.altura));
        } else {
            super.setText(texto);
            this.setBackground(this.estilo.getBackcolor());
        }
    }

    public void setSize(Dimension dim) {
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.isMenuprincipal()) {
            Dimension dim = this.getSize();
            int icnt = 0;
            while (icnt < dim.width) {
                g.drawImage(this.imageFundo.getImage(), icnt, 0, null, null);
                icnt += this.imageFundo.getIconWidth();
            }
            g.setColor(this.estilo.getColor());
            int posicy = (int)((this.getSize().getHeight() + (double)this.alturatexto) / 2.0) - 2;
            g.drawString(this.texto, 8, posicy);
        }
    }

    public boolean isMenuprincipal() {
        return this.menuprincipal;
    }

    public void setMenuprincipal(boolean menuprincipal) {
        this.menuprincipal = menuprincipal;
    }
}

