/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.menu;

import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.PluginInfo;
import br.com.bb.plugins.gac.util.ServicoInfo;
import br.com.bb.plugins.gac.util.controller.view.Plugin;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJProgressBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JPanel;

public class BBJMenuInferior
extends JPanel {
    private BBJProgressBar barraProgresso = null;
    private JPanel panelConvenente = null;
    private JPanel panelUsuario = null;
    private String convenente = "";
    private String usuario = "";
    private Plugin pluginAtivo = null;
    private JPanel panelData = null;
    private JPanel panelInfo = null;
    private JPanel panelTelefones = null;
    private Dimension sizeResolution;

    public BBJMenuInferior() {
        this.initialize();
    }

    private void initialize() {
        Dimension dim = new Dimension(0, 30);
        this.setOpaque(false);
        this.setPreferredSize(dim);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.ipady = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.getPanelInfo(), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.35;
        this.add((Component)this.getPanelConvenente(), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.15;
        this.add((Component)this.getPanelUsuario(), gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, this.getLeft(), 0, 0);
        this.add((Component)this.getPanelTelefones(), gbc);
    }

    public JPanel getPanelTelefones() {
        if (this.panelTelefones == null) {
            this.panelTelefones = new JPanel(){

                public void paint(Graphics g) {
                    super.paint(g);
                    g.setColor(BBJEstilos.TEXTOMENURODAPE.getColor());
                    g.setFont(BBJEstilos.TEXTOMENURODAPE.getFont());
                    g.drawString("Suporte T\u00e9cnico:", 4, 10);
                    g.setColor(BBJEstilos.TEXTOMENURODAPEBOLD.getColor());
                    g.setFont(BBJEstilos.TEXTOMENURODAPEBOLD.getFont());
                    g.drawString(new String("4004-0001 (capitais e regi\u00f5es metropolitanas) e 0800-729-0001 (demais localidades)"), 89, 10);
                    g.setColor(BBJEstilos.TEXTOMENURODAPE.getColor());
                    g.setFont(BBJEstilos.TEXTOMENURODAPE.getFont());
                    g.drawString(new String("SAC:"), 555, 10);
                    g.setColor(BBJEstilos.TEXTOMENURODAPEBOLD.getColor());
                    g.setFont(BBJEstilos.TEXTOMENURODAPEBOLD.getFont());
                    g.drawString(new String("0800-729-0722"), 580, 10);
                    g.setColor(BBJEstilos.TEXTOMENURODAPE.getColor());
                    g.setFont(BBJEstilos.TEXTOMENURODAPE.getFont());
                    g.drawString(new String("Ouvidoria:"), 676, 10);
                    g.setColor(BBJEstilos.TEXTOMENURODAPEBOLD.getColor());
                    g.setFont(BBJEstilos.TEXTOMENURODAPEBOLD.getFont());
                    g.drawString(new String("0800-729-5678"), 726, 10);
                }
            };
            this.panelTelefones.setOpaque(false);
        }
        return this.panelTelefones;
    }

    private int getLeft() {
        this.sizeResolution = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.sizeResolution.getWidth() <= 800.0) {
            return 0;
        }
        if (this.sizeResolution.getWidth() <= 1024.0) {
            return 100;
        }
        if (this.sizeResolution.getWidth() <= 1152.0) {
            return 180;
        }
        if (this.sizeResolution.getWidth() <= 1280.0) {
            return 280;
        }
        if (this.sizeResolution.getWidth() <= 1366.0) {
            return 320;
        }
        if (this.sizeResolution.getWidth() <= 1440.0) {
            return 400;
        }
        if (this.sizeResolution.getWidth() <= 1680.0) {
            return 440;
        }
        return 500;
    }

    protected String getVersao() {
        String versao = "";
        try {
            PluginInfo gacInfo = ServicoInfo.getInstance().GetFileInfoGAC();
            return gacInfo.getVersao();
        }
        catch (Exception e) {
            e.printStackTrace();
            return versao;
        }
    }

    public JPanel getPanelInfo() {
        if (this.panelInfo == null) {
            this.panelInfo = new JPanel(new FlowLayout()){

                public void paint(Graphics g) {
                    super.paint(g);
                    g.setColor(BBJEstilos.TEXTOMENURODAPE.getColor());
                    g.setFont(BBJEstilos.TEXTOMENURODAPE.getFont());
                    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
                    String dataAtual = df.format(new Date());
                    g.drawString("Data atual:", 4, 10);
                    g.setFont(BBJEstilos.TEXTOMENURODAPEBOLD.getFont());
                    g.drawString(dataAtual, 57, 10);
                    if (BBJMenuInferior.this.getPlugin() != null) {
                        g.setFont(BBJEstilos.TEXTOMENURODAPE.getFont());
                        String modulo = "M\u00f3dulo " + BBJMenuInferior.this.getPlugin().getTitulo() + " - ";
                        g.drawString(modulo, 120, 10);
                        g.setFont(BBJEstilos.TEXTOMENURODAPEBOLD.getFont());
                        g.drawString(BBJMenuInferior.this.pluginAtivo.getVersao(), modulo.length() * 5 + 120, 10);
                    }
                    g.setColor(BBJEstilos.TEXTOMENURODAPE.getColor());
                    g.setFont(BBJEstilos.TEXTOMENURODAPE.getFont());
                    String banco = new String("BD: ");
                    g.drawString(banco, 360, 10);
                    g.setColor(BBJEstilos.TEXTOMENURODAPEBOLD.getColor());
                    g.setFont(BBJEstilos.TEXTOMENURODAPEBOLD.getFont());
                    g.drawString(this.getTipoDeInstalacaoBancoDeDados(), 380, 10);
                }

                private String getTipoDeInstalacaoBancoDeDados() {
                    return ConfiguracaoProperties.getConfiguracaoProperties().getTipoInstalacaoBancoDados().equals("1") ? "N\u00e3o Compartilhado" : "Compartilhado";
                }
            };
            this.panelInfo.setOpaque(false);
        }
        return this.panelInfo;
    }

    public void setPanelBarra(JPanel panelBarra) {
        this.panelInfo = panelBarra;
    }

    public BBJProgressBar getBarraProgresso() {
        if (this.barraProgresso == null) {
            this.barraProgresso = new BBJProgressBar(100L);
            this.barraProgresso.setPreferredSize(new Dimension(0, 15));
            this.barraProgresso.setVisible(false);
        }
        return this.barraProgresso;
    }

    public JPanel getPanelConvenente() {
        if (this.panelConvenente == null) {
            this.panelConvenente = new JPanel(){

                public void paint(Graphics g) {
                    super.paint(g);
                    g.setColor(BBJEstilos.TEXTOMENURODAPE.getColor());
                    g.setFont(BBJEstilos.TEXTOMENURODAPE.getFont());
                    g.drawString("Convenente:", 4, 10);
                    g.setColor(BBJEstilos.TEXTOMENURODAPEBOLD.getColor());
                    g.setFont(BBJEstilos.TEXTOMENURODAPEBOLD.getFont());
                    g.drawString(BBJMenuInferior.this.getConvenente(), 68, 10);
                }
            };
            this.panelConvenente.setOpaque(false);
        }
        return this.panelConvenente;
    }

    public JPanel getPanelUsuario() {
        if (this.panelUsuario == null) {
            this.panelUsuario = new JPanel(){

                public void paint(Graphics g) {
                    super.paint(g);
                    g.setColor(BBJEstilos.TEXTOMENURODAPE.getColor());
                    g.setFont(BBJEstilos.TEXTOMENURODAPE.getFont());
                    g.drawString("Usu\u00e1rio:", 4, 10);
                    g.setColor(BBJEstilos.TEXTOMENURODAPEBOLD.getColor());
                    g.setFont(BBJEstilos.TEXTOMENURODAPEBOLD.getFont());
                    g.drawString(BBJMenuInferior.this.getUsuario(), 47, 10);
                }
            };
            this.panelUsuario.setOpaque(false);
        }
        return this.panelUsuario;
    }

    public String getConvenente() {
        return this.convenente != null ? this.convenente : "";
    }

    public void setConvenente(String convenente) {
        this.convenente = convenente;
        this.getPanelConvenente().repaint();
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
        this.getPanelUsuario().repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        Rectangle r = this.getBounds();
        g.setColor(new Color(247, 224, 106));
        g.drawLine(0, 0, r.width, 0);
        g.setColor(new Color(226, 226, 226));
        g.drawLine(0, 2, r.width, 2);
    }

    public Plugin getPlugin() {
        return this.pluginAtivo;
    }

    public void setPluginAtivo(Plugin pluginAtivo) {
        this.pluginAtivo = pluginAtivo;
    }

    public void limparModuloAtivo() {
        this.setPluginAtivo(null);
        this.setConvenente(null);
        this.repaint();
    }
}

