/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.menu;

import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJDialogHelp;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;

public class BBJPanelTitulo
extends JPanel {
    private String titulo;
    private int palavras;
    private StringBuffer pedaco1;
    private StringBuffer pedaco2;
    private JButton btHelp;
    private boolean botaohelp = false;
    private int alinhamento = 2;

    public BBJPanelTitulo(String titulo) {
        this(titulo, 1);
    }

    public BBJPanelTitulo(String titulo, int palavras) {
        this(titulo, palavras, false);
    }

    public BBJPanelTitulo(String titulo, int palavras, boolean botaohelp) {
        this.titulo = titulo;
        this.palavras = palavras;
        this.setPreferredSize(new Dimension(0, 32));
        this.setSize(new Dimension(0, 32));
        this.setMinimumSize(new Dimension(0, 32));
        this.setMaximumSize(new Dimension(1000, 32));
        this.setFont(new Font("Arial", 0, 14));
        this.botaohelp = botaohelp;
        if (this.botaohelp) {
            FlowLayout layout = new FlowLayout();
            layout.setAlignment(2);
            this.setLayout(layout);
            this.add(this.getHelpButton());
        }
        this.setBackground(Color.WHITE);
        this.SplitTexto();
    }

    public JButton getHelpButton() {
        if (this.btHelp == null) {
            this.btHelp = new JButton();
            ImageIcon helpIcon = new ImageIcon(this.getClass().getResource("/images/btInterrogacao.gif"));
            this.btHelp.setIcon(helpIcon);
            this.btHelp.setOpaque(false);
            this.btHelp.setCursor(Cursor.getPredefinedCursor(12));
            this.btHelp.setContentAreaFilled(false);
            this.btHelp.setFocusable(false);
            this.btHelp.setVisible(true);
            this.btHelp.setBorder(BorderFactory.createEmptyBorder(3, 6, 2, 6));
            this.btHelp.setRolloverEnabled(true);
            this.btHelp.setUI(new BasicButtonUI());
            this.btHelp.setPreferredSize(new Dimension(16, 15));
            this.btHelp.setToolTipText(this.getMensagem("MH090"));
            this.btHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BBJPanelTitulo.this.AbreJanelaAjuda();
                }
            });
        }
        return this.btHelp;
    }

    protected String getMensagem(String mensagem) {
        return UtilMensagem.getInstancia().getMensagem(mensagem);
    }

    protected void AbreJanelaAjuda() {
        this.getBBJDialogHelp().pack();
        this.getBBJDialogHelp().Show();
    }

    private BBJDialogHelp getBBJDialogHelp() {
        return BBJDialogHelp.getInstance();
    }

    public void paint(Graphics g) {
        super.paint(g);
        int iposx = 5;
        int iposicy = 15;
        g.setFont(this.getFont());
        Rectangle2D textBounds = this.getFontMetrics(this.getFont()).getStringBounds(this.pedaco1.toString(), g);
        int iwidth = (int)textBounds.getWidth();
        textBounds = this.getFontMetrics(this.getFont()).getStringBounds(String.valueOf(this.pedaco1.toString()) + " " + this.pedaco2.toString(), g);
        if (this.getAlinhamento() == 0) {
            iposx = (int)(((double)this.getWidth() - textBounds.getWidth()) / 2.0);
        } else if (this.getAlinhamento() == 4) {
            iposx = (int)((double)this.getWidth() - textBounds.getWidth()) - 5;
        }
        g.setColor(new Color(139, 157, 221));
        g.drawString(this.pedaco1.toString(), iposx, iposicy);
        g.setColor(new Color(32, 71, 164));
        g.drawString(this.pedaco1.toString(), iposx + 1, iposicy);
        Rectangle2D SpaceBounds = this.getFontMetrics(this.getFont()).getStringBounds(" ", g);
        int iwidthSpace = (int)SpaceBounds.getWidth();
        g.setColor(new Color(139, 157, 221));
        g.drawString(this.pedaco2.toString(), iposx + iwidth + iwidthSpace, iposicy);
        g.setColor(new Color(32, 71, 164));
        g.drawString(this.pedaco2.toString(), iposx + iwidth + iwidthSpace + 1, iposicy);
    }

    private void SplitTexto() {
        this.pedaco1 = new StringBuffer();
        this.pedaco2 = new StringBuffer();
        if (this.titulo == null || this.titulo.length() == 0) {
            return;
        }
        Pattern p = Pattern.compile("[\\s]+");
        String[] result = p.split(this.titulo);
        int icnt = 0;
        while (icnt < result.length) {
            if (icnt < this.palavras) {
                if (this.pedaco1.toString().length() > 0) {
                    this.pedaco1.append(" ");
                }
                this.pedaco1.append(result[icnt]);
            } else {
                if (this.pedaco2.toString().length() > 0) {
                    this.pedaco2.append(" ");
                }
                this.pedaco2.append(result[icnt]);
            }
            ++icnt;
        }
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
        this.SplitTexto();
    }

    public int getPalavras() {
        return this.palavras;
    }

    public void setPalavras(int palavras) {
        this.palavras = palavras;
    }

    public int getAlinhamento() {
        return this.alinhamento;
    }

    public void setAlinhamento(int alinhamento) {
        this.alinhamento = alinhamento;
    }
}

