/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.view;

import br.com.bb.plugins.gac.apresentacao.BasicDialog;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.IFormulario;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.menu.BBJPanelGradient;
import br.com.bb.plugins.gac.util.view.BBJPanelBotoesManut;
import br.com.politec.generico.excecao.UtilExcecao;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class BBJFormPopup
extends BasicDialog
implements WindowListener {
    private JPanel jpMain;
    private PopPanelLogo jpTesteira;
    private JPanel jpContentPanel;
    private JPanel barraBotoes;
    private JPanel barra = null;
    private BBJButton btnCancelar = null;
    private String titulo;
    private String titulointerno;
    private Frame owner;
    private PluginFormAbstrato formAnterior;

    public PluginFormAbstrato getFormAnterior() {
        return this.formAnterior;
    }

    public BBJFormPopup(Frame owner) throws HeadlessException {
        super(owner);
        this.owner = owner;
        this.setModal(true);
        this.initComponent();
    }

    public BBJFormPopup(String titulo) {
        super((Frame)null, titulo, true);
        this.titulo = titulo;
        this.initComponent();
    }

    public BBJFormPopup(String titulo, String titulointerno, Dimension dim) {
        super((Frame)null, titulo, true);
        this.setSize(dim);
        this.titulo = titulo;
        this.titulointerno = titulointerno;
        this.initComponent();
    }

    public BBJFormPopup(Frame parent, String titulo, String titulointerno, Dimension dim) {
        super(parent, titulo, true);
        this.setSize(dim);
        this.titulointerno = titulointerno;
        this.initComponent();
    }

    public BBJFormPopup(String titulo, String titulointerno, Dimension dim, boolean teste) {
        super((Frame)null, titulo, true);
        this.setSize(dim);
        this.titulointerno = titulointerno;
    }

    public void initComponent() {
        this.addWindowListener(this);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.btnCancelar = new BBJButton("CANCELAR");
        this.btnCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BBJFormPopup.this.ClosePopup();
            }
        });
        super.setContentPane(this.getJpMain());
    }

    public void addPanelBotoes(BBJPanelBotoesManut panelBotoes) {
        this.getJpMain().remove(this.getBarraBotoes());
        this.getJpMain().add((Component)panelBotoes, "South");
    }

    public static void main(String[] args) {
        BBJFormPopup popup = new BBJFormPopup("Mensagem da aplica\u00e7\u00e3o", "Download de Aplicativos", new Dimension(600, 450));
        popup.Show();
    }

    public void ClosePopup() {
        this.setVisible(false);
        super.doClose(null);
    }

    public void setSize(Dimension dim) {
        super.setPreferredSize(dim);
        super.setSize(dim);
        this.Centralizar();
    }

    public void Centralizar() {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((size.width - dialogSize.width) / 2, (size.height - dialogSize.height) / 2);
    }

    public void Show() {
        this.setVisible(true);
    }

    public JPanel getJpMain() {
        if (this.jpMain == null) {
            this.jpMain = new JPanel();
            this.jpMain.setLayout(new BorderLayout());
            this.jpMain.setBackground(Color.WHITE);
            this.jpMain.add((Component)this.getJpTesteira(), "North");
            this.jpMain.add((Component)this.getContentPanel(), "Center");
            this.jpMain.add((Component)this.getBarraBotoes(), "South");
        }
        return this.jpMain;
    }

    public void setJpMain(JPanel jpMain) {
        this.jpMain = jpMain;
    }

    public JPanel getContentPanel() {
        if (this.jpContentPanel == null) {
            this.jpContentPanel = new JPanel();
            this.jpContentPanel.setLayout(new BorderLayout());
            this.jpContentPanel.setBackground(Color.WHITE);
            this.setBorder();
        }
        return this.jpContentPanel;
    }

    public void setBorder() {
        this.jpContentPanel.setBorder(BBJBordaOval.createOvalBorder(this.getTitulointerno()));
    }

    public void setContentPanel(JPanel jpContentPanel) {
        this.jpContentPanel = jpContentPanel;
        this.jpMain.add((Component)jpContentPanel, "Center");
    }

    public JPanel getJpTesteira() {
        if (this.jpTesteira == null) {
            this.jpTesteira = new PopPanelLogo();
            this.jpTesteira.setLayout(new BoxLayout(this.jpTesteira, 1));
            this.jpTesteira.add(this.getBarra());
            this.AddBarra(Color.WHITE, Color.WHITE, 1);
            this.AddBarra(new Color(247, 223, 19), new Color(241, 198, 2), 5);
            this.AddBarra(new Color(188, 140, 0), new Color(188, 140, 0), 1);
            this.AddBarra(Color.WHITE, Color.WHITE, 5);
            this.AddBarra(Color.LIGHT_GRAY, Color.LIGHT_GRAY, 1);
        }
        return this.jpTesteira;
    }

    private JPanel getBarra() {
        if (this.barra == null) {
            this.barra = new PopPanelBarra();
            this.barra.setPreferredSize(new Dimension(150, 27));
            this.barra.setMaximumSize(new Dimension(10000, 27));
            this.barra.setLayout(new BoxLayout(this.barra, 0));
        }
        return this.barra;
    }

    public JPanel getBarraBotoes() {
        if (this.barraBotoes == null) {
            this.barraBotoes = new JPanel();
            this.barraBotoes.setBackground(Color.WHITE);
            this.barraBotoes.setPreferredSize(new Dimension(0, 40));
            FlowLayout layout = new FlowLayout();
            layout.setAlignment(2);
            this.barraBotoes.setLayout(layout);
            this.barraBotoes.add(this.btnCancelar);
        }
        return this.barraBotoes;
    }

    public void habilitarBotoes(boolean status) {
        int i = 0;
        while (i < this.getBarraBotoes().getComponentCount()) {
            Component c = this.getBarraBotoes().getComponent(i);
            if (c instanceof BBJButton) {
                c.setVisible(status);
            }
            ++i;
        }
    }

    public void setBarraBotoes(JPanel jpBarraBotoes) {
        this.barraBotoes = jpBarraBotoes;
    }

    private BBJPanelGradient AddBarra(Color c1, Color c2, int altura) {
        BBJPanelGradient gtPanel = new BBJPanelGradient(c1, c2);
        if (altura > 0) {
            gtPanel.setPreferredSize(new Dimension(150, altura));
            gtPanel.setMaximumSize(new Dimension(10000, altura));
        }
        this.getJpTesteira().add(gtPanel);
        return gtPanel;
    }

    public void setJpTesteira(PopPanelLogo jpTesteira) {
        this.jpTesteira = jpTesteira;
    }

    public String getTitulointerno() {
        return this.titulointerno;
    }

    public void setTitulointerno(String titulointerno) {
        this.titulointerno = titulointerno;
    }

    public BBJButton getBtnCancelar() {
        return this.btnCancelar;
    }

    public void setBtnCancelar(BBJButton btnCancelar) {
        this.btnCancelar = btnCancelar;
    }

    public void beforeShow(Map context) {
    }

    public void doShow(Map context) {
        this.setVisible(true);
    }

    public Frame getOwner() {
        return this.owner;
    }

    public String getTitulo() {
        if (this.titulo == null) {
            return "";
        }
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.setTitle(titulo);
        this.titulo = titulo;
    }

    public void setFormAnterior(PluginFormAbstrato form) {
        this.formAnterior = form;
    }

    public void inicializaTela() {
    }

    public void posExecucaoFecharAction() {
        this.doClose(null);
    }

    protected void processarMensagemDeErro(IFormulario frame, Throwable e) {
        String erro = UtilExcecao.getMensagem(e);
        String mensagem = UtilMensagem.getInstancia().getErroDeSistema(erro);
        BBJPopupMensagem.exibirMensagemErro(mensagem);
    }

    protected String getMensagem(String mensagem) {
        return UtilMensagem.getInstancia().getMensagem(mensagem);
    }

    public void windowActivated(WindowEvent e) {
        this.setFocoNoComponente();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void setFocoNoComponente() {
    }

    public boolean fechada() {
        return false;
    }

    private class PopPanelBarra
    extends JPanel {
        private ImageIcon imgFundo = null;

        public PopPanelBarra() {
            this.initialize();
        }

        private void initialize() {
            this.imgFundo = new ImageIcon(this.getClass().getResource("/images/fundoAzulTesteira.jpg"));
        }

        public void paint(Graphics g) {
            super.paint(g);
            Dimension dim = this.getSize();
            int icnt = 0;
            if (this.imgFundo != null && this.imgFundo.getIconWidth() > 0) {
                while ((double)icnt < dim.getWidth()) {
                    g.drawImage(this.imgFundo.getImage(), icnt, 0, null, null);
                    icnt += this.imgFundo.getIconWidth();
                }
            }
            super.paintChildren(g);
        }
    }

    private class PopPanelLogo
    extends JPanel {
        private ImageIcon imgLogo;
        private String image;

        public PopPanelLogo() {
            this("/images/Logo_BB.jpg");
        }

        public PopPanelLogo(String image) {
            this.image = image;
            this.setBackground(Color.WHITE);
            this.setPreferredSize(new Dimension(0, 78));
            this.setLayout(new BoxLayout(this, 1));
            this.imgLogo = new ImageIcon(this.getClass().getResource(this.image));
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.drawImage(this.imgLogo.getImage(), (int)this.getSize().getWidth() - (10 + this.imgLogo.getIconWidth()), 6, null, null);
        }
    }
}

