/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.view;

import br.com.bb.plugins.gac.negocio.to.PluginTOAbstrato;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.view.ItemPermissao;
import br.com.bb.plugins.gac.util.view.JCheckBoxLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJItemPermissao
extends JPanel
implements ItemPermissao {
    private String id;
    private String texto;
    private int nivel;
    private boolean expanded;
    private PluginTOAbstrato pluginTOAbstrato;
    private ActionListener listener;
    private boolean marcado = false;
    private boolean inativo = false;
    private static final int NUMERO_MAXIMO_ITENS = 2;
    private String titulo;
    private List<JCheckBoxLabel> listCheckBox = null;

    @Override
    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int getNivel() {
        return this.nivel;
    }

    @Override
    public void setNivel(int nivel) {
        this.nivel = nivel;
    }

    @Override
    public void setNivel(int nivel, boolean haschild) {
    }

    @Override
    public Map<String, ItemPermissao> getChildren() {
        return null;
    }

    @Override
    public void addChild(ItemPermissao child) {
        JCheckBoxLabel checkBoxLabel = new JCheckBoxLabel(child.getId(), child.getTexto());
        checkBoxLabel.setPluginTOAbstrato(child.getPluginTOAbstrato());
        checkBoxLabel.setSelected(child.isMarcado());
        checkBoxLabel.setInativo(child.isInativo());
        this.getListCheckBox().add(checkBoxLabel);
    }

    @Override
    public void ShowChildren() {
    }

    @Override
    public void ShowOrHide() {
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public void HideChildren() {
    }

    public List<JCheckBoxLabel> getListCheckBox() {
        if (this.listCheckBox == null) {
            this.listCheckBox = new ArrayList<JCheckBoxLabel>();
        }
        return this.listCheckBox;
    }

    public BBJItemPermissao(String titulo) {
        this.titulo = titulo;
        this.nivel = 3;
    }

    public BBJItemPermissao(String titulo, List<JCheckBoxLabel> itens) {
        this.titulo = titulo;
        this.listCheckBox = itens;
    }

    public void setItensCustomizados(List<JCheckBoxLabel> itens) {
        this.listCheckBox = itens;
    }

    public JCheckBoxLabel getItemPermisao(int item) {
        return this.listCheckBox.get(item);
    }

    public void initComponents() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.GRAY)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.ipadx = 1;
        gbc.gridheight = this.GetAlturaLabel();
        gbc.weightx = 0.2;
        BBJPanelLabelPermissoes label = new BBJPanelLabelPermissoes(this.titulo);
        label.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox chkl = (JCheckBox)e.getSource();
                BBJItemPermissao.this.MarcaDesmarcaTodos(chkl.isSelected());
            }
        });
        this.add((Component)label, gbc);
        int gridx = 1;
        gbc.weightx = 0.2;
        gbc.gridheight = 1;
        boolean marcatodos = true;
        boolean todosativo = true;
        if (this.listCheckBox != null) {
            for (JCheckBoxLabel check : this.listCheckBox) {
                gbc.gridx = gridx;
                gbc.weightx = 0.3;
                this.add((Component)check, gbc);
                marcatodos = marcatodos ? check.isSelected() : false;
                boolean bl = todosativo = todosativo ? check.isInativo() : false;
                if (++gridx != 3) continue;
                gridx = 1;
            }
        }
        label.getChecktodos().setSelected(marcatodos);
        label.getChecktodos().setInativo(todosativo);
        while (gridx > 1 && gridx < 3) {
            gbc.gridx = gridx++;
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            Dimension dim = new Dimension(100, 20);
            panel.setPreferredSize(dim);
            this.add((Component)panel, gbc);
        }
    }

    private void MarcaDesmarcaTodos(boolean selected) {
        for (JCheckBoxLabel check : this.listCheckBox) {
            if (check.isInativo()) continue;
            check.setSelected(selected);
            check.updateUI();
            check.validate();
        }
    }

    private int GetAlturaLabel() {
        return this.getCount() / 3 + (this.getCount() % 3 > 0 ? 1 : 0);
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public int getCount() {
        return this.getListCheckBox().size();
    }

    @Override
    public String getTexto() {
        return this.texto;
    }

    @Override
    public void setTexto(String texto) {
        this.texto = texto;
    }

    @Override
    public void setVisible(boolean visible) {
        this.updateUI();
        super.setVisible(visible);
    }

    public Collection<PluginTOAbstrato> getItensSelecionados() {
        ArrayList<PluginTOAbstrato> listaChecked = new ArrayList<PluginTOAbstrato>(1);
        if (this.listCheckBox != null) {
            for (JCheckBoxLabel check : this.listCheckBox) {
                if (!check.isSelected() || check.isInativo()) continue;
                listaChecked.add(check.getPluginTOAbstrato());
            }
        }
        return listaChecked;
    }

    @Override
    public boolean isMarcado() {
        return this.marcado;
    }

    @Override
    public void setMarcado(boolean marcado) {
        this.marcado = marcado;
    }

    public void setPluginTOAbstrato(PluginTOAbstrato pluginTOAbstrato) {
        this.pluginTOAbstrato = pluginTOAbstrato;
    }

    @Override
    public PluginTOAbstrato getPluginTOAbstrato() {
        return this.pluginTOAbstrato;
    }

    @Override
    public boolean isInativo() {
        return this.inativo;
    }

    @Override
    public void setInativo(boolean inativo) {
        this.inativo = inativo;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setListener(ActionListener listener) {
        this.listener = listener;
    }

    public ActionListener getListener() {
        return this.listener;
    }

    @Override
    public boolean hasChildrenComTexto() {
        return false;
    }

    private class BBJPanelLabelPermissoes
    extends JPanel {
        private JPanel panelMain = null;
        private String titulo;
        private JCheckBoxLabel checktodos = null;
        private ActionListener listener;

        public void addActionListener(ActionListener listener) {
            this.listener = listener;
        }

        public BBJPanelLabelPermissoes(String titulo) {
            this.titulo = titulo;
            this.setOpaque(false);
            Dimension dim = new Dimension(200, 30);
            this.initComponents(dim);
        }

        private void initComponents(Dimension dim) {
            this.setPreferredSize(dim);
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.setSize(dim);
            this.add((Component)this.getPanelMain(), "West");
        }

        public JPanel getPanelMain() {
            if (this.panelMain == null) {
                this.panelMain = new JPanel();
                this.panelMain.setOpaque(false);
                this.panelMain.setLayout(new BoxLayout(this.panelMain, 0));
                this.panelMain.add(new JPanelTitulo(this.titulo));
                this.panelMain.add(this.getChecktodos());
            }
            return this.panelMain;
        }

        public String getTitulo() {
            return this.titulo;
        }

        public void setTitulo(String titulo) {
            this.titulo = titulo;
        }

        public JCheckBoxLabel getChecktodos() {
            if (this.checktodos == null) {
                this.checktodos = new JCheckBoxLabel("TODOS", "Todos");
                this.checktodos.setOpaque(false);
                this.checktodos.setPreferredSize(new Dimension(80, 22));
                this.checktodos.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (BBJPanelLabelPermissoes.this.listener != null) {
                            BBJPanelLabelPermissoes.this.listener.actionPerformed(e);
                        }
                    }
                });
            }
            return this.checktodos;
        }

        public void paint(Graphics g) {
            super.paint(g);
        }

        private class JPanelTitulo
        extends JPanel {
            private String titulo;

            public JPanelTitulo(String titulo) {
                this.titulo = titulo;
                this.initComponents();
            }

            private void initComponents() {
                Dimension dim = new Dimension(230, 22);
                this.setOpaque(false);
                this.setPreferredSize(dim);
                this.setMaximumSize(dim);
            }

            public void paint(Graphics g) {
                super.paint(g);
                g.setFont(BBJEstilos.LABELTEXTO.getFont());
                g.setColor(BBJEstilos.LABELTEXTO.getColor());
                g.drawString(this.titulo, 5, 16);
            }

            public String getTitulo() {
                return this.titulo;
            }

            public void setTitulo(String titulo) {
                this.titulo = titulo;
            }
        }
    }
}

