/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.view;

import br.com.bb.plugins.gac.apresentacao.atualizarsistema.view.ViewAtualizarSistema;
import br.com.bb.plugins.gac.apresentacao.atualizarsistema.view.ViewBaixarAplicativosPopup;
import br.com.bb.plugins.gac.negocio.service.AtualizarSistemaService;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.controller.view.ApplicationContextFactory;
import br.com.bb.plugins.gac.util.controller.view.ControlableListener;
import br.com.bb.plugins.gac.util.controller.view.ControlableView;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoDisponivelAtualizacaoBO;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoDisponivelInstalacaoBO;
import br.com.bb.plugins.gac.util.swing.componente.BBFileDownLoad;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewAtualizarSistemaListener
implements ActionListener,
ControlableListener {
    private ViewAtualizarSistema viewAtualizarSistema;
    private Map context = null;
    private AtualizarSistemaService atualizarSistemaService;
    private ConfiguracaoProperties config = null;
    private ViewBaixarAplicativosPopup viewBaixarAplicativosPopup;
    private boolean b_inicializado = false;

    @Override
    public void inicialize(Map context) {
        this.context = context;
        if (!this.b_inicializado) {
            this.getViewAtualizarSistema().getBBVoltar().addActionListener(this);
            this.getViewAtualizarSistema().getBBExecutar().addActionListener(this);
            this.carregaAplicativosInstalados();
            this.viewBaixarAplicativosPopup.addActionListener(this);
            this.config = ConfiguracaoProperties.getConfiguracaoProperties();
        }
        this.GetXMLConfigs();
        this.b_inicializado = true;
    }

    private void carregaAplicativosInstalados() {
        this.getViewAtualizarSistema().getTableAtualizados().getBbtModel().setDataListTabela(this.atualizarSistemaService.BuscaAplicativosInstalados());
        this.getViewAtualizarSistema().getTableAtualizados().updateUI();
    }

    private void GetXMLConfigs() {
        this.getViewAtualizarSistema().getTabpDispAtualizar().setVisible(false);
        this.getViewAtualizarSistema().getTabpDispInstalar().setVisible(false);
        Thread thread = new Thread(){

            public void run() {
                BBFileDownLoad bbdown = new BBFileDownLoad("aplicativos.xml", 0L);
                bbdown.setPath(ViewAtualizarSistemaListener.this.config.getDirTemp());
                bbdown.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (e.getActionCommand() != null && e.getActionCommand().startsWith("CONCLUIDO:")) {
                            ViewAtualizarSistemaListener.this.atualizarTabelas();
                            ViewAtualizarSistemaListener.this.getViewAtualizarSistema().getTabpDispAtualizar().setVisible(true);
                            ViewAtualizarSistemaListener.this.getViewAtualizarSistema().getTabpDispInstalar().setVisible(true);
                        } else if (e.getActionCommand() != null) {
                            e.getActionCommand().startsWith("ERRO:");
                        }
                        ViewAtualizarSistemaListener.this.getViewAtualizarSistema().revalidate();
                    }
                });
                bbdown.doDownLoad();
            }
        };
        thread.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.getViewAtualizarSistema().getBBExecutar()) {
            this.baixarAplicativos();
        } else if (obj == this.viewBaixarAplicativosPopup) {
            if ("CONCLUIDO".equalsIgnoreCase(e.getActionCommand())) {
                this.viewBaixarAplicativosPopup.ClosePopup();
                ApplicationContextFactory.getInstance().unload();
                this.viewBaixarAplicativosPopup.AtualizarPlugins();
                ApplicationContextFactory.getInstance().load();
                this.atualizarTabelas();
                this.carregaAplicativosInstalados();
                this.getViewAtualizarSistema().revalidate();
            } else if ("CANCELADO".equalsIgnoreCase(e.getActionCommand())) {
                this.viewBaixarAplicativosPopup.ClosePopup();
            }
        } else if (obj == this.getViewAtualizarSistema().getBBVoltar()) {
            this.getViewAtualizarSistema().doClose(this.context);
        }
    }

    private void baixarAplicativos() {
        List<AplicativoDisponivelAtualizacaoBO> listAtualizar = this.getViewAtualizarSistema().getTableDispAtualizar().getBbtModel().getItensSelecionados();
        List<AplicativoDisponivelInstalacaoBO> listInstalar = this.getViewAtualizarSistema().getTableDispInstalar().getBbtModel().getItensSelecionados();
        int iselecionados = listAtualizar == null ? 0 : listAtualizar.size();
        iselecionados += listInstalar == null ? 0 : listInstalar.size();
        this.viewBaixarAplicativosPopup.LimpaApplicativos();
        this.adicionaNaFilaDeDownloadAtualizacao(listAtualizar);
        this.adicionaNaFilaDeDownloadInstalacao(listInstalar);
        this.viewBaixarAplicativosPopup.Show();
    }

    private void adicionaNaFilaDeDownloadInstalacao(List<AplicativoDisponivelInstalacaoBO> listInstalar) {
        for (AplicativoDisponivelInstalacaoBO app : listInstalar) {
            this.viewBaixarAplicativosPopup.AdicionaAplicativo(app.getCodigo(), app.getAplicativo(), app.getTamanho(), app.getNomejar(), true);
        }
    }

    private void adicionaNaFilaDeDownloadAtualizacao(List<AplicativoDisponivelAtualizacaoBO> listAtualizar) {
        for (AplicativoDisponivelAtualizacaoBO app : listAtualizar) {
            this.viewBaixarAplicativosPopup.AdicionaAplicativo(app.getCodigo(), app.getAplicativo(), app.getTamanho(), app.getNomejar(), false);
        }
    }

    @Override
    public void setControlableView(ControlableView view) {
        this.viewAtualizarSistema = (ViewAtualizarSistema)view;
    }

    public ViewAtualizarSistema getViewAtualizarSistema() {
        return this.viewAtualizarSistema;
    }

    public AtualizarSistemaService getAtualizarSistemaService() {
        return this.atualizarSistemaService;
    }

    public void setAtualizarSistemaService(AtualizarSistemaService atualizarSistemaService) {
        this.atualizarSistemaService = atualizarSistemaService;
    }

    public ViewBaixarAplicativosPopup getViewBaixarAplicativos() {
        return this.viewBaixarAplicativosPopup;
    }

    public void setViewBaixarAplicativos(ViewBaixarAplicativosPopup viewBaixarAplicativosPopup) {
        this.viewBaixarAplicativosPopup = viewBaixarAplicativosPopup;
    }

    public void setViewAtualizarSistema(ViewAtualizarSistema viewAtualizarSistema) {
        this.viewAtualizarSistema = viewAtualizarSistema;
    }

    private void atualizarTabelas() {
        this.atualizarSistemaService.LerConfiguracoes();
        Vector<AplicativoDisponivelAtualizacaoBO> appatualizar = this.atualizarSistemaService.BuscaAplicativosDisponiveisAtualizacao();
        Vector<AplicativoDisponivelInstalacaoBO> appnovas = this.atualizarSistemaService.BuscaAplicativosDisponiveisInstalacao();
        this.getViewAtualizarSistema().getTableDispAtualizar().getBbtModel().setDataListTabela(appatualizar);
        this.getViewAtualizarSistema().getTableDispInstalar().getBbtModel().setDataListTabela(appnovas);
        this.getViewAtualizarSistema().getTableDispAtualizar().updateUI();
        this.getViewAtualizarSistema().getTableDispInstalar().updateUI();
    }
}

