/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.view;

import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.configurarexpurgo.action.AlterarExpurgoAction;
import br.com.bb.plugins.gac.apresentacao.configurarexpurgo.action.ConsultarAplicativosExpurgoAction;
import br.com.bb.plugins.gac.apresentacao.configurarexpurgo.form.ConfigurarExpurgoForm;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.facade.ConfigurarExpurgoFacade;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.util.PropertyList;
import br.com.bb.plugins.gac.util.controller.view.PluginController;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.PanelConfigurarExpurgo;
import br.com.politec.generico.objeto.UtilObjeto;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewConfigurarExpurgo
extends BasicInternalFrame {
    private JPanel jpMain = null;
    private JPanel jpTabela = null;
    private JPanel jpOpcoes = null;
    private JPanel jpDados = null;
    private JPanel panelBotoes = null;
    private BBJButton bntConfirmar;
    private BBJButton bntVoltar;
    private PanelConfigurarExpurgo<PropertyList> listaAplicativos = null;
    private HashMap<String, ServicoTO> cfgExpurgo;

    ConfigurarExpurgoFacade getConfigurarExpurgoFacade() {
        return new ConfigurarExpurgoFacade();
    }

    public ViewConfigurarExpurgo() {
        super("", false, false);
        this.initComponents();
    }

    @Override
    public void inicializaTela() {
        this.getConfigurarExpurgoForm().setPagamento(true);
        this.getConfigurarExpurgoForm().setServico(true);
        this.getConfigurarExpurgoForm().setRecebimento(true);
        this.getConfigurarExpurgoForm().setPermitirValidacao(true);
        ConsultarAplicativosExpurgoAction carregarExpurgoAction = this.getActionFactory().novoConsultarAplicativosExpurgoAction();
        try {
            carregarExpurgoAction.executar(this.getForm());
        }
        catch (BBException e) {
            this.processarMensagemDeErro(this, e);
        }
        this.carregaListaDeAplicativos();
    }

    private void carregaListaDeAplicativos() {
        List<ServicoTO> listaDeAplicativosInstalados = this.getConfigurarExpurgoForm().getAplicativosInstalados();
        if (UtilObjeto.isReferencia(listaDeAplicativosInstalados)) {
            ArrayList<PropertyList> listaDePropertyList = new ArrayList<PropertyList>();
            for (ServicoTO servicoTO : listaDeAplicativosInstalados) {
                if (servicoTO.getTextoIdentificadorServico().equalsIgnoreCase("CTA") || servicoTO.getTextoIdentificadorServico().equalsIgnoreCase("TOC")) continue;
                listaDePropertyList.add(new PropertyList(servicoTO.getTextoIdentificadorServico(), servicoTO.getTextoDescricao(), servicoTO));
                this.getCfgExpurgo().put(servicoTO.getTextoIdentificadorServico(), servicoTO);
            }
            PropertyList[] propertyLists = new PropertyList[listaDePropertyList.size()];
            this.getListaAplicativos().carregaLista((PropertyList[])listaDePropertyList.toArray(propertyLists));
        }
    }

    private void initComponents() {
        this.add(this.getJPMain());
        this.getForm().setPermitirValidacao(true);
    }

    public JPanel getJPMain() {
        if (this.jpMain == null) {
            this.jpMain = new JPanel();
            this.jpMain.setLayout(new BorderLayout());
            this.jpMain.setBackground(Color.WHITE);
            this.jpMain.add((Component)this.getJpTabela(), "North");
        }
        return this.jpMain;
    }

    private int getLargura() {
        int ilargura = this.getWidth() / 2;
        if (ilargura == 0) {
            ilargura = 300;
        }
        return ilargura;
    }

    public JPanel getJpTabela() {
        if (this.jpTabela == null) {
            this.jpTabela = new JPanel();
            this.jpTabela.setOpaque(false);
            this.jpTabela.setLayout(new BorderLayout());
            this.jpTabela.setSize(new Dimension(440, 450));
            this.jpTabela.add((Component)this.getJpOpcoes(), "Center");
        }
        return this.jpTabela;
    }

    public JPanel getJpOpcoes() {
        if (this.jpOpcoes == null) {
            this.jpOpcoes = new JPanel();
            this.jpOpcoes.setOpaque(false);
            this.jpOpcoes.setLayout(new BorderLayout());
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            panel.setPreferredSize(new Dimension(0, 15));
            this.jpOpcoes.add((Component)panel, "North");
            this.jpOpcoes.setSize(new Dimension(440, (int)this.getListaAplicativos().getSize().getHeight() + 100));
            this.jpOpcoes.add(this.getListaAplicativos(), "North");
            this.jpOpcoes.add((Component)this.getPainelBotoes(), "Center");
        }
        return this.jpOpcoes;
    }

    public PanelConfigurarExpurgo<PropertyList> getListaAplicativos() {
        if (this.listaAplicativos == null) {
            this.listaAplicativos = new PanelConfigurarExpurgo();
            this.listaAplicativos.setAutoscrolls(true);
        }
        return this.listaAplicativos;
    }

    private void habilitarBotoes(boolean b) {
        this.getBntConfirmar().setEnabled(b);
    }

    public void setListaAplicativos(PanelConfigurarExpurgo<PropertyList> listaAplicativos) {
        this.listaAplicativos = listaAplicativos;
    }

    public JPanel getJpDados() {
        if (this.jpDados == null) {
            this.jpDados = new JPanel();
            this.jpDados.setOpaque(false);
            this.jpDados.setLayout(new BorderLayout());
        }
        return this.jpDados;
    }

    public JPanel getPainelBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = new JPanel();
            this.panelBotoes.setSize(new Dimension(440, 30));
            FlowLayout flw = new FlowLayout();
            flw.setAlignment(1);
            this.panelBotoes.setLayout(flw);
            this.panelBotoes.add(this.getBntConfirmar());
            this.panelBotoes.add(this.getBntVoltar());
            this.panelBotoes.setOpaque(false);
        }
        return this.panelBotoes;
    }

    public void preparaTabelaExpurgo() {
        this.cfgExpurgo = this.getListaAplicativos().getConfigExpurgo();
        ServicoTO srvcModuloBasico = this.cfgExpurgo.get("GAC");
        srvcModuloBasico.setNumeroDiasRetencaoDados(this.getListaAplicativos().getDiasRetencaoDadosModuloBasico());
        this.cfgExpurgo.put("GAC", srvcModuloBasico);
        for (ServicoTO srvc : this.getConfigurarExpurgoForm().getAplicativosInstalados()) {
            if (!srvc.getTextoIdentificadorServico().equals("GAC")) {
                srvc.setNumeroDiasRetencaoDados(this.getListaAplicativos().getDiasRetencaoDadosPlugin(srvc.getTextoIdentificadorServico()));
            }
            srvc.setNumeroFrequenciaExpurgo(this.getListaAplicativos().getPeriodicidadeExpurgo());
            this.cfgExpurgo.put(srvc.getTextoIdentificadorServico(), srvc);
        }
    }

    public BBJButton getBntConfirmar() {
        if (this.bntConfirmar == null) {
            this.bntConfirmar = this.getBotaoFactory().novoBotao("CONFIRMAR", this.getAlterarExpurgoAction());
        }
        return this.bntConfirmar;
    }

    public void alteraConfiguracaoExpurgo(ArrayList<ServicoTO> listaServicos) {
        for (ServicoTO srvc : listaServicos) {
            this.getConfigurarExpurgoFacade().getConfigurarExpurgoModel().alterar(srvc);
        }
    }

    public BBJButton getBntVoltar() {
        if (this.bntVoltar == null) {
            this.bntVoltar = new BBJButton("VOLTAR");
            this.bntVoltar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewConfigurarExpurgo.this.doClose();
                }
            });
        }
        return this.bntVoltar;
    }

    public HashMap<String, ServicoTO> getCfgExpurgo() {
        if (this.cfgExpurgo == null) {
            this.cfgExpurgo = new HashMap();
        }
        return this.cfgExpurgo;
    }

    public AlterarExpurgoAction getAlterarExpurgoAction() {
        return this.getActionFactory().novoAlterarExpurgoAction();
    }

    public ConfigurarExpurgoForm getConfigurarExpurgoForm() {
        return (ConfigurarExpurgoForm)this.getForm();
    }

    public void posExecucaoAlterarExpurgoAction() {
        this.doClose();
    }

    public void preExecucaoAlterarExpurgoAction() {
        this.preparaTabelaExpurgo();
        this.getConfigurarExpurgoForm().setConfiguracaoExpurgo(this.getCfgExpurgo());
    }

    public void posExecucaoConsultarAplicativosExpurgoAction() {
        this.carregaListaDeAplicativos();
    }

    @Override
    public void doShow(Map context) {
        this.setVisible(true);
        this.inicializaTela();
    }

    public void doClose() {
        super.doClose(null);
    }

    @Override
    protected PluginFormAbstrato novoForm() {
        return this.getFormFactory().novoConfigurarExpurgoForm();
    }

    public PluginController getPluginController() {
        return new PluginController();
    }

    public static void main(String[] args) {
        JFrame frm = new JFrame();
        ViewConfigurarExpurgo configexp = new ViewConfigurarExpurgo();
        configexp.beforeShow(null);
        configexp.doShow(null);
        frm.setSize(new Dimension(800, 600));
        frm.setContentPane(configexp);
        frm.setDefaultCloseOperation(2);
        frm.setVisible(true);
    }
}

