/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.view;

import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.apresentacao.mantercadastropessoa.action.ListarCadastroPessoaAction;
import br.com.bb.plugins.gac.apresentacao.mantercadastropessoa.form.ListarCadastroPessoaForm;
import br.com.bb.plugins.gac.util.Util;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJDateChooserLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJMask;
import br.com.bb.plugins.gac.util.swing.componente.BBJMaskLabelGeral;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJRadioButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJRadioButtonLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJTextLabel;
import br.com.politec.generico.string.UtilString;
import br.com.politec.generico.validador.UtilValidadorDeCNPJ;
import br.com.politec.generico.validador.UtilValidadorDeCPF;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ViewConsultaCadastro
extends BasicInternalFrame {
    private JPanel jpMain = null;
    private JPanel painelBotoes = null;
    private JPanel painelDados = null;
    private BBJButton botaoConsultar = null;
    private BBJButton botaoFechar = null;
    private BBJRadioButtonLabel bbradio = null;
    private BBJMaskLabelGeral nInscricao = null;
    private BBJLabel FiltroNome = null;
    private BBJLabel FiltroOper = null;
    private BBJTextLabel nomeInicio = null;
    private BBJTextLabel nomeParte = null;
    private BBJTextLabel nomeFim = null;
    private BBJDateChooserLabel dataInicio = null;
    private BBJDateChooserLabel dataFim = null;
    final BBJRadioButton radioCNPJ = new BBJRadioButton("CNPJ", false, 2);
    final BBJRadioButton radioCPF = new BBJRadioButton("CPF", false, 1);
    final BBJRadioButton radioTodos = new BBJRadioButton("Todos", false, 10);
    private Map context;
    private BBJButton btnLimpar = null;

    public static void main(String[] a) {
        JFrame frm = new JFrame();
        Dimension d = new Dimension(700, 510);
        frm.setSize(d);
        frm.setPreferredSize(d);
        ViewConsultaCadastro popup = new ViewConsultaCadastro();
        frm.getContentPane().add(popup);
        popup.doShow(null);
        frm.setDefaultCloseOperation(2);
        frm.setVisible(true);
    }

    public ViewConsultaCadastro() {
        super("Consultar Cadastro", false, false);
        this.initialize();
    }

    private void initialize() {
        if (this.jpMain == null) {
            this.jpMain = new JPanel();
            this.jpMain.setOpaque(false);
            this.jpMain.setLayout(new BorderLayout());
            this.jpMain.add((Component)this.getPainelFiltros(), "North");
            this.jpMain.add((Component)this.getPainelBotoes(), "Center");
            FlowLayout flw = new FlowLayout();
            flw.setAlignment(1);
            this.setAlinhamento(0);
            this.setLayout(flw);
            this.add(this.jpMain);
        }
    }

    public void inicializaTela() {
    }

    public JPanel getRadioTipoInscricao() {
        JPanel pnl = new JPanel();
        pnl.setOpaque(false);
        if (this.bbradio == null) {
            FlowLayout flw = new FlowLayout();
            flw.setAlignment(0);
            pnl.setLayout(flw);
            this.nInscricao = this.getInscricao();
            this.nInscricao.setVisible(false);
            LinkedHashMap<String, BBJRadioButton> opcradio = new LinkedHashMap<String, BBJRadioButton>();
            this.radioTodos.setSelected(true);
            ItemListener radioListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ViewConsultaCadastro.this.montarCampos(ViewConsultaCadastro.this.radioCNPJ, ViewConsultaCadastro.this.radioCPF, ViewConsultaCadastro.this.radioTodos);
                }
            };
            this.radioCNPJ.addItemListener(radioListener);
            this.radioCPF.addItemListener(radioListener);
            this.radioTodos.addItemListener(radioListener);
            opcradio.put("opc1", this.radioTodos);
            opcradio.put("opc2", this.radioCNPJ);
            opcradio.put("opc3", this.radioCPF);
            this.bbradio = new BBJRadioButtonLabel("Tipo de Inscri\u00e7\u00e3o:", 1, opcradio);
            this.radioTodos.setToolTipText(this.getMensagem("MH013"));
            this.radioCNPJ.setToolTipText(this.getMensagem("MH013"));
            this.radioCPF.setToolTipText(this.getMensagem("MH013"));
            this.bbradio.setName("codigoTipoPessoa");
            pnl.add(this.bbradio);
        }
        return pnl;
    }

    private void ativarCampos(boolean value) {
        this.getNomeInicio().setEnabled(value);
        this.getNomeFim().setEnabled(value);
        this.getNomeParte().setEnabled(value);
        this.getDataInicio().setEnabled(value);
        this.getDataFim().setEnabled(value);
        if (value) {
            this.getNomeInicio().setText("");
            this.getNomeFim().setText("");
            this.getNomeParte().setText("");
            this.getDataInicio().limpar();
            this.getDataFim().limpar();
        }
    }

    public BBJMaskLabelGeral getInscricao() {
        if (this.nInscricao == null) {
            this.nInscricao = this.getPainelFactory().novoBBJMaskLabelGeral(null, BBJMask.TIPO_CNPJ, true, 1, 200, 10, "############################################");
            this.nInscricao.setName("numeroInscricao");
            this.nInscricao.setToolTipText(this.getMensagem("MH014"));
            this.nInscricao.getJtfCampo().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    this.colocarZerosAEsquerda();
                    String codigoDocumento = UtilString.removerCaracteres(ViewConsultaCadastro.this.nInscricao.getText());
                    String mensagemErro = "Documento Inv\u00e1lido";
                    boolean documentoValido = true;
                    switch (codigoDocumento.length()) {
                        case 11: {
                            documentoValido = UtilValidadorDeCPF.validar(codigoDocumento);
                            mensagemErro = "CPF Inv\u00e1lido";
                            break;
                        }
                        case 14: {
                            documentoValido = UtilValidadorDeCNPJ.validar(codigoDocumento);
                            mensagemErro = "CNPJ Inv\u00e1lido";
                            break;
                        }
                        default: {
                            ViewConsultaCadastro.this.nInscricao.getJtfCampo().clean();
                        }
                    }
                    if (!documentoValido) {
                        BBJPopupMensagem.exibirMensagem(mensagemErro);
                        ViewConsultaCadastro.this.nInscricao.getJtfCampo().clean();
                    }
                }

                private void colocarZerosAEsquerda() {
                    try {
                        if (ViewConsultaCadastro.this.radioCPF.isSelected()) {
                            ViewConsultaCadastro.this.nInscricao.getJtfCampo().setData(Util.strZero(UtilString.removerCaracteres(ViewConsultaCadastro.this.nInscricao.getJtfCampo().getText()), 11));
                        } else if (ViewConsultaCadastro.this.radioCNPJ.isSelected()) {
                            ViewConsultaCadastro.this.nInscricao.getJtfCampo().setData(Util.strZero(UtilString.removerCaracteres(ViewConsultaCadastro.this.nInscricao.getJtfCampo().getText()), 14));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        this.nInscricao.setFocusable(true);
        this.nInscricao.requestFocus();
        return this.nInscricao;
    }

    public JPanel getPainelFiltros() {
        GridBagConstraints gc = new GridBagConstraints();
        if (this.painelDados == null) {
            this.painelDados = new JPanel();
            Dimension dim = new Dimension(440, 260);
            this.painelDados.setPreferredSize(dim);
            this.painelDados.setMaximumSize(dim);
            this.painelDados.setMinimumSize(dim);
            this.painelDados.setSize(dim);
            this.painelDados.setBorder(BBJBordaOval.createOvalBorder("Op\u00e7\u00f5es do Filtro"));
            this.painelDados.setOpaque(false);
            this.painelDados.setLayout(new GridBagLayout());
            gc.insets = new Insets(2, 10, 5, 2);
            gc.anchor = 17;
            gc.weightx = 0.9;
            gc.fill = 0;
            gc.gridy = 0;
            gc.gridx = 0;
            this.painelDados.add((Component)this.getRadioTipoInscricao(), gc);
            gc.gridy = 0;
            gc.gridx = 1;
            this.painelDados.add((Component)this.getInscricao(), gc);
            gc.gridy = 1;
            gc.gridx = 0;
            gc.gridwidth = 2;
            this.painelDados.add((Component)this.getFiltroNome(), gc);
            gc.gridwidth = 1;
            gc.gridy = 2;
            gc.gridx = 0;
            this.painelDados.add((Component)this.getNomeInicio(), gc);
            gc.gridy = 2;
            gc.gridx = 1;
            this.painelDados.add((Component)this.getNomeFim(), gc);
            gc.gridy = 3;
            gc.gridx = 0;
            this.painelDados.add((Component)this.getNomeParte(), gc);
            gc.gridy = 4;
            gc.gridx = 0;
            gc.gridwidth = 2;
            this.painelDados.add((Component)this.getFiltroOper(), gc);
            gc.gridwidth = 1;
            gc.gridy = 5;
            gc.gridx = 0;
            this.painelDados.add((Component)this.getDataInicio(), gc);
            gc.gridy = 5;
            gc.gridx = 1;
            this.painelDados.add((Component)this.getDataFim(), gc);
        }
        return this.painelDados;
    }

    public JPanel getPainelBotoes() {
        if (this.painelBotoes == null) {
            this.painelBotoes = new JPanel();
            FlowLayout flw = new FlowLayout();
            flw.setAlignment(2);
            this.painelBotoes.setLayout(flw);
            this.painelBotoes.add(this.getBotaoConsultar());
            this.painelBotoes.add(this.getBotaoLimpar());
            this.painelBotoes.add(this.getBotaoFechar());
            this.painelBotoes.setOpaque(false);
        }
        return this.painelBotoes;
    }

    protected void acaoBtnLimpar(boolean posicionarFoco) {
        this.bbradio.setSelected(this.radioTodos);
        this.getNomeInicio().setText("");
        this.getNomeFim().setText("");
        this.getNomeParte().setText("");
        this.getDataInicio().setText(null);
        this.getDataFim().setText(null);
    }

    private BBJButton getBotaoLimpar() {
        if (this.btnLimpar == null) {
            this.btnLimpar = new BBJButton("LIMPAR");
            this.btnLimpar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewConsultaCadastro.this.acaoBtnLimpar(true);
                }
            });
        }
        return this.btnLimpar;
    }

    public BBJButton getBotaoConsultar() {
        if (this.botaoConsultar == null) {
            ListarCadastroPessoaAction acao = this.getActionFactory().novoListarCadastroPessoaAction();
            this.botaoConsultar = this.getBotaoFactory().novoConsultar(acao);
        }
        return this.botaoConsultar;
    }

    public void posExecucaoListarCadastroPessoaAction() {
        if (this.getListarCadastroPessoaForm().getColecaoPessoaTO2() == null || this.getListarCadastroPessoaForm().getColecaoPessoaTO2().size() == 0) {
            BBJPopupMensagem.exibirMensagem(this.getMensagem("MP004"));
        } else {
            this.getContext().put("DECORATOR", this.getListarCadastroPessoaForm().getPessoaTODecorator());
            this.getContext().put("colecao", this.getListarCadastroPessoaForm().getColecaoPessoaTO2());
            this.getContext().put("TOTALREGISTROS", this.getListarCadastroPessoaForm().getTotalDeRegistros());
            this.getContext().put("ACAO", null);
            ViewController.getInstance().goToView("GACMANTERCADLISTA", this.getContext());
        }
    }

    public Map getContext() {
        if (this.context == null) {
            this.context = new HashMap();
        }
        return this.context;
    }

    public BBJButton getBotaoFechar() {
        if (this.botaoFechar == null) {
            this.botaoFechar = new BBJButton("FECHAR", true);
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ViewConsultaCadastro.this.doClose(null);
                }
            };
            this.botaoFechar.addActionListener(listener);
        }
        return this.botaoFechar;
    }

    public void setBotaoVoltar(BBJButton botaoFechar) {
        this.botaoFechar = botaoFechar;
    }

    public void setPainelBotoes(JPanel painelBotoes) {
        this.painelBotoes = painelBotoes;
    }

    public void doShow(Map context) {
        this.setVisible(true);
        this.dataInicio.limpar();
        this.dataFim.limpar();
        this.getNomeInicio().setText("");
        this.getNomeFim().setText("");
        this.getNomeParte().setText("");
        this.nInscricao.getJtfCampo().clean();
        this.nInscricao.setVisible(false);
        this.getListarCadastroPessoaForm().setTipoOrdenacao("ASC");
        this.getListarCadastroPessoaForm().setNomeColunaOrdenada("objPessoaTO.textoNome");
        this.getListarCadastroPessoaForm().setPaginaAtual(null);
        this.radioTodos.requestFocus();
        this.radioTodos.setSelected(true);
        this.radioCNPJ.setSelected(false);
        this.radioCPF.setSelected(false);
        this.getListarCadastroPessoaForm().setCodigoPessoa(0);
        this.getListarCadastroPessoaForm().setCodigoTipoPessoa("0");
        this.bbradio.setSelected(this.radioTodos);
        this.bbradio.setSelected(0);
        this.montarCampos(this.radioCNPJ, this.radioCPF, this.radioTodos);
    }

    public void doClose(Map context) {
        super.doClose(context);
    }

    public BBJDateChooserLabel getDataFim() {
        if (this.dataFim == null) {
            this.dataFim = new BBJDateChooserLabel("Data Fim:", true, 1, 110, 10);
            this.dataFim.setName("dataFim");
            this.dataFim.setToolTipText(this.getMensagem("MH055"));
        }
        return this.dataFim;
    }

    public void setDataFim(BBJDateChooserLabel dataFim) {
        this.dataFim = dataFim;
    }

    public BBJDateChooserLabel getDataInicio() {
        if (this.dataInicio == null) {
            this.dataInicio = new BBJDateChooserLabel("Data In\u00edcio:", true, 1, 110, 10);
            this.dataInicio.setName("dataInicio");
            this.dataInicio.setToolTipText(this.getMensagem("MH054"));
        }
        return this.dataInicio;
    }

    public void setDataInicio(BBJDateChooserLabel dataInicio) {
        this.dataInicio = dataInicio;
    }

    public BBJLabel getFiltroNome() {
        if (this.FiltroNome == null) {
            this.FiltroNome = new BBJLabel("Filtro por faixa de nomes:");
            this.FiltroNome.setFont(new Font("Arial", 1, 12));
        }
        return this.FiltroNome;
    }

    public void setFiltroNome(BBJLabel filtroNome) {
        this.FiltroNome = filtroNome;
    }

    public BBJLabel getFiltroOper() {
        if (this.FiltroOper == null) {
            this.FiltroOper = new BBJLabel("Filtro por Data da \u00daltima Opera\u00e7\u00e3o:");
            this.FiltroOper.setFont(new Font("Arial", 1, 12));
        }
        return this.FiltroOper;
    }

    public void setFiltroOper(BBJLabel filtroOper) {
        this.FiltroOper = filtroOper;
    }

    public BBJTextLabel getNomeFim() {
        if (this.nomeFim == null) {
            this.nomeFim = new BBJTextLabel("at\u00e9 o Nome:", 50, true, 1, 150, 10);
            this.nomeFim.setName("nomeFim");
            this.nomeFim.setToolTipText(this.getMensagem("MH053"));
            this.nomeFim.getJtfCampo().addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (!e.getComponent().equals(ViewConsultaCadastro.this.getBotaoConsultar())) {
                        ViewConsultaCadastro.this.getNomeParte().setEnabled(true);
                    }
                    ViewConsultaCadastro.this.nomeFim.getJtfCampo().setText(Util.substituirCaracteresEspeciais(ViewConsultaCadastro.this.nomeFim.getText()));
                }

                public void focusGained(FocusEvent e) {
                    ViewConsultaCadastro.this.getNomeParte().setEnabled(false);
                    ViewConsultaCadastro.this.getNomeParte().setText("");
                }
            });
        }
        return this.nomeFim;
    }

    public void setNomeFim(BBJTextLabel nomeFim) {
        this.nomeFim = nomeFim;
    }

    public BBJTextLabel getNomeInicio() {
        if (this.nomeInicio == null) {
            this.nomeInicio = new BBJTextLabel("do Nome:", 50, true, 1, 150, 10);
            this.nomeInicio.setName("nomeInicio");
            this.nomeInicio.setToolTipText(this.getMensagem("MH052"));
            this.nomeInicio.getJtfCampo().addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (!e.getComponent().equals(ViewConsultaCadastro.this.getBotaoConsultar())) {
                        ViewConsultaCadastro.this.getNomeParte().setEnabled(true);
                    }
                    ViewConsultaCadastro.this.nomeInicio.getJtfCampo().setText(Util.substituirCaracteresEspeciais(ViewConsultaCadastro.this.nomeInicio.getText()));
                }

                public void focusGained(FocusEvent e) {
                    ViewConsultaCadastro.this.getNomeParte().setEnabled(false);
                    ViewConsultaCadastro.this.getNomeParte().setText("");
                }
            });
        }
        return this.nomeInicio;
    }

    public void setNomeInicio(BBJTextLabel nomeInicio) {
        this.nomeInicio = nomeInicio;
    }

    public BBJTextLabel getNomeParte() {
        if (this.nomeParte == null) {
            this.nomeParte = new BBJTextLabel("parte do Nome:", 50, true, 1, 150, 10);
            this.nomeParte.setName("nomeParte");
            this.nomeParte.setToolTipText(this.getMensagem("MH117"));
            this.nomeParte.getJtfCampo().addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent().getName().equals("nomeInicio") || e.getOppositeComponent().getName().equals("nomeFim")) {
                        ViewConsultaCadastro.this.getNomeInicio().setEnabled(true);
                        ViewConsultaCadastro.this.getNomeFim().setEnabled(true);
                    }
                    ViewConsultaCadastro.this.nomeParte.getJtfCampo().setText(Util.substituirCaracteresEspeciais(ViewConsultaCadastro.this.nomeParte.getText()));
                }

                public void focusGained(FocusEvent e) {
                    ViewConsultaCadastro.this.getNomeInicio().setEnabled(false);
                    ViewConsultaCadastro.this.getNomeFim().setEnabled(false);
                    ViewConsultaCadastro.this.getNomeInicio().setText("");
                    ViewConsultaCadastro.this.getNomeFim().setText("");
                }
            });
        }
        return this.nomeParte;
    }

    public void setNomeParte(BBJTextLabel nomeParte) {
        this.nomeParte = nomeParte;
    }

    protected PluginFormAbstrato novoForm() {
        return this.getFormFactory().novoListarCadastroPessoaForm();
    }

    protected ListarCadastroPessoaForm getListarCadastroPessoaForm() {
        return (ListarCadastroPessoaForm)this.getForm();
    }

    private void montarCampos(BBJRadioButton radioCNPJ, BBJRadioButton radioCPF, BBJRadioButton radioTodos) {
        this.nInscricao.setVisible(false);
        this.nInscricao.getJtfCampo().clean();
        if (radioCNPJ.isSelected()) {
            this.nInscricao.setMascara(BBJMask.TIPO_CNPJ);
            this.nInscricao.requestFocus();
            this.nInscricao.setVisible(true);
            this.ativarCampos(true);
        } else if (radioCPF.isSelected()) {
            this.nInscricao.setMascara(BBJMask.TIPO_CPF);
            this.nInscricao.requestFocus();
            this.nInscricao.setVisible(true);
            this.ativarCampos(true);
        } else if (radioTodos.isSelected()) {
            this.nInscricao.setMascara(0);
            this.ativarCampos(true);
        }
    }
}

