/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.view;

import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.configurarfuncionalidade.action.AvancarConfigurarFuncionalidadeAction;
import br.com.bb.plugins.gac.apresentacao.configurarfuncionalidade.action.ConsultarAplicativosFuncionalidadeAction;
import br.com.bb.plugins.gac.apresentacao.configurarfuncionalidade.form.ConfigurarFuncionalidadeForm;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.util.PropertyList;
import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;
import br.com.bb.plugins.gac.util.controller.view.PluginController;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJCheckBoxList;
import br.com.bb.plugins.gac.util.swing.componente.BBJPanelCheckBox;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.view.BBJPanelBotoesManut;
import br.com.bb.plugins.gac.util.view.TextFilter;
import br.com.politec.generico.objeto.UtilObjeto;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewCustomizarAplicativos
extends BasicInternalFrame {
    private JPanel jpMain = null;
    private JPanel jpTabela = null;
    private JPanel jpOpcoes = null;
    private JPanel jpDados = null;
    private BBJPanelCheckBox panelCheckBox = null;
    private BBJPanelBotoesManut panelBotoes = null;
    private BBJButton bntAvancar;
    private BBJButton bntVoltar;
    private BBJButton btnOcultoAvancar;
    private BBJCheckBoxList<PropertyList> listaAplicativos = null;
    private JFileChooser filechooser = null;

    public JFileChooser getFilechooser() {
        if (this.filechooser == null) {
            this.filechooser = new JFileChooser();
            this.filechooser.addChoosableFileFilter(new TextFilter());
            this.filechooser.setAcceptAllFileFilterUsed(false);
            String path = UtilArquivoConfiguracao.getInstancia().getValorPropertie("diretorio.contratos");
            File diretorioPadrao = new File(path);
            if (diretorioPadrao.isDirectory() && diretorioPadrao.exists()) {
                this.filechooser.setCurrentDirectory(diretorioPadrao);
                this.verificarExistenciaArquivoCustomizacao(this.filechooser);
            }
        }
        return this.filechooser;
    }

    private void verificarExistenciaArquivoCustomizacao(JFileChooser filechooser) {
        File diretorio = filechooser.getCurrentDirectory();
        File[] listaArquivos = diretorio.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                int fimExtensaoArquivo;
                int inicioExtensaoArquivo = name.length() - 4;
                return name.substring(inicioExtensaoArquivo, fimExtensaoArquivo = name.length()).equalsIgnoreCase(".BBT");
            }
        });
        if (listaArquivos.length > 0) {
            filechooser.setSelectedFile(listaArquivos[0]);
        } else {
            filechooser.setSelectedFile(null);
        }
    }

    protected ViewController getViewController() {
        return ViewController.getInstance();
    }

    public void setFilechooser(JFileChooser filechooser) {
        this.filechooser = filechooser;
    }

    public ViewCustomizarAplicativos() {
        super("Configurar Funcionalidades", false, false);
        this.initComponents();
    }

    public BBJPanelCheckBox getPanelCheckBox() {
        if (this.panelCheckBox == null) {
            this.panelCheckBox = new BBJPanelCheckBox(4, this.getConsultarAplicativosFuncionalidadeAction());
            this.panelCheckBox.setBorder(BBJBordaOval.createOvalBorder());
            this.panelCheckBox.setPreferredSize(new Dimension(200, 60));
        }
        return this.panelCheckBox;
    }

    @Override
    public void inicializaTela() {
        this.getPanelCheckBox().getChkPagamento().setSelected(false);
        this.getPanelCheckBox().getChkServico().setSelected(false);
        this.getPanelCheckBox().getChkRecebimento().setSelected(true);
        this.getConfigurarFuncionalidadeForm().setPagamento(false);
        this.getConfigurarFuncionalidadeForm().setServico(false);
        this.getConfigurarFuncionalidadeForm().setRecebimento(true);
        ConsultarAplicativosFuncionalidadeAction carregarFuncionalidadeAction = this.getActionFactory().novoConsultarAplicativosFuncionalidadeAction();
        try {
            carregarFuncionalidadeAction.executar(this.getForm());
        }
        catch (BBException e) {
            this.processarMensagemDeErro(this, e);
        }
        this.carregaListaDeAplicativos();
        this.getPanelCheckBox().getChkPagamento().requestFocus();
    }

    public void preExecucaoAvancarConfigurarFuncionalidadeAction() {
        if (this.getListaAplicativos().getSelected() != null) {
            String s_select = this.getListaAplicativos().getSelected().getId();
            this.getJpDados().removeAll();
            this.setTextoIdentificadorServico(s_select);
        }
    }

    private void carregaListaDeAplicativos() {
        List<ServicoTO> listaDeAplicativosInstalados = this.getConfigurarFuncionalidadeForm().getAplicativosInstalados();
        if (UtilObjeto.isReferencia(listaDeAplicativosInstalados)) {
            ArrayList<PropertyList> listaDePropertyList = new ArrayList<PropertyList>();
            if (listaDeAplicativosInstalados.size() > 0) {
                PropertyList recebimentos = new PropertyList("", "Recebimento");
                recebimentos.setCheckbox(false);
                listaDePropertyList.add(recebimentos);
            }
            for (ServicoTO servicoTO : listaDeAplicativosInstalados) {
                listaDePropertyList.add(new PropertyList(servicoTO.getTextoIdentificadorServico(), servicoTO.getTextoDescricao()));
            }
            PropertyList[] propertyLists = new PropertyList[listaDePropertyList.size()];
            this.getListaAplicativos().carregaLista((PropertyList[])listaDePropertyList.toArray(propertyLists));
            if (listaDePropertyList != null && !listaDePropertyList.isEmpty()) {
                this.getBntAvancar().setEnabled(true);
            } else {
                this.getBntAvancar().setEnabled(false);
            }
        }
    }

    private void initComponents() {
        this.add(this.getJPMain());
    }

    public JPanel getJPMain() {
        if (this.jpMain == null) {
            this.jpMain = new JPanel();
            this.jpMain.setLayout(new BorderLayout());
            this.jpMain.setBackground(Color.WHITE);
            this.jpMain.add((Component)this.getJpTabela(), "North");
        }
        return this.jpMain;
    }

    private int getLargura() {
        int ilargura = this.getWidth() / 2;
        if (ilargura == 0) {
            ilargura = 300;
        }
        return ilargura;
    }

    public JPanel getJpTabela() {
        if (this.jpTabela == null) {
            this.jpTabela = new JPanel();
            this.jpTabela.setOpaque(false);
            this.jpTabela.setLayout(new BorderLayout());
            this.jpTabela.setPreferredSize(new Dimension(this.getLargura(), 280));
            this.jpTabela.setSize(new Dimension(this.getLargura(), 280));
            this.jpTabela.add((Component)this.getJpOpcoes(), "Center");
        }
        return this.jpTabela;
    }

    public JPanel getJpOpcoes() {
        if (this.jpOpcoes == null) {
            this.jpOpcoes = new JPanel();
            this.jpOpcoes.setOpaque(false);
            this.jpOpcoes.setLayout(new BorderLayout());
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            panel.setPreferredSize(new Dimension(0, 15));
            this.jpOpcoes.add((Component)panel, "North");
            this.jpOpcoes.setPreferredSize(new Dimension(this.getLargura(), 500));
            this.jpOpcoes.setSize(new Dimension(this.getLargura(), 500));
            this.jpOpcoes.add((Component)this.getPanelCheckBox(), "North");
            this.jpOpcoes.add(this.getListaAplicativos(), "Center");
            this.jpOpcoes.add((Component)this.getPanelBotoes(), "South");
            this.getBtnConsultar();
        }
        return this.jpOpcoes;
    }

    public BBJCheckBoxList<PropertyList> getListaAplicativos() {
        if (this.listaAplicativos == null) {
            this.listaAplicativos = new BBJCheckBoxList();
            this.listaAplicativos.setName("listaAplicativos");
            this.listaAplicativos.setBorder(BBJBordaOval.createOvalBorder("Aplicativos Instalados"));
        }
        return this.listaAplicativos;
    }

    public void setListaAplicativos(BBJCheckBoxList<PropertyList> listaAplicativos) {
        this.listaAplicativos = listaAplicativos;
    }

    public JPanel getJpDados() {
        if (this.jpDados == null) {
            this.jpDados = new JPanel();
            this.jpDados.setOpaque(false);
            this.jpDados.setLayout(new BorderLayout());
        }
        return this.jpDados;
    }

    public BBJPanelBotoesManut getPanelBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = new BBJPanelBotoesManut(-1);
            this.panelBotoes.removeAll();
            this.panelBotoes.add(this.getBntAvancar());
            this.panelBotoes.add(this.getBntVoltar());
            this.panelBotoes.add(this.getBtnOcultoAvancar());
        }
        return this.panelBotoes;
    }

    public BBJButton getBntAvancar() {
        if (this.bntAvancar == null) {
            this.bntAvancar = new BBJButton("AVAN\u00c7AR");
            this.bntAvancar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ViewCustomizarAplicativos.this.getListaAplicativos().getSelected() == null) {
                        BBJPopupMensagem.exibirMensagemAlerta("Selecione Lista de Aplicativos Obrigat\u00f3rio");
                        return;
                    }
                    int resposta = ViewCustomizarAplicativos.this.getFilechooser().showSaveDialog(ViewCustomizarAplicativos.this.bntAvancar.getParent());
                    ViewCustomizarAplicativos.this.getConfigurarFuncionalidadeForm().setArquivo(ViewCustomizarAplicativos.this.filechooser.getSelectedFile());
                    if (resposta != 1 && ViewCustomizarAplicativos.this.getConfigurarFuncionalidadeForm().getArquivo() != null && ViewCustomizarAplicativos.this.getConfigurarFuncionalidadeForm().getArquivo().exists() && ViewCustomizarAplicativos.this.getConfigurarFuncionalidadeForm().getArquivo().isFile()) {
                        ViewCustomizarAplicativos.this.getBtnOcultoAvancar().doClick();
                    }
                }
            });
            this.getBntAvancar().setEnabled(false);
        }
        return this.bntAvancar;
    }

    public BBJButton getBntVoltar() {
        if (this.bntVoltar == null) {
            this.bntVoltar = this.getBotaoFactory().novoVoltar();
        }
        return this.bntVoltar;
    }

    public ConfigurarFuncionalidadeForm getConfigurarFuncionalidadeForm() {
        return (ConfigurarFuncionalidadeForm)this.getForm();
    }

    public ConsultarAplicativosFuncionalidadeAction getConsultarAplicativosFuncionalidadeAction() {
        return this.getActionFactory().novoConsultarAplicativosFuncionalidadeAction();
    }

    public void posExecucaoConsultarAplicativosFuncionalidadeAction() {
        this.carregaListaDeAplicativos();
    }

    public void setTextoIdentificadorServico(String textoIdentificadorServico) {
        this.getConfigurarFuncionalidadeForm().setIdentificadorServico(textoIdentificadorServico);
    }

    @Override
    public void doShow(Map context) {
        this.setVisible(true);
        this.inicializaTela();
    }

    private BBJButton getBtnConsultar() {
        return this.getPanelCheckBox().getBotaoConsultar();
    }

    public void doClose() {
        super.doClose(null);
    }

    @Override
    protected PluginFormAbstrato novoForm() {
        return this.getFormFactory().novoConfigurarFuncionalidadeForm();
    }

    public PluginController getPluginController() {
        return new PluginController();
    }

    public static void main(String[] args) {
        JFrame frm = new JFrame();
        ViewCustomizarAplicativos configexp = new ViewCustomizarAplicativos();
        configexp.beforeShow(null);
        configexp.doShow(null);
        frm.setSize(new Dimension(800, 600));
        frm.setContentPane(configexp);
        frm.setDefaultCloseOperation(2);
        frm.setVisible(true);
    }

    public BBJButton getBtnOcultoAvancar() {
        if (this.btnOcultoAvancar == null) {
            AvancarConfigurarFuncionalidadeAction acao = this.getAvancarConfigurarFuncionalidadeAction();
            this.btnOcultoAvancar = this.getBotaoFactory().novoAvancar(acao);
            this.btnOcultoAvancar.setVisible(false);
        }
        return this.btnOcultoAvancar;
    }

    private AvancarConfigurarFuncionalidadeAction getAvancarConfigurarFuncionalidadeAction() {
        return this.getActionFactory().novoAvancarConfigurarFuncionalidadeAction();
    }

    public void setBntOps(BBJButton bntOps) {
        this.btnOcultoAvancar = bntOps;
    }

    @Override
    public void posExecucaoFecharAction() {
        this.doClose(null);
    }
}

