/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.view;

import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.apresentacao.login.action.LoginAction;
import br.com.bb.plugins.gac.apresentacao.login.form.LoginForm;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.FacadeFactory;
import br.com.bb.plugins.gac.negocio.facade.IniciarUtilizacaoFacade;
import br.com.bb.plugins.gac.negocio.facade.ManterUsuarioFacade;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.bean.ValidacaoBean;
import br.com.bb.plugins.gac.util.controller.view.ControlableView;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJPasswordLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJTextLabel;
import br.com.bb.plugins.gac.util.view.BBJFormPopup;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.string.UtilString;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;

public class ViewLogin
extends BBJFormPopup {
    private int tipoview = 0;
    private Map context;
    private BBJTextLabel txtChaveDeAcesso = null;
    private BBJPasswordLabel txtSenhaDeAcesso = null;
    private BBJButton btnEntra = null;
    private BBJButton btnLimpa = null;
    private JPanel pnlBotoes = null;
    private JPanel panelLoginSenha = null;
    private LoginAction loginAction = null;

    public IniciarUtilizacaoFacade getIniciarUtilizacaoFacade() {
        return new IniciarUtilizacaoFacade();
    }

    public ManterUsuarioFacade getManterUsuarioFacade() {
        return new ManterUsuarioFacade();
    }

    public void beforeShow(Map context) {
        this.getTxtChaveDeAcesso().setText("");
        this.getTxtSenhaDeAcesso().setText("");
    }

    protected FacadeFactory getFacadeFactory() {
        return FacadeFactory.getInstancia();
    }

    public void doShow(Map context) {
        this.setContext(context);
        this.getTxtChaveDeAcesso().getJtfCampo().requestFocus();
        this.getTxtChaveDeAcesso().requestFocus();
        LoginForm loginForm = (LoginForm)this.getForm();
        if (this.getFacadeFactory().novoLoginFacade().verificaPrimeiroAcesso()) {
            BBJPopupMensagem.exibirMensagemInformacaoOk("A seguir, acesse o sistema informando USU\u00c1RIO = 'admin' e SENHA = 'admin'.");
            loginForm.setPrimeiroAcesso(true);
        } else {
            loginForm.setPrimeiroAcesso(false);
        }
        try {
            if (((Boolean)context.get("limparDados")).booleanValue()) {
                this.beforeShow(null);
            }
        }
        catch (NullPointerException npe) {
            System.err.println("...");
        }
        super.doShow(context);
    }

    public int getTipoView() {
        return this.tipoview;
    }

    public void setTipoView(int tipoview) {
        this.tipoview = tipoview;
    }

    public ViewLogin(Frame owner) throws HeadlessException {
        super(owner, "BB Gest\u00e3oMax", "Informe sua chave de acesso", new Dimension(320, 300));
        this.initComponents();
        this.getTxtChaveDeAcesso().getJtfCampo().requestFocus();
        ((LoginForm)this.getForm()).setView(this);
        this.getBtnEntra();
    }

    private void initComponents() {
        this.setSize(250, 270);
        this.setContentPanel(this.getPanelLoginSenha());
        this.Centralizar();
        this.addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
                ViewLogin.this.acaoSair();
            }

            public void windowClosing(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
                ViewLogin.this.focoNoCampoUsuario();
            }
        });
    }

    protected void focoNoCampoUsuario() {
        this.getTxtChaveDeAcesso().requestFocus();
    }

    public JPanel getPanelLoginSenha() {
        if (this.panelLoginSenha == null) {
            this.panelLoginSenha = new JPanel();
            this.panelLoginSenha.setOpaque(false);
            this.panelLoginSenha.setLayout(new GridBagLayout());
            this.panelLoginSenha.setBorder(BBJBordaOval.createOvalBorder("Acesso ao Sistema"));
            GridBagConstraints gc = new GridBagConstraints();
            gc.insets = new Insets(4, 25, 4, 25);
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 1;
            gc.weightx = 0.9;
            this.panelLoginSenha.add((Component)this.getTxtChaveDeAcesso(), gc);
            ++gc.gridy;
            this.panelLoginSenha.add((Component)this.getTxtSenhaDeAcesso(), gc);
        }
        return this.panelLoginSenha;
    }

    public BBJButton getBtnEntra() {
        if (this.btnEntra == null) {
            this.btnEntra = this.criaBotao();
        }
        return this.btnEntra;
    }

    protected BBJButton criaBotao() {
        return this.getBotaoFactory().novoEntrar(this.getLoginAction());
    }

    public LoginAction getLoginAction() {
        if (this.loginAction == null) {
            this.loginAction = this.getActionFactory().novoLoginAction();
        }
        return this.loginAction;
    }

    private void exibirConfirmacaoDeHorario() {
        try {
            LoginForm loginForm = (LoginForm)this.getForm();
            if (this.isInicializacaoDoAplicativo()) {
                ViewLogin.printarMensagemConfirmacaoData();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void printarMensagemConfirmacaoData() {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        BBJPopupMensagem.exibirMensagemAvancar("<html><span style='font-size:20px; color:#006ABA'>Data atual: " + df.format(new Date()) + "</span></html>");
    }

    private boolean isInicializacaoDoAplicativo() {
        try {
            return (Boolean)this.getContext().get("aplicativoInicializado");
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public void posExecucaoLoginAction() {
        this.getTxtChaveDeAcesso().requestFocus();
        this.doClose(null);
        LoginForm loginForm = (LoginForm)this.getForm();
        HashMap<String, Object> context = new HashMap<String, Object>();
        Character indicadorAlteracaoSenha = Character.valueOf(' ');
        try {
            indicadorAlteracaoSenha = loginForm.getIndicadorAlteracaoSenha();
        }
        catch (NullPointerException npe) {
            indicadorAlteracaoSenha = Character.valueOf('N');
        }
        if (indicadorAlteracaoSenha == null || indicadorAlteracaoSenha.charValue() == 'S' || indicadorAlteracaoSenha.charValue() == 'N') {
            context.put("ACAO", "ALTERARSENHAOBRIGATORIO");
            if (loginForm.isAlteracaoComChaveMestra() && !loginForm.isChaveMestraJaUtilizada()) {
                context.put("isChaveMestra", true);
                context.put("textoNomeUsuarioSistema", loginForm.getUsuarioTODecorator().getUsuarioTO().getTextoNomeUsuarioSistema());
                ControlableView view = ViewController.getInstance().goToView("GACALTERARSENHA", context, false);
                view.doShow(context);
            } else if (loginForm.isAlteracaoComChaveMestra() && loginForm.isChaveMestraJaUtilizada()) {
                BBJPopupMensagem.exibirMensagemErro("Chave j\u00e1 utilizada. Favor procurar o suporte.");
                ControlableView view = ViewController.getInstance().goToView("viewLogin", null, false);
                view.doShow(null);
            } else if (loginForm.isPrimeiroAcesso()) {
                context.put("ACAO", "ALTERARSENHAOBRIGATORIO");
                context.put("primeiroAcesso", true);
                ControlableView view = ViewController.getInstance().goToView("GACALTERARSENHA", context, false);
                view.doShow(context);
            } else {
                this.exibirConfirmacaoDeHorario();
            }
        }
    }

    protected PluginFormAbstrato novoForm() {
        LoginForm loginForm = this.getFormFactory().novoLoginForm();
        return loginForm;
    }

    public BBJButton getBtnLimpa() {
        if (this.btnLimpa == null) {
            this.btnLimpa = new BBJButton(this.criaLabelBotaoSair());
            this.btnLimpa.setSize();
            this.btnLimpa.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewLogin.this.acaoSair();
                }
            });
        }
        return this.btnLimpa;
    }

    protected String criaLabelBotaoSair() {
        return "SAIR";
    }

    public BBJTextLabel getTxtChaveDeAcesso() {
        if (this.txtChaveDeAcesso == null) {
            this.txtChaveDeAcesso = new BBJTextLabel("Chave de Acesso", 20, true, 1);
            this.txtChaveDeAcesso.setName("textoNomeUsuarioSistema");
            this.txtChaveDeAcesso.setToolTipText(this.getMensagem("MH044"));
        }
        return this.txtChaveDeAcesso;
    }

    public BBJPasswordLabel getTxtSenhaDeAcesso() {
        if (this.txtSenhaDeAcesso == null) {
            this.txtSenhaDeAcesso = new BBJPasswordLabel("Senha de Acesso", 10, true, 1, 10, 10, 11);
            this.txtSenhaDeAcesso.setName("textoSenha");
            this.txtSenhaDeAcesso.setToolTipText(this.getMensagem("MH045"));
            this.txtSenhaDeAcesso.addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent e) {
                    this.enter(e);
                }

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    this.enter(e);
                }

                private void enter(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ViewLogin.this.executarLogin();
                    }
                }
            });
        }
        return this.txtSenhaDeAcesso;
    }

    private void executarLogin() {
        try {
            LoginForm form = (LoginForm)this.getForm();
            form.setTextField(this.getTxtChaveDeAcesso().getJtfCampo());
            form.setTextoNomeUsuarioSistema(this.getTxtChaveDeAcesso().getText());
            form.setTextoSenha(UtilString.minuscula(this.getTxtSenhaDeAcesso().getText()));
            if (form.isValidado()) {
                this.getLoginAction().limparMensagens();
                this.getLoginAction().executar(form);
                Collection<String> mensagens = this.getLoginAction().getColecaoDeMensagens();
                if (!UtilColecao.isVazio(mensagens)) {
                    StringBuffer sb = new StringBuffer();
                    for (String mensagem : mensagens) {
                        sb.append(mensagem).append("\n");
                    }
                    BBJPopupMensagem.exibirMensagemAlerta(sb.toString());
                    form.getTextField().selectAll();
                    form.getTextField().requestFocus();
                } else {
                    this.posExecucaoLoginAction();
                }
            } else {
                StringBuffer mensagem = new StringBuffer();
                Collection<ValidacaoBean> c = form.getColecaoMensagensDeValidacao();
                ValidacaoBean vb = (ValidacaoBean)UtilColecao.getElementoDoIndice(c, 0);
                mensagem.append(vb.getMensagem());
                BBJPopupMensagem.exibirMensagemAlerta(mensagem.toString());
                this.focoNoCampoInvalido(vb.getPropriedade());
            }
        }
        catch (BBException e) {
            BBJPopupMensagem.exibirMensagem(UtilMensagem.getInstancia().getErroDeSistema(e.getCause().getMessage()));
        }
    }

    private void focoNoCampoInvalido(String propriedade) {
        if (propriedade.equalsIgnoreCase(this.getTxtChaveDeAcesso().getJtfCampo().getName())) {
            this.getTxtChaveDeAcesso().getJtfCampo().selectAll();
            this.getTxtChaveDeAcesso().getJtfCampo().requestFocus();
        } else if (propriedade.equalsIgnoreCase(this.getTxtSenhaDeAcesso().getJtfSenha().getName())) {
            this.getTxtSenhaDeAcesso().getJtfSenha().selectAll();
            this.getTxtSenhaDeAcesso().getJtfSenha().requestFocus();
        }
    }

    public JPanel getBarraBotoes() {
        if (this.pnlBotoes == null) {
            this.pnlBotoes = new JPanel();
            this.pnlBotoes.setOpaque(false);
            this.pnlBotoes.setPreferredSize(new Dimension(0, 35));
            FlowLayout layout = new FlowLayout();
            layout.setAlignment(1);
            this.pnlBotoes.setLayout(layout);
            this.pnlBotoes.add(this.getBtnEntra());
            this.pnlBotoes.add(this.getBtnLimpa());
        }
        return this.pnlBotoes;
    }

    protected void acaoSair() {
        System.exit(0);
    }

    private Map getContext() {
        return this.context;
    }

    private void setContext(Map context) {
        this.context = context;
    }

    public static void main(String[] args) {
        ViewLogin v = new ViewLogin(null);
        v.doShow(null);
    }
}

