/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.view;

import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.apresentacao.manterinstituicaofinanceira.action.ListarInstituicaoFinanceiraAction;
import br.com.bb.plugins.gac.apresentacao.manterinstituicaofinanceira.form.ManterInstituicaoFinanceiraForm;
import br.com.bb.plugins.gac.negocio.to.InstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.util.controller.view.ControlableView;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.objecttablemodel.IObjectInstituicaoFinanceira;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJPaginacao;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJTable;
import br.com.politec.generico.objeto.UtilObjeto;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewManterInstituicaoFinanceira
extends BasicInternalFrame {
    private final String[] columnNames = new String[]{"C\u00f3digo IF", "Nome Institui\u00e7\u00e3o Financeira", "Tipo"};
    private final int[] columnSizes = new int[]{130, 200, 50};
    private final int[] columnAligment = new int[]{2, 2, 2};
    private BBJTable<IObjectInstituicaoFinanceira> tableModel;
    private JTable table;
    private JPanel panelBotoes;
    private BBJButton botaoNovo;
    private BBJButton botaoEditar;
    private BBJButton botaoExcluir;
    private BBJButton botaoSair;
    private JPanel botaoSuperior;
    private JPanel panelPrincipal;
    private String nomeBnt = null;
    private BBJPaginacao paginacao;
    private Map context = null;

    public ViewManterInstituicaoFinanceira() {
        super("Manuten\u00e7\u00e3o de Institui\u00e7\u00f5es Financeiras", false, false);
        this.initialize();
    }

    private void initialize() {
        this.add(this.getPanelPrincipal());
        this.apresentarTabela();
    }

    @Override
    public void doShow(Map context) {
        this.setVisible(true);
        this.getBotaoNovo().requestFocusInWindow();
        ManterInstituicaoFinanceiraForm form = (ManterInstituicaoFinanceiraForm)this.getForm();
        form.setPaginaAtual(1);
        this.getPaginacao().setValorPos(1);
        this.getPaginacao().atualiza();
        form.getInstituicaoFinanceiraTODecorator().setNomeColunaOrdenada("codigoInstituicaoFinanceira");
        form.getInstituicaoFinanceiraTODecorator().setTipoOrdenacao("ASC");
    }

    @Override
    public void doClose(Map context) {
        super.doClose(context);
    }

    public JPanel getPanelPrincipal() {
        if (this.panelPrincipal == null) {
            this.panelPrincipal = new JPanel();
            this.panelPrincipal.setLayout(new BorderLayout());
            this.panelPrincipal.setBackground(Color.WHITE);
            this.panelPrincipal.add((Component)this.getPanelSuperior(), "North");
        }
        return this.panelPrincipal;
    }

    public JPanel getPanelSuperior() {
        if (this.botaoSuperior == null) {
            this.botaoSuperior = new JPanel();
            this.botaoSuperior.setLayout(new BorderLayout());
            this.botaoSuperior.setOpaque(false);
            this.botaoSuperior.add((Component)this.getPainelTabela(), "North");
            this.botaoSuperior.add((Component)this.getPaginacao(), "Center");
            this.botaoSuperior.add((Component)this.getPainelBotoes(), "South");
        }
        return this.botaoSuperior;
    }

    public BBJPaginacao getPaginacao() {
        if (this.paginacao == null) {
            this.paginacao = new BBJPaginacao();
            this.paginacao.addPropertyChangeListener("paginacao", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ListarInstituicaoFinanceiraAction action = ViewManterInstituicaoFinanceira.this.getActionFactory().novoListarInstituicaoFinanceiraAction();
                    ManterInstituicaoFinanceiraForm form = (ManterInstituicaoFinanceiraForm)ViewManterInstituicaoFinanceira.this.getForm();
                    form.setPaginaAtual((Integer)evt.getNewValue());
                    action.executar(form);
                    ViewManterInstituicaoFinanceira.this.atualizarTabela();
                }
            });
        }
        return this.paginacao;
    }

    @Override
    protected PluginFormAbstrato novoForm() {
        return this.getFormFactory().novoManterInstituicaoFinanceiraForm();
    }

    private JPanel getPainelBotoes() {
        this.panelBotoes = new JPanel();
        this.panelBotoes.setOpaque(false);
        FlowLayout flw = new FlowLayout();
        flw.setAlignment(2);
        this.panelBotoes.setLayout(flw);
        this.panelBotoes.add(this.getBotaoNovo());
        this.panelBotoes.add(this.getBotaoEditar());
        this.panelBotoes.add(this.getBotaoExcluir());
        this.panelBotoes.add(this.getBotaoVoltar());
        return this.panelBotoes;
    }

    private JPanel getPainelTabela() {
        JPanel pTabela = new JPanel();
        Dimension d = new Dimension(530, 222);
        pTabela.setBorder(BBJBordaOval.createOvalBorder("Lista de Institui\u00e7\u00f5es Financeiras", 15));
        pTabela.setSize(d);
        pTabela.setPreferredSize(d);
        pTabela.setOpaque(false);
        this.tableModel = new BBJTable<IObjectInstituicaoFinanceira>(this.columnNames, this.columnSizes, this.columnAligment, 5){

            @Override
            public void metodoInMouseClicked() {
                ViewManterInstituicaoFinanceira.this.habilitaBotoes();
            }
        };
        this.table = new JTable();
        this.table.setModel(this.tableModel);
        this.table.setOpaque(false);
        this.tableModel.setTableProps(this.table);
        this.tableModel.setOrdenacaoAutomatica(false);
        this.tableModel.setNomeColunas(new String[]{"codigoInstituicaoFinanceira", "textoNomeInstituicaoFinanceira", "tipoInstituicaoFinanceira"});
        this.tableModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equalsIgnoreCase("EVENTO_ORDENACAO")) {
                    ViewManterInstituicaoFinanceira.this.ordenarTabela();
                }
            }
        });
        pTabela.setLayout(new BorderLayout());
        JPanel pnl = new JPanel();
        pnl.setOpaque(false);
        pnl.setLayout(new BorderLayout());
        pnl.add((Component)this.table.getTableHeader(), "North");
        pnl.add((Component)this.table, "Center");
        pTabela.add(pnl);
        return pTabela;
    }

    private void ordenarTabela() {
        ManterInstituicaoFinanceiraForm form = (ManterInstituicaoFinanceiraForm)this.getForm();
        form.getInstituicaoFinanceiraTODecorator().setNomeColunaOrdenada(this.tableModel.getNomeColunaOrdenada());
        form.getInstituicaoFinanceiraTODecorator().setTipoOrdenacao(this.tableModel.getTipoordenacao());
        this.apresentarTabela();
    }

    private void habilitaBotoes() {
        if (this.tableModel.getItensChecadosCheckBox().size() > 0) {
            this.getBotaoEditar().setEnabled(true);
            this.getBotaoExcluir().setEnabled(true);
        } else {
            this.getBotaoEditar().setEnabled(false);
            this.getBotaoExcluir().setEnabled(false);
        }
    }

    protected void apresentarTabela() {
        ListarInstituicaoFinanceiraAction acao = this.getActionFactory().novoListarInstituicaoFinanceiraAction();
        ManterInstituicaoFinanceiraForm form = (ManterInstituicaoFinanceiraForm)this.getForm();
        if (!this.isReferencia(form.getPaginaAtual())) {
            form.setPaginaAtual(1);
        }
        acao.executar(form);
        this.getPaginacao().setValorMaximo(form.getNumeroDePaginas());
        this.tableModel.setDataListTabela(this.conversorDataList(form.getColecao()));
        this.isExisteInstituicaoFinanceira(form.getColecao());
        this.habilitaBotoes();
    }

    private void isExisteInstituicaoFinanceira(Collection<InstituicaoFinanceiraTO> colecao) {
        if (UtilObjeto.isReferencia(colecao) && colecao.isEmpty()) {
            BBJPopupMensagem.exibirMensagem(this.getUtilMensagem().getMensagem("MP004"));
        }
    }

    @Override
    public void atualizar() {
        this.atualizarTabela();
    }

    public void atualizarTabela() {
        ManterInstituicaoFinanceiraForm form = (ManterInstituicaoFinanceiraForm)this.getForm();
        this.tableModel.setDataListTabela(this.conversorDataList(form.getColecao()));
        this.habilitaBotoes();
    }

    protected List<IObjectInstituicaoFinanceira> conversorDataList(Collection<InstituicaoFinanceiraTO> colecao) {
        ArrayList<IObjectInstituicaoFinanceira> lista = new ArrayList<IObjectInstituicaoFinanceira>();
        for (InstituicaoFinanceiraTO to : colecao) {
            IObjectInstituicaoFinanceira obj = new IObjectInstituicaoFinanceira(to);
            lista.add(obj);
        }
        return lista;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        ViewManterInstituicaoFinanceira manterBanco = new ViewManterInstituicaoFinanceira();
        manterBanco.show();
        frame.add(manterBanco);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public BBJButton getBotaoEditar() {
        if (this.botaoEditar == null) {
            this.botaoEditar = new BBJButton("EDITAR", true);
            this.botaoEditar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    if (ViewManterInstituicaoFinanceira.this.tableModel.getItensChecadosCheckBox().size() > 0) {
                        ViewManterInstituicaoFinanceira.this.getContext().put("ACAO", 2);
                        ViewManterInstituicaoFinanceira.this.getContext().put("to", ViewManterInstituicaoFinanceira.this.getIObjectFromTable());
                        ControlableView view = ViewController.getInstance().goToView("GACMANTERBANCOPOPUP", null, false);
                        view.doShow(ViewManterInstituicaoFinanceira.this.getContext());
                        ViewManterInstituicaoFinanceira.this.apresentarTabela();
                    }
                }
            });
            this.botaoEditar.setEnabled(false);
        }
        return this.botaoEditar;
    }

    protected IObjectInstituicaoFinanceira getIObjectFromTable() {
        List<IObjectInstituicaoFinanceira> lista = this.tableModel.getItensChecadosCheckBox();
        IObjectInstituicaoFinanceira obj = lista.get(0);
        return obj;
    }

    public void setJbEditar(BBJButton jbEditar) {
        this.botaoEditar = jbEditar;
    }

    public BBJButton getBotaoExcluir() {
        if (this.botaoExcluir == null) {
            this.botaoExcluir = new BBJButton("EXCLUIR", true);
            this.botaoExcluir.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    if (ViewManterInstituicaoFinanceira.this.tableModel.getItensChecadosCheckBox().size() > 0) {
                        ViewManterInstituicaoFinanceira.this.getContext().put("ACAO", 3);
                        ViewManterInstituicaoFinanceira.this.getContext().put("to", ViewManterInstituicaoFinanceira.this.getIObjectFromTable());
                        ControlableView view = ViewController.getInstance().goToView("GACMANTERBANCOPOPUP", null, false);
                        view.doShow(ViewManterInstituicaoFinanceira.this.getContext());
                        ViewManterInstituicaoFinanceira.this.apresentarTabela();
                    }
                }
            });
            this.botaoExcluir.setEnabled(false);
        }
        return this.botaoExcluir;
    }

    public void setBotaoExcluir(BBJButton jbExcluir) {
        this.botaoExcluir = jbExcluir;
    }

    public BBJButton getBotaoNovo() {
        if (this.botaoNovo == null) {
            this.botaoNovo = new BBJButton("NOVO", true);
            this.botaoNovo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ViewManterInstituicaoFinanceira.this.getContext().clear();
                    ViewManterInstituicaoFinanceira.this.getContext().put("ACAO", 1);
                    ViewManterInstituicaoFinanceira.this.getContext().put("to", null);
                    ControlableView view = ViewController.getInstance().goToView("GACMANTERBANCOPOPUP", ViewManterInstituicaoFinanceira.this.getContext(), false);
                    view.doShow(ViewManterInstituicaoFinanceira.this.getContext());
                    ViewManterInstituicaoFinanceira.this.apresentarTabela();
                }
            });
        }
        return this.botaoNovo;
    }

    public BBJButton getBotaoVoltar() {
        if (this.botaoSair == null) {
            this.botaoSair = this.getBotaoFactory().novoVoltar();
        }
        return this.botaoSair;
    }

    @Override
    public void posExecucaoFecharAction() {
        this.doClose(null);
    }

    public void setJbSair(BBJButton jbSair) {
        this.botaoSair = jbSair;
    }

    public String getNomeBnt() {
        return this.nomeBnt;
    }

    public void setNomeBnt(String nomeBnt) {
        this.nomeBnt = nomeBnt;
    }

    public Map getContext() {
        if (this.context == null) {
            this.context = new HashMap();
        }
        return this.context;
    }

    public void setContext(Map context) {
        this.context = context;
    }

    public ManterInstituicaoFinanceiraForm getManterInstituicaoFinanceiraForm() {
        return (ManterInstituicaoFinanceiraForm)this.getForm();
    }
}

