/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.reflexao;

import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.reflexao.exception.ReflexaoException;
import br.com.politec.reflexao.kernel.ConversorKernel;
import br.com.politec.reflexao.kernel.FabricaKernel;
import br.com.politec.reflexao.kernel.GetKernel;
import br.com.politec.reflexao.kernel.InvocarMetodoKernel;
import br.com.politec.reflexao.kernel.JDBCKernel;
import br.com.politec.reflexao.kernel.MetodoKernel;
import br.com.politec.reflexao.kernel.SetKernel;
import br.com.politec.reflexao.util.UtilLog;
import br.com.politec.reflexao.util.UtilReflexaoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class UtilReflexaoAbstrato {
    private static ConversorKernel conversorKernel;
    private static FabricaKernel fabricaKernel;
    private static GetKernel getKernel;
    private static InvocarMetodoKernel invocarMetodoKernel;
    private static MetodoKernel metodoKernel;
    private static SetKernel setKernel;
    private static JDBCKernel jdbcKernel;

    protected static LogAbstrato getLog() {
        return UtilLog.getLog();
    }

    protected static void debug(String mensagem) {
        UtilReflexaoAbstrato.getLog().debug((Object)mensagem);
    }

    protected static void debugInit(Class classe, String metodo) {
        UtilReflexaoAbstrato.getLog().debugInit(classe, metodo);
    }

    protected static void debugEnd(Class classe, String metodo) {
        UtilReflexaoAbstrato.getLog().debugEnd(classe, metodo);
    }

    protected static ConversorKernel getConversorKernel() {
        if (!UtilReflexaoAbstrato.isReferencia(conversorKernel)) {
            conversorKernel = new ConversorKernel();
        }
        return conversorKernel;
    }

    protected static FabricaKernel getFabricaKernel() {
        if (!UtilReflexaoAbstrato.isReferencia(fabricaKernel)) {
            fabricaKernel = new FabricaKernel();
        }
        return fabricaKernel;
    }

    protected static GetKernel getGetKernel() {
        if (!UtilReflexaoAbstrato.isReferencia(getKernel)) {
            getKernel = new GetKernel();
        }
        return getKernel;
    }

    protected static InvocarMetodoKernel getInvocarMetodoKernel() {
        if (!UtilReflexaoAbstrato.isReferencia(invocarMetodoKernel)) {
            invocarMetodoKernel = new InvocarMetodoKernel();
        }
        return invocarMetodoKernel;
    }

    protected static MetodoKernel getMetodoKernel() {
        if (!UtilReflexaoAbstrato.isReferencia(metodoKernel)) {
            metodoKernel = new MetodoKernel();
        }
        return metodoKernel;
    }

    protected static SetKernel getSetKernel() {
        if (!UtilReflexaoAbstrato.isReferencia(setKernel)) {
            setKernel = new SetKernel();
        }
        return setKernel;
    }

    protected static JDBCKernel getJdbcKernel() {
        if (!UtilReflexaoAbstrato.isReferencia(jdbcKernel)) {
            jdbcKernel = new JDBCKernel();
        }
        return jdbcKernel;
    }

    protected static ReflexaoException argumentoInvalidoNoMetodo(String pathMetodos, IllegalArgumentException e) {
        return UtilReflexaoException.argumentoInvalidoNoMetodo(pathMetodos, e);
    }

    protected static ReflexaoException argumentoInvalidoNoMetodo(Method metodo, IllegalArgumentException e) {
        return UtilReflexaoException.argumentoInvalidoNoMetodo(metodo, e);
    }

    protected static ReflexaoException acessoNegadoAoMetodo(String pathMetodos, IllegalAccessException e) {
        return UtilReflexaoException.acessoNegadoAoMetodo(pathMetodos, e);
    }

    protected static ReflexaoException acessoNegadoAoMetodo(Method metodo, IllegalAccessException e) {
        return UtilReflexaoException.acessoNegadoAoMetodo(metodo, e);
    }

    protected static ReflexaoException classeNaoEncontrada(String classe) {
        return UtilReflexaoException.classeNaoEncontrada(classe);
    }

    protected static ReflexaoException classeNaoInstanciada(String classe, Exception e) {
        return UtilReflexaoException.classeNaoInstanciada(classe, e);
    }

    protected static ReflexaoException classeNaoInstanciada(Class classe, Exception e) {
        return UtilReflexaoException.classeNaoInstanciada(classe, e);
    }

    protected static ReflexaoException erro(Throwable e) {
        return UtilReflexaoException.erro(e);
    }

    protected static ReflexaoException erroAoInvocarMetodo(String pathMetodos, InvocationTargetException e) {
        return UtilReflexaoException.erroAoInvocarMetodo(pathMetodos, e);
    }

    protected static ReflexaoException erroAoInvocarMetodo(Method metodo, InvocationTargetException e) {
        return UtilReflexaoException.erroAoInvocarMetodo(metodo, e);
    }

    protected static ReflexaoException metodoNaoEncontrado(Object objeto, String nomeDoMetodo) {
        return UtilReflexaoException.metodoNaoEncontrado(objeto, nomeDoMetodo);
    }

    protected static ReflexaoException securityExceptionNoMetodo(Object objeto, String nomeDoMetodo, Class tipoDoParametro) {
        return UtilReflexaoException.securityExceptionNoMetodo(objeto, nomeDoMetodo, tipoDoParametro);
    }

    private static boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia((Object)objeto);
    }
}

