/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.reflexao.kernel;

import br.com.politec.generico.array.UtilArray;
import br.com.politec.generico.objeto.UtilPrimitivo;
import br.com.politec.reflexao.kernel.KernelAbstrato;

public class FabricaKernel
extends KernelAbstrato {
    public Class novaClasse(String classe) throws ClassNotFoundException {
        Class res = null;
        if (this.isVazio(classe)) {
            throw new ClassNotFoundException("null");
        }
        res = this.novaClasseDoPrimitivo(classe);
        res = this.novaClasseDoArray(res, classe);
        res = this.novaClasseDoObjeto(res, classe);
        return res;
    }

    public Object novoObjeto(String classe) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object res = null;
        Class classeObjeto = this.novaClasse(classe);
        res = this.novoObjeto(classeObjeto);
        return res;
    }

    public Object novoObjeto(Class classe) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Object res = null;
        if (!this.isReferencia(classe)) {
            throw new ClassNotFoundException("null");
        }
        res = this.criarInstanciaDaClasse(classe);
        return res;
    }

    private Object criarInstanciaDaClasse(Class classe) throws InstantiationException, IllegalAccessException {
        Object objeto = null;
        objeto = this.novoObjetoDoPrimitivo(classe);
        objeto = this.novoObjetoDoWrapper(objeto, classe);
        objeto = this.novoObjetoDoArray(objeto, classe);
        objeto = this.novoObjeto(objeto, classe);
        return objeto;
    }

    private Object novoObjeto(Object objeto, Class classe) throws InstantiationException, IllegalAccessException {
        Object res = objeto;
        if (!this.isReferencia(objeto)) {
            res = classe.newInstance();
        }
        return res;
    }

    private Object novoObjetoDoArray(Object objeto, Class classe) {
        Object res = objeto;
        if (!this.isReferencia(objeto) && UtilArray.isArray((Object)classe)) {
            res = UtilArray.novaInstanciaDeArray((Class)classe);
        }
        return res;
    }

    private Object novoObjetoDoPrimitivo(Class classe) {
        Object objeto = null;
        if (UtilPrimitivo.isPrimitivo((Class)classe)) {
            objeto = UtilPrimitivo.getValorDefault((Class)classe);
        }
        return objeto;
    }

    private Object novoObjetoDoWrapper(Object obj, Class classe) {
        Object objeto = obj;
        if (UtilPrimitivo.isWrapper((Class)classe)) {
            objeto = UtilPrimitivo.getValorDefault((Class)classe);
        }
        return objeto;
    }

    private Class novaClasseDoPrimitivo(String classe) {
        Class res = null;
        if (UtilPrimitivo.isPrimitivo((String)classe)) {
            res = UtilPrimitivo.getClasseWrapperDoPrimitivo((String)classe);
        }
        return res;
    }

    private Class novaClasseDoArray(Class novaClasse, String classe) throws ClassNotFoundException {
        Class res = novaClasse;
        if (!this.isReferencia(novaClasse) && UtilArray.isArray((String)classe)) {
            res = UtilArray.novaClasseDeArray((String)classe);
        }
        return res;
    }

    private Class novaClasseDoObjeto(Class novaClasse, String classe) throws ClassNotFoundException {
        Class<?> res = novaClasse;
        if (!this.isReferencia(novaClasse)) {
            res = Class.forName(classe);
        }
        return res;
    }
}

