/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.reflexao.kernel;

import br.com.politec.generico.objeto.UtilPrimitivo;
import br.com.politec.reflexao.UtilReflexaoMetodo;
import br.com.politec.reflexao.kernel.KernelAbstrato;
import br.com.politec.reflexao.util.IExecutor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class InvocarMetodoKernel
extends KernelAbstrato {
    public Object invocar(Object objeto, String pathMetodos) throws Exception {
        IExecutor executor = this.novoExecutorSemParametro();
        return this.loopPath(objeto, pathMetodos, null, executor);
    }

    public Object invocar(Object objeto, String pathMetodos, Object parametro) throws Exception {
        IExecutor executor = this.novoExecutorComParametro();
        return this.loopPath(objeto, pathMetodos, parametro, executor);
    }

    public Object invocar(Object objeto, Method metodo) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.invocar(objeto, metodo, null);
    }

    public Object invocar(Object objeto, Method metodo, Object parametro) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object res = null;
        if (this.isReferencia(objeto, metodo)) {
            res = this.isMetodoTemParametro(metodo) ? this.invocarComParametro(metodo, objeto, parametro) : this.invocarSemParametro(metodo, objeto);
        }
        return res;
    }

    private boolean isMetodoTemParametro(Method metodo) {
        return metodo.getParameterTypes().length > 0;
    }

    private Object invocarSemParametro(Method metodo, Object objeto) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return metodo.invoke(objeto, null);
    }

    private Object invocarComParametro(Method metodo, Object objeto, Object parametro) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        parametro = this.getValorDefaultSePrimitivo(metodo, parametro);
        return metodo.invoke(objeto, this.novoArrayObjeto(parametro));
    }

    private Object getValorDefaultSePrimitivo(Method metodo, Object parametro) {
        Class<?>[] parametros = metodo.getParameterTypes();
        if (!this.isReferencia(parametro) && parametros.length > 0) {
            Class<?> tipoDoParametro = metodo.getParameterTypes()[0];
            parametro = UtilPrimitivo.getValorDefault(tipoDoParametro);
        }
        return parametro;
    }

    private IExecutor novoExecutorSemParametro() {
        return new IExecutor(){

            public Object getObjeto(Object objeto, String atributo, Object valor) throws Exception {
                Method metodo = null;
                metodo = UtilReflexaoMetodo.getMetodo(objeto, atributo);
                return InvocarMetodoKernel.this.invocar(objeto, metodo, valor);
            }
        };
    }

    private IExecutor novoExecutorComParametro() {
        return new IExecutor(){

            public Object getObjeto(Object objeto, String atributo, Object valor) throws Exception {
                Method metodo = null;
                Class tipo = this.getTipoDoObjeto(valor);
                metodo = UtilReflexaoMetodo.getMetodo(objeto, atributo, tipo);
                return InvocarMetodoKernel.this.invocar(objeto, metodo, valor);
            }

            private Class getTipoDoObjeto(Object valor) {
                Class<?> tipo = null;
                if (InvocarMetodoKernel.this.isReferencia(valor)) {
                    tipo = valor.getClass();
                }
                return tipo;
            }
        };
    }

    private Object[] novoArrayObjeto(Object parametro) {
        return new Object[]{parametro};
    }
}

