/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.recebimentosdeterceiros;

import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.IBarraProgresso;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasEvent;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasListener;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfaceGerenciadorListas;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePlugin;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginCadastro;
import br.com.bb.plugins.negocio.comum.Identificacao;
import br.com.bb.plugins.negocio.comum.Pessoa;
import br.com.bb.plugins.negocio.infraestrutura.Filtro;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ClienteDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ConvenenteDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.IdentificadorDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.MembroGrupoRecebimentoDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.RecebimentoDBT;
import br.com.bb.plugins.persistencia.comum.ConexaoBancoDados;
import br.com.bb.plugins.persistencia.comum.IdentificacaoBD;
import br.com.bb.plugins.persistencia.comum.PessoaBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ClienteDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ClienteDBTListaBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ConvenenteDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.IdentificadorDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.RecebimentoDBTBD;
import com.ibm.webrunner.widget.MultiColumnListbox;
import java.awt.Cursor;
import java.sql.SQLException;
import java.util.Vector;

public class ControleCliente
extends Roteador
implements GerenciadorListasListener {
    private static ControleCliente controleCliente = null;
    private IInterfaceGerenciadorListas interfaceLista = null;
    private static Filtro filtro = null;
    private ConvenenteDBT convenenteDBT;
    private char indicadorOperacao;
    private ClienteDBT clienteDBT;
    private boolean isBotaoIncluirLista = false;

    private ControleCliente() {
    }

    public void abrirClienteAlterarInscricaoEncontada(Object objetoNegocio) throws Throwable {
        IInterfacePluginCadastro ipc = (IInterfacePluginCadastro)this.abrirInterface("ClienteCadastro", this);
        ipc.alterar(objetoNegocio);
        ipc.exibir();
    }

    public void abrirClienteCadastro() {
        if (!this.isBotaoIncluirLista) {
            ControleCliente.getFiltro().setCampo("TipoLista", null);
        }
        IInterfacePluginCadastro ipc = (IInterfacePluginCadastro)this.abrirInterface("ClienteCadastro", null);
        ipc.incluir(null);
        ipc.exibir();
        this.isBotaoIncluirLista = false;
    }

    public void abrirClienteCadastro(Object[] meuObjeto, char indicadorOperacao) throws SQLException {
        ClienteDBT clienteDBT = new ClienteDBT();
        clienteDBT.getPessoa().setCodigoPessoa((String)meuObjeto[0]);
        clienteDBT.getRelacaoPessoaPlugin().getConvenente().getPessoa().setCodigoPessoa(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
        ClienteDBTBD.getClienteDBTBD().obter(clienteDBT);
        IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("ClienteCadastro", null);
        if (indicadorOperacao == 'A') {
            interfacePluginCadastro.alterar(clienteDBT);
            interfacePluginCadastro.exibir();
        } else {
            if (indicadorOperacao == 'E') {
                if (clienteDBT.getPessoa().getCodigoPessoa().equals("0000001")) {
                    this.exibirMensagem("Cliente Banco do Brasil n\u00e3o pode ser exclu\u00eddo!");
                    return;
                }
                interfacePluginCadastro.excluir(clienteDBT);
            } else if (indicadorOperacao == 'D') {
                interfacePluginCadastro.detalhar(clienteDBT);
            }
            interfacePluginCadastro.exibir();
        }
    }

    public void abrirClienteCadastroComoDialog(Object objetoNegocio) {
        ControleCliente.getFiltro().setCampo("TipoLista", null);
        IInterfacePluginCadastro ipc = (IInterfacePluginCadastro)this.abrirInterfaceComoDialog("ClienteCadastro", null);
        ipc.incluir(objetoNegocio);
        ipc.exibir();
    }

    public void abrirClienteCadastroComoDialog(String codigoPessoaCliente) throws SQLException {
        ControleCliente.getFiltro().setCampo("TipoLista", null);
        ClienteDBT clienteDBT = new ClienteDBT();
        clienteDBT.getPessoa().setCodigoPessoa(codigoPessoaCliente);
        clienteDBT.getRelacaoPessoaPlugin().getConvenente().getPessoa().setCodigoPessoa(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
        ClienteDBTBD.getClienteDBTBD().obter(clienteDBT);
        IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterfaceComoDialog("ClienteCadastro", null);
        interfacePluginCadastro.alterar(clienteDBT);
        interfacePluginCadastro.exibir();
    }

    public void abrirExclusaoVariosClientes(Object[][] meuObjeto) throws Throwable {
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        try {
            if (this.exibirMensagemConfirmacao("Exclus\u00e3o de clientes", "Todos as identifica\u00e7\u00f5es e recebimentos vinculados aos clientes selecionados ser\u00e3o exclu\u00eddos automaticamente. Confirma a exclus\u00e3o dos " + meuObjeto.length + " clientes selecionados?")) {
                this.getFramePlugin().setCursor(new Cursor(3));
                IBarraProgresso barraProgresso = this.getFramePlugin().obterBarraProgresso();
                barraProgresso.inicializar("Excluindo clientes. Aguarde...", meuObjeto.length, false);
                barraProgresso.setValorMaximo(meuObjeto.length);
                int i = 0;
                while (i < meuObjeto.length) {
                    ClienteDBT clienteDBT = new ClienteDBT();
                    clienteDBT.getPessoa().setCodigoPessoa((String)meuObjeto[i][0]);
                    clienteDBT.getRelacaoPessoaPlugin().getConvenente().getPessoa().setCodigoPessoa(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
                    if (ClienteDBTBD.getClienteDBTBD().localizado(clienteDBT)) {
                        ClienteDBTBD.getClienteDBTBD().obter(clienteDBT);
                        this.excluirCliente(clienteDBT);
                    }
                    barraProgresso.setValor(i + 1);
                    ++i;
                }
                barraProgresso.finalizar();
                int lista = ClienteDBTListaBD.getClienteDBTListaDB().abrirLista(ControleCliente.getFiltro());
                this.getInterfaceLista().listar(ClienteDBTListaBD.getClienteDBTListaDB(), lista);
            }
            this.getFramePlugin().setCursor(new Cursor(0));
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
        }
        catch (SQLException t) {
            this.getFramePlugin().setCursor(new Cursor(0));
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
    }

    public void abrirFiltroCliente() throws Throwable {
        IInterfacePlugin i = this.abrirInterface("DialogFiltroCliente", null);
        i.exibir();
    }

    public void abrirManutencaoCliente(Filtro filtro) throws Throwable {
        ControleCliente.filtro = filtro;
        this.convenenteDBT = new ConvenenteDBT();
        this.convenenteDBT.getConvenente().getPessoa().setCodigoPessoa(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
        this.obterConvenente(this.convenenteDBT);
        if (ControleCliente.getFiltro().getCampo("TipoLista") != null && filtro.getCampo("TipoLista").equals("Cliente")) {
            this.getInterfaceLista().setarVisibilidadeColuna(1, true);
            if (this.convenenteDBT.getCodigoIdentificadorProprio() != null) {
                if (this.convenenteDBT.getCodigoIdentificadorProprio() != "" && this.convenenteDBT.getCodigoIdentificadorProprio().compareTo("") != 0) {
                    this.getInterfaceLista().setCabecalhoColuna(this.convenenteDBT.getCodigoIdentificadorProprio(), 3);
                    this.getInterfaceLista().setarVisibilidadeColuna(3, true);
                } else {
                    this.getInterfaceLista().setarVisibilidadeColuna(3, false);
                }
            } else {
                this.getInterfaceLista().setarVisibilidadeColuna(3, false);
            }
            this.getInterfaceLista().setarVisibilidadeColuna(4, false);
            this.getInterfaceLista().setarVisibilidadeColuna(6, false);
            this.getInterfaceLista().setarVisibilidadeColuna(7, false);
            this.getInterfaceLista().setarVisibilidadeColuna(8, false);
            this.getInterfaceLista().setarVisibilidadeColuna(9, false);
        } else {
            this.getInterfaceLista().setarVisibilidadeColuna(1, false);
            this.getInterfaceLista().setarVisibilidadeColuna(3, false);
            this.getInterfaceLista().setarVisibilidadeColuna(4, true);
            this.getInterfaceLista().setarVisibilidadeColuna(6, true);
            this.getInterfaceLista().setarVisibilidadeColuna(7, true);
            this.getInterfaceLista().setarVisibilidadeColuna(8, true);
            this.getInterfaceLista().setarVisibilidadeColuna(9, true);
        }
        this.getInterfaceLista().listar(ClienteDBTListaBD.getClienteDBTListaDB(), ClienteDBTListaBD.getClienteDBTListaDB().abrirLista(filtro));
        this.getInterfaceLista().exibir();
    }

    public void alterarCliente(ClienteDBT cliente, boolean sconv) throws Throwable {
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        boolean jaCadastrado = false;
        try {
            if (cliente.getPessoa().getCodigoPessoa().equals("0000001")) {
                this.exibirMensagem("O Cliente Banco do Brasil n\u00e3o pode ser alterado!");
            }
            if (sconv) {
                ClienteDBTBD.getClienteDBTBD().salvarParaTodosConvenentes(cliente);
            } else {
                this.salvarCliente(cliente);
            }
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
        }
        catch (SQLException t) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
    }

    public void alterarIdentificador(IdentificadorDBT identificadorAntigo, IdentificadorDBT identificadorNovo) throws Throwable {
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        try {
            IdentificadorDBTBD.getIdentificadorDBTBD().alterar(identificadorAntigo, identificadorNovo);
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
        }
        catch (SQLException t) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
    }

    public void alterarIdentificador(IdentificadorDBT identificador, MembroGrupoRecebimentoDBT membroAntigo) throws Throwable {
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        try {
            IdentificadorDBTBD.getIdentificadorDBTBD().alterar((Object)identificador, membroAntigo);
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
        }
        catch (SQLException t) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
    }

    public void alterarIdentificador(Object objetoNegocio) throws Throwable {
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        try {
            IdentificadorDBTBD.getIdentificadorDBTBD().alterar(objetoNegocio);
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
        }
        catch (SQLException t) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
    }

    public void atualizaListaCliente(ClienteDBT cliente) throws Throwable {
        if (ControleCliente.getFiltro().getCampo("TipoLista") != null) {
            int lista = ClienteDBTListaBD.getClienteDBTListaDB().abrirLista(ControleCliente.getFiltro());
            this.getInterfaceLista().listar(ClienteDBTListaBD.getClienteDBTListaDB(), lista);
        }
    }

    public void botaoAlterar(GerenciadorListasEvent event) {
        try {
            this.abrirClienteCadastro(event.getLinhas()[0], 'A');
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void botaoCancelar(GerenciadorListasEvent event) {
    }

    public void botaoDesmarcar(GerenciadorListasEvent event) {
    }

    public void botaoDetalhar(GerenciadorListasEvent event) {
        try {
            this.abrirClienteCadastro(event.getLinhas()[0], 'D');
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void botaoExcluir(GerenciadorListasEvent event) {
        try {
            if (event.getLinhas().length > 1) {
                this.abrirExclusaoVariosClientes(event.getLinhas());
            } else {
                this.abrirClienteCadastro(event.getLinhas()[0], 'E');
            }
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void botaoFiltro(GerenciadorListasEvent event) {
        this.abrirInterface("DialogFiltroCliente", null).exibir();
    }

    public void botaoImprimir(GerenciadorListasEvent event, MultiColumnListbox multicolumn) {
        if (event.getSource() == this.getInterfaceLista()) {
            if (multicolumn.getRowCount() == 0) {
                this.exibirMensagem("N\u00e3o h\u00e1 Clientes cadastrados para impress\u00e3o do relat\u00f3rio");
            } else {
                IInterfacePlugin i = this.abrirInterface("DialogRelatorioCliente", null);
                i.popular(ControleCliente.getFiltro());
                i.exibir();
            }
        }
    }

    public void botaoIncluir(GerenciadorListasEvent event) {
        this.isBotaoIncluirLista = true;
        this.abrirClienteCadastro();
    }

    public void botaoMarcar(GerenciadorListasEvent event) {
    }

    public void botaoOK(GerenciadorListasEvent event) {
    }

    public void botaoSair(GerenciadorListasEvent event) {
    }

    public void enviarConvenioSelecionadoAlterar(Object[][] convenio, ClienteDBT cliente) throws Throwable {
        IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("DialogContaIdentificadorDBTCadastro", null);
        this.setClienteDBT(cliente);
        interfacePluginCadastro.alterar(convenio);
        interfacePluginCadastro.exibir();
    }

    public void enviarConvenioSelecionadoDetalhar(Object[][] convenio, ClienteDBT cliente) throws Throwable {
        IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("DialogContaIdentificadorDBTCadastro", null);
        this.setClienteDBT(cliente);
        interfacePluginCadastro.detalhar(convenio);
        interfacePluginCadastro.exibir();
    }

    public void enviarConvenioSelecionadoExcluir(Object[][] convenio, ClienteDBT cliente) throws Throwable {
        IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("DialogContaIdentificadorDBTCadastro", null);
        this.setClienteDBT(cliente);
        interfacePluginCadastro.excluir(convenio);
        interfacePluginCadastro.exibir();
    }

    public void enviarConvenioSelecionadoIncluir(Object[][] convenio, ClienteDBT cliente) throws Throwable {
        IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("DialogContaIdentificadorDBTCadastro", null);
        this.setClienteDBT(cliente);
        interfacePluginCadastro.incluir(convenio);
        interfacePluginCadastro.exibir();
    }

    public void excluirCliente(ClienteDBT clienteRecebimento) throws Throwable {
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        try {
            ClienteDBTBD.getClienteDBTBD().remover(clienteRecebimento);
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
        }
        catch (SQLException t) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
        int lista = ClienteDBTListaBD.getClienteDBTListaDB().abrirLista(ControleCliente.getFiltro());
        this.getInterfaceLista().listar(ClienteDBTListaBD.getClienteDBTListaDB(), lista);
    }

    public void excluirCliente(ClienteDBT clienteRecebimento, boolean atualizaLista) throws Throwable {
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        try {
            ClienteDBTBD.getClienteDBTBD().remover(clienteRecebimento);
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
        }
        catch (SQLException t) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
        if (atualizaLista) {
            if (ControleCliente.getFiltro().getCampo("TipoLista") != null && ControleCliente.getFiltro().getCampo("TipoLista").equals("ClienteIDDBT")) {
                int lista = ClienteDBTListaBD.getClienteDBTListaDB().abrirLista(ControleCliente.getFiltro());
                this.getInterfaceLista().listar(ClienteDBTListaBD.getClienteDBTListaDB(), lista);
            } else {
                this.getInterfaceLista().excluido(clienteRecebimento);
            }
        }
    }

    public void excluirIdentificador(IdentificadorDBT identificador) throws Throwable {
        IdentificadorDBTBD.getIdentificadorDBTBD().remover(identificador);
    }

    public void excluirIdentificadorNoBB(IdentificadorDBT identificador) throws Throwable {
        IdentificadorDBTBD.getIdentificadorDBTBD().removerNoBB(identificador);
    }

    public void excluirRecebimento(RecebimentoDBT recebimento, ClienteDBT cliente) throws SQLException {
        RecebimentoDBTBD.getRecebimentoDBTBD().remover(cliente);
    }

    public ClienteDBT getClienteDBT() {
        if (this.clienteDBT == null) {
            this.clienteDBT = new ClienteDBT();
        }
        return this.clienteDBT;
    }

    public static ControleCliente getControleCliente() {
        if (controleCliente == null) {
            controleCliente = new ControleCliente();
        }
        return controleCliente;
    }

    public static Filtro getFiltro() {
        if (filtro == null) {
            filtro = new Filtro();
        }
        return filtro;
    }

    public char getIndicadorOperacao() {
        return this.indicadorOperacao;
    }

    public IInterfaceGerenciadorListas getInterfaceLista() {
        if (this.interfaceLista == null) {
            this.interfaceLista = (IInterfaceGerenciadorListas)this.abrirInterface("ClienteManutencao", null);
            this.interfaceLista.addGerenciadorListasListener(this);
            this.interfaceLista.setModal(true);
            this.interfaceLista.setTitulo("Selecione o Cliente e escolha a a\u00e7\u00e3o desejada.");
            this.interfaceLista.addColuna("C\u00f3digo", 0, false, false);
            this.interfaceLista.addColuna("Inscri\u00e7\u00e3o", 20, true, true);
            this.interfaceLista.addColuna("Nome", 30, true, true);
            this.interfaceLista.addColuna("(Identificador Pr\u00f3prio)", 20, true, true);
            this.interfaceLista.addColuna("Conv\u00eanio", 10, true, true);
            this.interfaceLista.addColuna("IDDBT", 0, false, false);
            this.interfaceLista.addColuna("Identifica\u00e7\u00e3o P/D\u00e9bito", 30, true, true);
            this.interfaceLista.addColuna("Situa\u00e7\u00e3o", 20, true, true);
            this.interfaceLista.addColuna("Grupo", 30, true, true);
            this.interfaceLista.addColuna("Autoriza\u00e7\u00e3o Impressa", 22, true, true);
            this.interfaceLista.setTituloRelatorio("Rela\u00e7\u00e3o de Clientes/Identifica\u00e7\u00f5es P/D\u00e9bito");
            this.interfaceLista.setLinhasHorizontais(true);
            this.interfaceLista.setLinhasVerticais(true);
            this.interfaceLista.setLayout(4);
        }
        return this.interfaceLista;
    }

    public void incluirCliente(ClienteDBT cliente, boolean sconv) throws Throwable {
        this.setClienteDBT(cliente);
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        boolean jaCadastrado = false;
        try {
            if (sconv) {
                this.salvarClienteParaTodosConvenentes(cliente);
            } else {
                this.salvarCliente(cliente);
            }
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
        }
        catch (SQLException t) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
    }

    public void incluirdentificador(IdentificadorDBT identificador) throws Throwable {
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        try {
            IdentificadorDBTBD.getIdentificadorDBTBD().adicionar(identificador);
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
        }
        catch (SQLException t) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
    }

    public boolean isClienteExiste(ClienteDBT clienteRecebimento) throws Throwable {
        return ClienteDBTBD.getClienteDBTBD().localizado(clienteRecebimento);
    }

    public boolean isConvenente(ConvenenteDBT convenente) throws SQLException {
        return ConvenenteDBTBD.getConvenenteDBTBD().localizado(convenente);
    }

    public void obterCliente(ClienteDBT cliente) throws Throwable {
        ClienteDBTBD.getClienteDBTBD().obter(cliente);
    }

    public void obterConvenente(ConvenenteDBT convenente) throws SQLException {
        ConvenenteDBTBD.getConvenenteDBTBD().obter(convenente);
    }

    public void obterIdentificacao(Identificacao identificacao) throws SQLException {
        IdentificacaoBD.getIdentificacaoBD().obter(identificacao);
    }

    public Vector obterIdentificadores(ClienteDBT cliente) throws SQLException {
        return IdentificadorDBTBD.getIdentificadorDBTBD().obterLista(cliente);
    }

    public void obterIDProprio(Identificacao identificacao) throws SQLException {
        IdentificacaoBD.getIdentificacaoBD().obter(identificacao);
    }

    public void obterPessoa(Pessoa pessoa) throws SQLException {
        PessoaBD.getPessoaBD().obter(pessoa);
    }

    public void obterRecebimentoDBT(RecebimentoDBT recebimentoDBT) throws SQLException {
        RecebimentoDBTBD.getRecebimentoDBTBD().obterPorIDDBT(recebimentoDBT);
    }

    public void salvarCliente(ClienteDBT clienteRecebimento) throws Throwable {
        ClienteDBTBD.getClienteDBTBD().salvar(clienteRecebimento);
    }

    public void salvarClienteParaTodosConvenentes(ClienteDBT clienteRecebimento) throws Throwable {
        ClienteDBTBD.getClienteDBTBD().salvarParaTodosConvenentes(clienteRecebimento);
    }

    private void setClienteDBT(ClienteDBT newClienteDBT) {
        this.clienteDBT = newClienteDBT;
    }

    public void setIndicadorOperacao(char newIndicadorOperacao) {
        this.indicadorOperacao = newIndicadorOperacao;
    }

    public void VerificaExistenciaIdentificacao(ClienteDBT clienteDBT) throws SQLException {
        ClienteDBTBD.getClienteDBTBD().obterIDProprioJaExistente(clienteDBT);
    }
}

