/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.recebimentosdeterceiros;

import br.com.bb.plugins.controle.infraestrutura.IBarraProgresso;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ConvenioDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.RecebimentoDBT;
import br.com.bb.plugins.persistencia.comum.ConexaoBancoDados;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.RecebimentoDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.RecebimentoDBTListaBD;
import java.awt.Cursor;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;

public class ControleExpurgo
extends Roteador {
    private static ControleExpurgo controleExpurgo = null;

    private ControleExpurgo() {
    }

    public void abrirExpurgo() {
        this.abrirInterface("Expurgo", null).exibir();
    }

    public static ControleExpurgo getControleExpurgo() {
        if (controleExpurgo == null) {
            controleExpurgo = new ControleExpurgo();
        }
        return controleExpurgo;
    }

    public void processarExpurgo(Date dataInicial, Date dataFinal, ConvenioDBT convenio, boolean automatico) throws Throwable {
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        try {
            Vector recebimentos = RecebimentoDBTListaBD.getRecebimentoDBTListaBD().obterListaExpurgo(dataInicial, dataFinal, convenio.getNumeroConvenioDBT());
            if (recebimentos.size() > 0) {
                this.getFramePlugin().setCursor(new Cursor(3));
                IBarraProgresso barraProgresso = this.obterBarraProgresso();
                barraProgresso.inicializar("Aguarde. Expurgando recebimentos do Conv\u00eanio " + convenio.getNumeroConvenioDBT(), recebimentos.size(), false);
                barraProgresso.setValor(0);
                int i = 0;
                while (i < recebimentos.size()) {
                    RecebimentoDBTBD.getRecebimentoDBTBD().remover((RecebimentoDBT)recebimentos.elementAt(i));
                    barraProgresso.setValor(i);
                    ++i;
                }
                barraProgresso.finalizar();
                this.exibirMensagem("Expurgo realizado com sucesso!");
            } else if (!automatico) {
                this.exibirMensagem("N\u00e3o existem recebimentos para expurgo que atendam \u00e0 condi\u00e7\u00e3o informada!");
            }
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
        }
        catch (Throwable t) {
            try {
                ConexaoBancoDados.getConexao().commit();
                ConexaoBancoDados.getConexao().setAutoCommit(true);
                this.getFramePlugin().setCursor(new Cursor(0));
                ConexaoBancoDados.getConexao().rollback();
                ConexaoBancoDados.getConexao().setAutoCommit(true);
            }
            catch (SQLException e) {
                this.exibirMensagemErro(e);
            }
            this.exibirMensagemErro(t);
        }
    }
}

