/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.recebimentosdeterceiros;

import br.com.bb.plugins.controle.impressao.ControleImpressao;
import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasEvent;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasListener;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfaceGerenciadorListas;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginCadastro;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ConvenioDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.GrupoClienteRecebimento;
import br.com.bb.plugins.persistencia.comum.ConexaoBancoDados;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ConvenioDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.GrupoClienteRecebimentoBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.MembroGrupoRecebimentoDBTBD;
import br.com.bb.plugins.utilitarios.Util;
import com.ibm.webrunner.widget.MultiColumnListbox;
import java.sql.SQLException;
import java.util.Vector;

public class ControleGrupoClientes
extends Roteador
implements GerenciadorListasListener {
    private static ControleGrupoClientes controleGrupoClientes = null;
    private IInterfaceGerenciadorListas interfaceLista = null;

    private ControleGrupoClientes() {
    }

    public void abrirAlteracaoGrupo(GrupoClienteRecebimento grupoClienteRecebimento) {
        IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("DialogGrupoClientesCadastro", null);
        interfacePluginCadastro.alterar(grupoClienteRecebimento);
        interfacePluginCadastro.exibir();
    }

    public void abrirDetalheGrupo(GrupoClienteRecebimento grupoClienteRecebimento) {
        IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("DialogGrupoClientesCadastro", null);
        interfacePluginCadastro.detalhar(grupoClienteRecebimento);
        interfacePluginCadastro.exibir();
    }

    public void abrirExclusaoGrupo(GrupoClienteRecebimento grupoClienteRecebimento) {
        IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("DialogGrupoClientesCadastro", null);
        interfacePluginCadastro.excluir(grupoClienteRecebimento);
        interfacePluginCadastro.exibir();
    }

    public void abrirGrupoClientesCadastro() {
        this.abrirInterface("DialogGrupoClientesCadastro", null).exibir();
    }

    public void abrirManutencaoGrupoClientes() {
        try {
            int lista = GrupoClienteRecebimentoBD.getGrupoClienteRecebimentoBD().abrirLista();
            this.getInterfaceLista().limpar();
            this.getInterfaceLista().listar(GrupoClienteRecebimentoBD.getGrupoClienteRecebimentoBD(), lista);
            this.getInterfaceLista().exibir();
        }
        catch (Exception e) {
            Util.exibirMensagemErro(e);
        }
    }

    public void botaoAlterar(GerenciadorListasEvent event) {
        try {
            GrupoClienteRecebimento grupoClienteRecebimento = new GrupoClienteRecebimento();
            grupoClienteRecebimento.setCodigoGrupoClienteRecebimento(Integer.parseInt((String)event.getLinhas()[0][0]));
            GrupoClienteRecebimentoBD.getGrupoClienteRecebimentoBD().obter(grupoClienteRecebimento);
            this.abrirAlteracaoGrupo(grupoClienteRecebimento);
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void botaoCancelar(GerenciadorListasEvent event) {
    }

    public void botaoDesmarcar(GerenciadorListasEvent event) {
    }

    public void botaoDetalhar(GerenciadorListasEvent event) {
        try {
            GrupoClienteRecebimento grupoClienteRecebimento = new GrupoClienteRecebimento();
            grupoClienteRecebimento.setCodigoGrupoClienteRecebimento(Integer.parseInt((String)event.getLinhas()[0][0]));
            GrupoClienteRecebimentoBD.getGrupoClienteRecebimentoBD().obter(grupoClienteRecebimento);
            this.abrirDetalheGrupo(grupoClienteRecebimento);
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void botaoExcluir(GerenciadorListasEvent event) {
        try {
            GrupoClienteRecebimento grupoClienteRecebimento = new GrupoClienteRecebimento();
            grupoClienteRecebimento.setCodigoGrupoClienteRecebimento(Integer.parseInt((String)event.getLinhas()[0][0]));
            GrupoClienteRecebimentoBD.getGrupoClienteRecebimentoBD().obter(grupoClienteRecebimento);
            Vector vetorClientesGrupo = MembroGrupoRecebimentoDBTBD.getMembroGrupoRecebimentoDBTBD().obterLista(grupoClienteRecebimento);
            if (vetorClientesGrupo.size() > 0) {
                this.exibirMensagem("O Grupo " + grupoClienteRecebimento.getTextoDescricao() + " n\u00e3o pode ser exclu\u00eddo porque existem clientes cadastrados");
            } else {
                this.abrirExclusaoGrupo(grupoClienteRecebimento);
            }
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void botaoFiltro(GerenciadorListasEvent event) {
        this.exibirMensagem("Fun\u00e7\u00e3o n\u00e3o dispon\u00edvel para esta tela");
    }

    public void botaoImprimir(GerenciadorListasEvent event, MultiColumnListbox multicolumn) {
        ControleImpressao.getControle().setCodigoRelatorio("DBT201");
        ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de grupo de clientes");
        ControleImpressao.getControle().imprimir(multicolumn, "Relat\u00f3rio de grupo de clientes");
    }

    public void botaoIncluir(GerenciadorListasEvent event) {
        try {
            ConvenioDBT convenioDBT = new ConvenioDBT();
            convenioDBT.setCodigoPessoaConvenenteDBT(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            Vector listaConvenio = ConvenioDBTBD.getConvenioDBTBD().obterLista(convenioDBT);
            if (listaConvenio.size() < 1) {
                this.exibirMensagem("N\u00e3o existe conv\u00eanio cadastrado! Favor efetuar o processamento do arquivo de configura\u00e7\u00e3o autom\u00e1tica!");
                return;
            }
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
        IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("DialogGrupoClientesCadastro", null);
        GrupoClienteRecebimento grupoClienteRecebimento = new GrupoClienteRecebimento();
        interfacePluginCadastro.incluir(grupoClienteRecebimento);
        interfacePluginCadastro.exibir();
    }

    public void botaoMarcar(GerenciadorListasEvent event) {
    }

    public void botaoOK(GerenciadorListasEvent event) {
    }

    public void botaoSair(GerenciadorListasEvent event) {
    }

    public static ControleGrupoClientes getControleGrupoClientes() {
        if (controleGrupoClientes == null) {
            controleGrupoClientes = new ControleGrupoClientes();
        }
        return controleGrupoClientes;
    }

    public IInterfaceGerenciadorListas getInterfaceLista() {
        if (this.interfaceLista == null) {
            this.interfaceLista = (IInterfaceGerenciadorListas)this.abrirInterface("GrupoClientesManutencao", null);
            this.interfaceLista.addGerenciadorListasListener(this);
            this.interfaceLista.setTitulo("Selecione o Grupo de Clientes e escolha a a\u00e7\u00e3o desejada.");
            this.interfaceLista.addColuna("C\u00f3digo do Grupo", 0, false, false);
            this.interfaceLista.addColuna("Conv\u00eanio", 10, true, true);
            this.interfaceLista.addColuna("Grupo", 90, true, true);
            this.interfaceLista.addColuna("C\u00f3digo do convenente", 0, false, false);
            this.interfaceLista.setTituloRelatorio("Rela\u00e7\u00e3o de Grupos de Clientes");
            this.interfaceLista.setLinhasHorizontais(true);
            this.interfaceLista.setLinhasVerticais(true);
            this.interfaceLista.setLayout(4);
        }
        return this.interfaceLista;
    }

    public Vector obterListaGrupo() throws Throwable {
        return GrupoClienteRecebimentoBD.getGrupoClienteRecebimentoBD().obterLista();
    }

    public Vector obterListaGrupo(GrupoClienteRecebimento grupoClienteDBT) throws Throwable {
        return GrupoClienteRecebimentoBD.getGrupoClienteRecebimentoBD().obterLista(grupoClienteDBT);
    }

    public Vector obterListaGrupoPorConvenio(String convenio) throws Throwable {
        return GrupoClienteRecebimentoBD.getGrupoClienteRecebimentoBD().obterListaPorConvenio(convenio);
    }

    public void salvarGrupo(Object objetoNegocio, char indicadorOperacao) throws Throwable {
        GrupoClienteRecebimento grupoClientesRec = (GrupoClienteRecebimento)objetoNegocio;
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        try {
            if (indicadorOperacao == 'I') {
                GrupoClienteRecebimentoBD.getGrupoClienteRecebimentoBD().salvar(grupoClientesRec);
                this.getInterfaceLista().incluido(grupoClientesRec);
            } else if (indicadorOperacao == 'A') {
                GrupoClienteRecebimentoBD.getGrupoClienteRecebimentoBD().salvar(grupoClientesRec);
                this.getInterfaceLista().alterado(grupoClientesRec);
            } else if (indicadorOperacao == 'E') {
                GrupoClienteRecebimentoBD.getGrupoClienteRecebimentoBD().remover(grupoClientesRec);
                this.getInterfaceLista().excluido(grupoClientesRec);
            }
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
        }
        catch (SQLException t) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
    }
}

