/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.recebimentosdeterceiros;

import br.com.bb.plugins.controle.impressao.ControleImpressao;
import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.IBarraProgresso;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.controle.recebimentosdeterceiros.ControleMovimento;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasEvent;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasListenerSimples;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfaceGerenciadorListas;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginCadastro;
import br.com.bb.plugins.negocio.comum.Identificacao;
import br.com.bb.plugins.negocio.infraestrutura.ArquivoRemessa;
import br.com.bb.plugins.negocio.infraestrutura.RegistroRemessa;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ConvenenteDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ConvenioDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.IdentificadorDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.RecebimentoDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.RemessaRecebimentoDBT;
import br.com.bb.plugins.persistencia.comum.ConexaoBancoDados;
import br.com.bb.plugins.persistencia.comum.IdentificacaoBD;
import br.com.bb.plugins.persistencia.infraestrutura.ArquivoRemessaBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ConvenenteDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ConvenioDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.IdentificadorDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.IdentificadorDBTListaBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.RecebimentoDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.RecebimentoDBTListaBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.RemessaRecebimentoBD;
import br.com.bb.plugins.utilitarios.Util;
import com.ibm.webrunner.widget.MultiColumnListbox;
import java.io.File;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;

public class ControleRemessaRecebimentos
extends Roteador
implements GerenciadorListasListenerSimples {
    public RemessaRecebimentoDBT remessaRecebimentos = new RemessaRecebimentoDBT();
    public RecebimentoDBT recebimento = new RecebimentoDBT();
    private static ControleRemessaRecebimentos controleRemessaRecebimentos = null;
    private IInterfaceGerenciadorListas interfaceGerenciadorListaRemessaRecuperarRecebimento;
    private ArquivoRemessa book = null;
    private int qteRegArquivo = 0;
    private double totalValorRemessa = 0.0;
    private int qteRegLote = 0;
    private double totalValorLote = 0.0;
    private RegistroRemessa registroRemessa = new RegistroRemessa();
    public ConvenenteDBT convenenteRecebimentos = new ConvenenteDBT();
    public ConvenioDBT convenio = new ConvenioDBT();
    private double valorTotal = 0.0;
    private int QtdTotal = 0;
    private int QtdRecebimentosRemessa = 0;
    private int QtdIDAlteradoRemessa = 0;
    private int QtdIDManutencaoRemessa = 0;
    private Vector vetorParametrosRemessa = new Vector();
    private Vector vetorRecebimentosRemessa = new Vector();
    private Vector vetorIDAlteradoRemessa = new Vector();
    private Vector vetorIDManutencaoRemessa = new Vector();
    private Vector vetorRecebimentosManutRem = new Vector();
    private IdentificadorDBT identificadorDBT = new IdentificadorDBT();

    private ControleRemessaRecebimentos() {
        try {
            this.book = ArquivoRemessaBD.obterArquivoRemessa("DBT");
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void abrirGeracaoRemessa() {
        try {
            IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("FiltroContrato", null);
            interfacePluginCadastro.incluir(null);
            interfacePluginCadastro.exibir();
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void abrirPrepararRemessa(ConvenioDBT convenioDBT, Vector vetorRecebimentosRemessa, Vector vetorIDManutencaoRemessa, Vector vetorIDAlteradoRemessa, double valorTotalRemessa, int qtdTotalRemessa) {
        try {
            IInterfacePluginCadastro ipc = (IInterfacePluginCadastro)this.abrirInterface("DialogRemessaResumo", null);
            Vector<Object> vetorParametrosRemessa = new Vector<Object>();
            vetorParametrosRemessa.addElement(convenioDBT);
            vetorParametrosRemessa.addElement(vetorRecebimentosRemessa);
            vetorParametrosRemessa.addElement(vetorIDManutencaoRemessa);
            vetorParametrosRemessa.addElement(vetorIDAlteradoRemessa);
            vetorParametrosRemessa.addElement(String.valueOf(valorTotalRemessa));
            vetorParametrosRemessa.addElement(String.valueOf(qtdTotalRemessa));
            vetorParametrosRemessa.addElement(this.vetorRecebimentosManutRem);
            ipc.incluir(vetorParametrosRemessa);
            ipc.exibir();
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void abrirPrepararRemessa(ConvenioDBT convenioDBT, Vector vetorRecebimentosRemessa, Vector vetorIDManutencaoRemessa, Vector vetorIDAlteradoRemessa, double valorTotalRemessa, int qtdTotalRemessa, Vector vetorRecebimentosManutRem) {
        try {
            IInterfacePluginCadastro ipc = (IInterfacePluginCadastro)this.abrirInterface("DialogRemessaResumo", null);
            Vector<Object> vetorParametrosRemessa = new Vector<Object>();
            vetorParametrosRemessa.addElement(convenioDBT);
            vetorParametrosRemessa.addElement(vetorRecebimentosRemessa);
            vetorParametrosRemessa.addElement(vetorIDManutencaoRemessa);
            vetorParametrosRemessa.addElement(vetorIDAlteradoRemessa);
            vetorParametrosRemessa.addElement(String.valueOf(valorTotalRemessa));
            vetorParametrosRemessa.addElement(String.valueOf(qtdTotalRemessa));
            vetorParametrosRemessa.addElement(vetorRecebimentosManutRem);
            vetorParametrosRemessa.addElement(vetorRecebimentosManutRem);
            ipc.incluir(vetorParametrosRemessa);
            ipc.exibir();
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void abrirRecuperacaoRemessa() throws SQLException {
        this.getInterfaceGerenciadorListaRemessaRecuperarRecebimento().limpar();
        this.getInterfaceGerenciadorListaRemessaRecuperarRecebimento().listar(RemessaRecebimentoBD.getRemessaRecebimentoBD(), RemessaRecebimentoBD.getRemessaRecebimentoBD().abrirLista());
        this.getInterfaceGerenciadorListaRemessaRecuperarRecebimento().exibir();
    }

    public void actionPerformedGerenciadorListas(GerenciadorListasEvent evento, MultiColumnListbox multicolumn) {
        try {
            if (evento.getBotaoComando().equalsIgnoreCase("OK")) {
                if (evento.getSource() == this.getInterfaceGerenciadorListaRemessaRecuperarRecebimento()) {
                    this.recuperarRetorno(multicolumn);
                    ConexaoBancoDados.getConexao().commit();
                    ConexaoBancoDados.getConexao().setAutoCommit(true);
                    this.abrirRecuperacaoRemessa();
                    evento.setConsumido(true);
                }
            } else if (evento.getBotaoComando().equalsIgnoreCase("Imprimir")) {
                ControleImpressao.getControle().setCodigoRelatorio("DBT701");
                ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de Remessas para Recupera\u00e7\u00e3o");
                ControleImpressao.getControle().imprimir(multicolumn, "Relat\u00f3rio de Remessas para Recupera\u00e7\u00e3o");
            }
        }
        catch (Throwable t) {
            try {
                ConexaoBancoDados.getConexao().rollback();
                ConexaoBancoDados.getConexao().setAutoCommit(true);
            }
            catch (Throwable t1) {
                this.exibirMensagemErro(t1);
            }
            Util.exibirMensagemErro(t);
            evento.setConsumido(true);
        }
    }

    public String emitirNomeArquivoRemessa() throws Throwable {
        return "REC_" + this.convenio.getNumeroConvenioDBT() + "_" + Util.padR(String.valueOf(this.remessaRecebimentos.getNumeroRemessa()), 6, "0") + ".rem";
    }

    public void excluirRemessa(RemessaRecebimentoDBT remessa) throws Throwable {
        RemessaRecebimentoBD.getRemessaRecebimentoBD().remover(remessa);
    }

    public void gerarRemessa(Vector vetorParametrosRemessa) throws Throwable {
        try {
            ConexaoBancoDados.getConexao().setAutoCommit(false);
            this.convenio = (ConvenioDBT)vetorParametrosRemessa.elementAt(0);
            this.vetorRecebimentosRemessa = (Vector)vetorParametrosRemessa.elementAt(1);
            this.vetorIDManutencaoRemessa = (Vector)vetorParametrosRemessa.elementAt(2);
            this.vetorIDAlteradoRemessa = (Vector)vetorParametrosRemessa.elementAt(3);
            this.vetorRecebimentosManutRem = (Vector)vetorParametrosRemessa.elementAt(6);
            String valorTotalRemessa = (String)vetorParametrosRemessa.elementAt(4);
            this.valorTotal = Double.valueOf(valorTotalRemessa);
            String qtdTotalRemessa = (String)vetorParametrosRemessa.elementAt(5);
            this.QtdTotal = Integer.valueOf(qtdTotalRemessa);
            this.identificadorDBT = new IdentificadorDBT();
            this.recebimento = new RecebimentoDBT();
            this.remessaRecebimentos = new RemessaRecebimentoDBT();
            this.remessaRecebimentos.setCodigoPessoaFK(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            this.remessaRecebimentos.setDataRemessa(new Date());
            this.remessaRecebimentos.setNumeroConvenioFK(this.convenio.getNumeroConvenioDBT());
            RemessaRecebimentoDBT remessaRecebimentoDBT = new RemessaRecebimentoDBT();
            remessaRecebimentoDBT.setNumeroConvenioFK(this.convenio.getNumeroConvenioDBT());
            this.remessaRecebimentos.setNumeroRemessa(RemessaRecebimentoBD.getRemessaRecebimentoBD().obterProximoSequencial(remessaRecebimentoDBT));
            this.convenio.setNumeroUltimaRemessa(this.remessaRecebimentos.getNumeroRemessa());
            ConvenioDBTBD.getConvenioDBTBD().salvar(this.convenio);
            IBarraProgresso barra = this.getFramePlugin().obterBarraProgresso();
            barra.setMensagem("Gerando Arquivo de Remessa. AGUARDE...");
            barra.setValorMaximo(this.QtdTotal);
            barra.setValor(0);
            ConvenenteDBT convenenteDBT = new ConvenenteDBT();
            convenenteDBT.setConvenente(ControleAplicacao.getConvenente());
            ConvenenteDBTBD.getConvenenteDBTBD().obter(convenenteDBT);
            String arqOrigem = String.valueOf(ControleAplicacao.getPlugin().getCodigoPlugin()) + "Remessa.rem";
            String arqDestino = String.valueOf(ControleAplicacao.getPlugin().getCodigoPlugin()) + "_" + this.convenio.getNumeroConvenioDBT() + "_" + Util.strZero(String.valueOf(this.remessaRecebimentos.getNumeroRemessa()), 6) + ".rem";
            String dirOrigem = ControleAplicacao.getDiretorioTemp();
            String dirDestino = ControleAplicacao.getDiretorioRemessa();
            int intContador = 0;
            this.qteRegArquivo = this.QtdTotal + 2;
            this.totalValorRemessa = this.valorTotal;
            this.book.abrirArquivoSaida(new File(String.valueOf(dirOrigem) + arqOrigem));
            this.gravarHeader();
            int i = 0;
            while (i < this.vetorIDAlteradoRemessa.size()) {
                this.identificadorDBT = (IdentificadorDBT)this.vetorIDAlteradoRemessa.elementAt(i);
                this.gravarDetalheD(this.identificadorDBT);
                this.identificadorDBT.setNumeroRemessaAlteracao(this.remessaRecebimentos.getNumeroRemessa());
                this.identificadorDBT.setDataRemessaAlteracao(this.remessaRecebimentos.getDataRemessa());
                this.identificadorDBT.setDataUltimaRemessa(this.remessaRecebimentos.getDataRemessa());
                IdentificadorDBTBD.getIdentificadorDBTBD().AlterarIDRemessa(this.identificadorDBT);
                barra.setValor(++intContador);
                ++i;
            }
            i = 0;
            while (i < this.vetorIDManutencaoRemessa.size()) {
                this.recebimento.setNumeroRecebimentoDBT(0);
                this.recebimento.setIdRegistro("");
                this.identificadorDBT = (IdentificadorDBT)this.vetorIDManutencaoRemessa.elementAt(i);
                this.recebimento.setIdentificadorDBT(this.identificadorDBT);
                this.montarRecebimentoManutencaoID(this.recebimento);
                this.recebimento.setDataRemessaRel(this.remessaRecebimentos.getDataRemessa());
                this.recebimento.setNumeroRemessaRel(this.remessaRecebimentos.getNumeroRemessa());
                RecebimentoDBTBD.getRecebimentoDBTBD().salvar(this.recebimento);
                this.recebimento.getIdentificadorDBT().setDataUltimaRemessa(this.remessaRecebimentos.getDataRemessa());
                this.identificadorDBT.setDataUltimaRemessa(this.remessaRecebimentos.getDataRemessa());
                IdentificadorDBTBD.getIdentificadorDBTBD().AlterarIDRemessa(this.identificadorDBT);
                this.gravarDetalheE(this.identificadorDBT, this.recebimento.getIdRegistro());
                barra.setValor(++intContador);
                ++i;
            }
            i = 0;
            while (i < this.vetorRecebimentosManutRem.size()) {
                this.recebimento = (RecebimentoDBT)this.vetorRecebimentosManutRem.elementAt(i);
                this.gravarDetalheE(this.recebimento);
                this.recebimento.setDataRemessaRel(this.remessaRecebimentos.getDataRemessa());
                this.recebimento.setNumeroRemessaRel(this.remessaRecebimentos.getNumeroRemessa());
                this.recebimento.setCodigoSituacaoRecebimentoRel("R");
                RecebimentoDBTBD.getRecebimentoDBTBD().alterar(this.recebimento);
                this.recebimento.getIdentificadorDBT().setDataUltimaRemessa(this.remessaRecebimentos.getDataRemessa());
                IdentificadorDBTBD.getIdentificadorDBTBD().AlterarIDRemessa(this.recebimento.getIdentificadorDBT());
                barra.setValor(++intContador);
                ++i;
            }
            i = 0;
            while (i < this.vetorRecebimentosRemessa.size()) {
                this.recebimento = (RecebimentoDBT)this.vetorRecebimentosRemessa.elementAt(i);
                this.gravarDetalheE(this.recebimento);
                this.recebimento.setDataRemessaRel(this.remessaRecebimentos.getDataRemessa());
                this.recebimento.setNumeroRemessaRel(this.remessaRecebimentos.getNumeroRemessa());
                this.recebimento.setCodigoSituacaoRecebimentoRel("R");
                RecebimentoDBTBD.getRecebimentoDBTBD().alterar(this.recebimento);
                this.recebimento.getIdentificadorDBT().setDataUltimaRemessa(this.remessaRecebimentos.getDataRemessa());
                IdentificadorDBTBD.getIdentificadorDBTBD().AlterarIDRemessa(this.recebimento.getIdentificadorDBT());
                barra.setValor(++intContador);
                ++i;
            }
            this.gravarTrailler();
            this.book.fecharArquivoSaida();
            File f = new File(String.valueOf(dirDestino) + arqDestino);
            File temp = new File(String.valueOf(dirOrigem) + arqOrigem);
            char letra = ' ';
            while (f.exists()) {
                if (letra == ' ') {
                    letra = 'A';
                }
                f = new File(String.valueOf(dirDestino) + arqDestino + letra);
                letra = (char)(letra + '\u0001');
            }
            if (letra != ' ') {
                arqDestino = String.valueOf(arqDestino) + letra;
            }
            Util.copiar(new File(String.valueOf(dirOrigem) + arqOrigem), new File(String.valueOf(dirDestino) + arqDestino));
            temp.delete();
            barra.finalizar();
            this.remessaRecebimentos.setValorRemessa(this.valorTotal);
            this.remessaRecebimentos.setNomeArquivo(arqDestino);
            RemessaRecebimentoBD.getRemessaRecebimentoBD().salvar(this.remessaRecebimentos);
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            if (this.exibirMensagemConfirmacao("Gera\u00e7\u00e3o de remessa", "Remessa " + dirDestino + arqDestino + " gerada com sucesso. Deseja transmitir ao Banco agora?")) {
                ControleAplicacao.abrirOffice();
            }
        }
        catch (Throwable t) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new Throwable(t.getMessage());
        }
    }

    public static ControleRemessaRecebimentos getControleRemessaRecebimentos() {
        if (controleRemessaRecebimentos == null) {
            controleRemessaRecebimentos = new ControleRemessaRecebimentos();
        }
        return controleRemessaRecebimentos;
    }

    private IdentificadorDBT getIdentificadorDBT() {
        return this.identificadorDBT;
    }

    public IInterfaceGerenciadorListas getInterfaceGerenciadorListaRemessaRecuperarRecebimento() {
        if (this.interfaceGerenciadorListaRemessaRecuperarRecebimento == null) {
            this.interfaceGerenciadorListaRemessaRecuperarRecebimento = (IInterfaceGerenciadorListas)this.abrirInterface("RemessaRecuperarRecebimentos", null);
            this.interfaceGerenciadorListaRemessaRecuperarRecebimento.addGerenciadorListasListener(this);
            this.interfaceGerenciadorListaRemessaRecuperarRecebimento.setModal(true);
            this.interfaceGerenciadorListaRemessaRecuperarRecebimento.setTitulo("Recupera\u00e7\u00e3o de remessa de recebimentos");
            this.interfaceGerenciadorListaRemessaRecuperarRecebimento.addColuna("N\u00famero da remessa", 0, 1, false, false);
            this.interfaceGerenciadorListaRemessaRecuperarRecebimento.addColuna("Data da remessa", 17, 1, true, true, 1);
            this.interfaceGerenciadorListaRemessaRecuperarRecebimento.addColuna("N\u00ba do Conv\u00eanio", 17, 0, true, true);
            this.interfaceGerenciadorListaRemessaRecuperarRecebimento.addColuna("Valor da Remessa", 17, 2, true, true, 3);
            this.interfaceGerenciadorListaRemessaRecuperarRecebimento.addColuna("Nome do Arquivo", 49, 0, true, true);
            this.interfaceGerenciadorListaRemessaRecuperarRecebimento.setLinhasHorizontais(true);
            this.interfaceGerenciadorListaRemessaRecuperarRecebimento.setLinhasVerticais(true);
            this.interfaceGerenciadorListaRemessaRecuperarRecebimento.setLayout(3);
            this.interfaceGerenciadorListaRemessaRecuperarRecebimento.habilitarMultiplaSelecao(false);
        }
        return this.interfaceGerenciadorListaRemessaRecuperarRecebimento;
    }

    private int getQtdIDAlteradoRemessa() {
        return this.QtdIDAlteradoRemessa;
    }

    private int getQtdIDManutencaoRemessa() {
        return this.QtdIDManutencaoRemessa;
    }

    private int getQtdRecebimentosRemessa() {
        return this.QtdRecebimentosRemessa;
    }

    private int getQtdTotal() {
        return this.QtdTotal;
    }

    private Vector getVetorIDAlteradoRemessa() {
        return this.vetorIDAlteradoRemessa;
    }

    private Vector getVetorIDManutencaoRemessa() {
        return this.vetorIDManutencaoRemessa;
    }

    private Vector getVetorParametrosRemessa() {
        return this.vetorParametrosRemessa;
    }

    public Vector getVetorRecebimentosManutRem() {
        return this.vetorRecebimentosManutRem;
    }

    private Vector getVetorRecebimentosRemessa() {
        return this.vetorRecebimentosRemessa;
    }

    public void gravarDetalheD(IdentificadorDBT identificadorDBT) throws Throwable {
        this.registroRemessa = this.book.criarRegistro("D");
        this.registroRemessa.setValorCampo("IdDbtAnt", identificadorDBT.getNumeroIdentificadorAntigo());
        this.registroRemessa.setValorCampo("NumAgencia", identificadorDBT.getContaCorrente().getcodigoPrefixoAgenciaRel().substring(0, 4));
        this.registroRemessa.setValorCampo("NumConta", Util.strZero(identificadorDBT.getContaCorrente().getnumeroContaCorrente().substring(0, 9), 14));
        this.registroRemessa.setValorCampo("IdDbtAtual", identificadorDBT.getIdentificacaoDBT().getNumeroIdentificador());
        if (identificadorDBT.getNumeroIdentificadorAntigo().equals("AGUARDANDO EXCLUSAO NO BB")) {
            this.registroRemessa.setValorCampo("Ocorrencia", "EXCLUSAO SOLICITADA POR INTERESSE DO CLIENTE");
        } else {
            this.registroRemessa.setValorCampo("Ocorrencia", "");
        }
        if (identificadorDBT.getNumeroIdentificadorAntigo().equals("AGUARDANDO EXCLUSAO NO BB")) {
            this.registroRemessa.setValorCampo("CodMovimento", 1.0);
        } else {
            this.registroRemessa.setValorCampo("CodMovimento", 0.0);
        }
        this.book.addRegistro(this.registroRemessa);
    }

    public void gravarDetalheE(IdentificadorDBT identificadorDBT, String IDRecebimento) throws Throwable {
        this.registroRemessa = this.book.criarRegistro("E");
        this.registroRemessa.setValorCampo("IdDbt", identificadorDBT.getIdentificacaoDBT().getNumeroIdentificador());
        this.registroRemessa.setValorCampo("NumAgencia", identificadorDBT.getContaCorrente().getcodigoPrefixoAgenciaRel().substring(0, 4));
        this.registroRemessa.setValorCampo("NumConta", Util.strZero(identificadorDBT.getContaCorrente().getnumeroContaCorrente().substring(0, 9), 14));
        this.registroRemessa.setValorCampo("DataOpcao", new Date());
        this.registroRemessa.setValorCampo("ValorDBT", 0.0);
        this.registroRemessa.setValorCampo("IdRecebimento", IDRecebimento);
        this.book.addRegistro(this.registroRemessa);
    }

    public void gravarDetalheE(RecebimentoDBT recebimentoDBT) throws Throwable {
        this.registroRemessa = this.book.criarRegistro("E");
        this.registroRemessa.setValorCampo("IdDbt", recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador());
        this.registroRemessa.setValorCampo("NumAgencia", recebimentoDBT.getIdentificadorDBT().getContaCorrente().getcodigoPrefixoAgenciaRel().substring(0, 4));
        this.registroRemessa.setValorCampo("NumConta", Util.strZero(recebimentoDBT.getIdentificadorDBT().getContaCorrente().getnumeroContaCorrente().substring(0, 9), 14));
        this.registroRemessa.setValorCampo("DataOpcao", recebimentoDBT.getDataRecebimento());
        this.registroRemessa.setValorCampo("ValorDBT", recebimentoDBT.getValorRecebimento());
        this.registroRemessa.setValorCampo("IdRecebimento", recebimentoDBT.getIdRegistro());
        this.book.addRegistro(this.registroRemessa);
    }

    public void gravarHeader() throws Throwable {
        this.registroRemessa = this.book.criarRegistro("A");
        this.registroRemessa.setValorCampo("Convenio", this.convenio.getNumeroConvenioDBT());
        this.registroRemessa.setValorCampo("NomeEmpresa", ControleAplicacao.getConvenente().getPessoa().getNomePessoa());
        this.registroRemessa.setValorCampo("DataArq", new Date());
        this.registroRemessa.setValorCampo("SequencialArq", 0.0);
        this.registroRemessa.setValorCampo("Debito", Util.tirarPontos(String.valueOf(ControleAplicacao.getPlugin().getCodigoPlugin()) + ControleAplicacao.getPlugin().getTextoVersao()));
        this.book.addRegistro(this.registroRemessa);
    }

    public void gravarTrailler() throws Throwable {
        this.registroRemessa = this.book.criarRegistro("Z");
        this.registroRemessa.setValorCampo("TotRegistro", this.qteRegArquivo);
        this.registroRemessa.setValorCampo("VlTotRegistro", this.totalValorRemessa);
        this.book.addRegistro(this.registroRemessa);
    }

    public void montarRecebimentoManutencaoID(RecebimentoDBT recebimentoDBT) throws Throwable {
        recebimentoDBT.setNumeroRecebimentoDBT(0);
        recebimentoDBT.getSituacaoRecebimento().setCodigoSituacaoRecebimento("R");
        recebimentoDBT.setCodigoSituacaoRecebimentoRel("R");
        ControleMovimento.getControleMovimento().obterSituacaoRecebimento(recebimentoDBT.getSituacaoRecebimento());
        recebimentoDBT.getCliente().getPessoa().setCodigoPessoa(recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaRel());
        recebimentoDBT.getCliente().getRelacaoPessoaPlugin().getConvenente().getPessoa().setCodigoPessoa(recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaIdentificadorRel());
        ControleMovimento.getControleMovimento().obterClienteDBT(recebimentoDBT.getCliente());
        recebimentoDBT.getConvenio().setNumeroConvenioDBT(recebimentoDBT.getIdentificadorDBT().getConvenioDBT().getNumeroConvenioDBT());
        ControleMovimento.getControleMovimento().obterConvenioDBT(recebimentoDBT.getConvenio());
        recebimentoDBT.setValorRecebimento(Double.valueOf("0") / 100.0);
        recebimentoDBT.setDataRecebimento(new Date());
    }

    public void obterConvenio(ConvenioDBT convenioDBT) throws Throwable {
        ConvenioDBTBD.getConvenioDBTBD().obter(convenioDBT);
    }

    public Vector obterListaIDAlteradoRemessa(ConvenioDBT convenioDBT) throws Throwable {
        return IdentificadorDBTListaBD.getIdentificadorDBTListaBD().obterListaIDAlteradoRemessa(convenioDBT);
    }

    public Vector obterListaIDManutencaoRemessa(ConvenioDBT convenioDBT) throws Throwable {
        return IdentificadorDBTListaBD.getIdentificadorDBTListaBD().obterListaIDManutencaoRemessa(convenioDBT);
    }

    public Vector obterListaRecebimentosManutRem(ConvenioDBT convenioDBT) throws Throwable {
        return RecebimentoDBTListaBD.getRecebimentoDBTListaBD().obterListaRecebimentosManutRem(convenioDBT);
    }

    public Vector obterListaRecebimentosRemessa(ConvenioDBT convenioDBT) throws Throwable {
        return RecebimentoDBTListaBD.getRecebimentoDBTListaBD().obterListaRecebimentosRemessa(convenioDBT);
    }

    public Vector obterListaRemessa(RemessaRecebimentoDBT remessaRecebimentoDBT) throws Throwable {
        return RemessaRecebimentoBD.getRemessaRecebimentoBD().obterLista(remessaRecebimentoDBT);
    }

    private void recuperarRetorno(MultiColumnListbox multicolumn) throws Throwable {
        Object[][] linhas = multicolumn.getSelectedRows();
        int[] linhasSelecionadas = multicolumn.getSelectedIndexes();
        int qtdeSelect = linhas.length;
        String numeroRemessa = "";
        String dataRemessa = "";
        String convenioRemessa = "";
        RemessaRecebimentoDBT remessa = new RemessaRecebimentoDBT();
        if (qtdeSelect == 0) {
            throw new Exception("Nenhum arquivo selecionado");
        }
        if (this.exibirMensagemConfirmacao("Aten\u00e7\u00e3o", "Confirma recupera\u00e7\u00e3o da(s) remessa(s) selecionadas?")) {
            ConexaoBancoDados.getConexao().setAutoCommit(false);
            int i = 0;
            while (i < qtdeSelect) {
                numeroRemessa = (String)linhas[i][0];
                dataRemessa = (String)linhas[i][1];
                convenioRemessa = (String)linhas[i][2];
                remessa.setNumeroConvenioFK(convenioRemessa);
                remessa.setNumeroRemessa(Integer.parseInt(numeroRemessa));
                remessa.setCodigoPessoaFK(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
                remessa.setDataRemessa(Util.strdataToDate(dataRemessa));
                RemessaRecebimentoBD.getRemessaRecebimentoBD().obter(remessa);
                Identificacao identificacao = new Identificacao();
                identificacao.setCodigoPessoaIdentificadorRel("0000002");
                identificacao.setCodigoPessoaRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
                IdentificacaoBD.getIdentificacaoBD().obter(identificacao);
                File arquivoRemessa = new File(String.valueOf(ControleAplicacao.getDiretorioRemessa()) + remessa.getNomeArquivo());
                if (!arquivoRemessa.exists()) {
                    this.exibirMensagem("O arquivo de remessa n\u00e3o se encontra no diret\u00f3rio.\nO arquivo de remessa j\u00e1 pode ter sido enviado ao banco.\nRemessa n\u00e3o pode ser recuperada.");
                    return;
                }
                if (!RecebimentoDBTBD.getRecebimentoDBTBD().verificarRecuperacaoRemessa(remessa)) {
                    throw new Exception("Existem recebimentos com situa\u00e7\u00e3o diferente de 'Gerado'. Remessa n\u00e3o pode ser recuperada.");
                }
                RecebimentoDBTBD.getRecebimentoDBTBD().alterarEstadoTodaRemessa("G", remessa.getNumeroRemessa());
                IdentificadorDBTBD.getIdentificadorDBTBD().cancelarRemessaIDAlterado(remessa);
                RemessaRecebimentoBD.getRemessaRecebimentoBD().remover(remessa);
                multicolumn.removeRow(linhasSelecionadas[i]);
                multicolumn.validate();
                arquivoRemessa.delete();
                this.exibirMensagem("Remessa recuperada com sucesso.");
                ++i;
            }
        }
    }

    private void setIdentificadorDBT(IdentificadorDBT newIdentificadorDBT) {
        this.identificadorDBT = newIdentificadorDBT;
    }

    private void setQtdIDAlteradoRemessa(int newQtdIDAlteradoRemessa) {
        this.QtdIDAlteradoRemessa = newQtdIDAlteradoRemessa;
    }

    private void setQtdIDManutencaoRemessa(int newQtdIDManutencaoRemessa) {
        this.QtdIDManutencaoRemessa = newQtdIDManutencaoRemessa;
    }

    private void setQtdRecebimentosRemessa(int newQtdRecebimentosRemessa) {
        this.QtdRecebimentosRemessa = newQtdRecebimentosRemessa;
    }

    private void setQtdTotal(int newQtdTotal) {
        this.QtdTotal = newQtdTotal;
    }

    private void setVetorIDAlteradoRemessa(Vector newVetorIDAlteradoRemessa) {
        this.vetorIDAlteradoRemessa = newVetorIDAlteradoRemessa;
    }

    private void setVetorIDManutencaoRemessa(Vector newVetorIDManutencaoRemessa) {
        this.vetorIDManutencaoRemessa = newVetorIDManutencaoRemessa;
    }

    private void setVetorParametrosRemessa(Vector newVetorParametrosRemessa) {
        this.vetorParametrosRemessa = newVetorParametrosRemessa;
    }

    public void setVetorRecebimentosManutRem(Vector newVetorRecebimentosManutRem) {
        this.vetorRecebimentosManutRem = newVetorRecebimentosManutRem;
    }

    private void setVetorRecebimentosRemessa(Vector newVetorRecebimentosRemessa) {
        this.vetorRecebimentosRemessa = newVetorRecebimentosRemessa;
    }
}

