/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.interfaces.recebimentosdeterceiros;

import br.com.bb.data.Data;
import br.com.bb.plugins.beans.BBPluginButton;
import br.com.bb.plugins.beans.BBPluginButtonAjuda;
import br.com.bb.plugins.beans.BBPluginChoiceAuto;
import br.com.bb.plugins.beans.BBPluginLabel;
import br.com.bb.plugins.beans.BBPluginMaskedTextField;
import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.IBarraProgresso;
import br.com.bb.plugins.controle.recebimentosdeterceiros.ControleConvenente;
import br.com.bb.plugins.controle.recebimentosdeterceiros.ControleMovimento;
import br.com.bb.plugins.controle.recebimentosdeterceiros.ControleRemessaRecebimentos;
import br.com.bb.plugins.interfaces.infraestrutura.PanelBB;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ConvenioDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.RecebimentoDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.RemessaRecebimentoDBT;
import br.com.bb.plugins.utilitarios.Util;
import com.ibm.webrunner.util.SelectionSorter;
import com.ibm.webrunner.widget.BorderPanel;
import com.ibm.webrunner.widget.InputDirection;
import com.ibm.webrunner.widget.ListboxColumn;
import com.ibm.webrunner.widget.MultiColumnListbox;
import com.ibm.webrunner.widget.event.ListboxEvent;
import com.ibm.webrunner.widget.event.ListboxListener;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.GregorianCalendar;
import java.util.Vector;

public class MovimentoCadastroRemessa
extends PanelBB {
    private BBPluginChoiceAuto ivjBBPluginChoiceAutoConvenio = null;
    private BBPluginLabel ivjBBPluginLabelConvenio = null;
    private BBPluginLabel ivjBBPluginLabelRemessa = null;
    private BorderPanel ivjBorderPanelData = null;
    private BorderPanel ivjBorderPanelMovimento = null;
    private BorderPanel ivjBorderPanelValor = null;
    private BBPluginButtonAjuda ivjButtonAjuda = null;
    private BBPluginButton ivjButtonRetirarCliente = null;
    private BBPluginButton ivjButtonSair = null;
    private BBPluginButton ivjButtonSalvar = null;
    private BBPluginLabel ivjLabelInformacao = null;
    private BBPluginLabel ivjlabelQuantidade = null;
    private BBPluginLabel ivjlabelValorTotal = null;
    private MultiColumnListbox ivjMultiColumnListboxMovimento = null;
    private Panel ivjPanelBotoes = null;
    private GridLayout ivjPanelBotoesGridLayout = null;
    private BBPluginLabel ivjtxtQuantidade = null;
    private BBPluginLabel ivjtxtValorTotal = null;
    private Checkbox ivjCheckboxAdicionarData = null;
    private Checkbox ivjCheckboxAdicionarValor = null;
    private Checkbox ivjCheckboxDia = null;
    private Checkbox ivjCheckboxFixarData = null;
    private CheckboxGroup ivjCheckboxGroupData = null;
    private CheckboxGroup ivjCheckboxGroupDiaMes = null;
    private CheckboxGroup ivjCheckboxGroupRealPercentual = null;
    private CheckboxGroup ivjCheckboxGroupValor = null;
    private Checkbox ivjCheckboxMes = null;
    private Checkbox ivjCheckboxPercentual = null;
    private Checkbox ivjCheckboxReal = null;
    private BBPluginMaskedTextField ivjBBPluginMaskedTextFieldData = null;
    private Checkbox ivjCheckboxAlteraData = null;
    private Checkbox ivjCheckboxAlteraValor = null;
    private BBPluginButton ivjButtonRecalcular = null;
    private Vector vetorRecebimentos = new Vector();
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private BBPluginChoiceAuto ivjBBPluginChoiceAutoRemessa = null;
    private BBPluginMaskedTextField ivjBBPluginMaskedTextFieldDiaMes = null;
    private Checkbox ivjCheckboxFixarValor = null;
    private BBPluginMaskedTextField ivjTextFieldValorFixo = null;
    private BBPluginMaskedTextField ivjTextFieldValorVariavel = null;

    public MovimentoCadastroRemessa() {
        this.initialize();
    }

    public MovimentoCadastroRemessa(LayoutManager layout) {
        super(layout);
    }

    public void bBPluginChoiceAutoConvenio_ItemStateChanged(ItemEvent itemEvent) {
        try {
            this.limparTodosCampos();
            this.popularChoiceRemessa();
        }
        catch (Throwable t) {
            Util.exibirMensagemErro(t);
        }
    }

    public void bBPluginChoiceRemessa_ItemStateChanged(ItemEvent itemEvent) {
        try {
            this.limparData();
            this.limparValor();
            this.getMultiColumnListboxMovimento().removeAllRows();
            this.gettxtQuantidade().setText("");
            this.gettxtValorTotal().setText("0,00");
            if (!this.getBBPluginChoiceAutoRemessa().getSelectedItem().equals("") && this.existemRecebimentos()) {
                this.popularGridMovimento();
            }
        }
        catch (Throwable t) {
            this.setCursor(new Cursor(0));
            Util.exibirMensagemErro(t);
        }
    }

    public void buttonRecalcular_ActionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.getCheckboxAlteraData().getState() && !this.getCheckboxAlteraValor().getState()) {
                this.getRoteador().exibirMensagem("Selecione o Tipo de Altera\u00e7\u00e3o que deseja efetuar.");
                return;
            }
            if (this.criticarCampos()) {
                this.recalcularRecebimentos();
            }
        }
        catch (Throwable t) {
            this.getRoteador().exibirMensagemErro(t);
        }
    }

    public void buttonRetirarCliente_ActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.getRoteador().exibirMensagemConfirmacao("Retirar Recebimento", "Confirma retirada do recebimento selecionado?")) {
                this.getButtonRetirarCliente().setEnabled(false);
                this.gettxtQuantidade().setText(String.valueOf(Integer.parseInt(this.gettxtQuantidade().getText()) - 1));
                this.gettxtValorTotal().setText(Util.formatarValor(Double.valueOf(Util.desformatarValor(this.gettxtValorTotal().getText())) / 100.0 - Double.valueOf(Util.desformatarValor((String)this.getMultiColumnListboxMovimento().getSelectedRow()[10])) / 100.0, 2));
                this.getMultiColumnListboxMovimento().removeRow(this.getMultiColumnListboxMovimento().getSelectedIndex());
            } else {
                this.getButtonRetirarCliente().setEnabled(false);
            }
        }
        catch (Throwable t) {
            this.getRoteador().exibirMensagemErro(t);
        }
    }

    public void buttonSair_ActionPerformed(ActionEvent actionEvent) {
        this.fechar();
    }

    public void buttonSalvar_ActionPerformed(ActionEvent actionEvent) {
        try {
            this.getButtonSalvar().setEnabled(false);
            this.getButtonRecalcular().setEnabled(false);
            this.getButtonAjuda().setEnabled(false);
            this.getButtonSair().setEnabled(false);
            this.gerarMovimento();
            this.getRoteador().exibirMensagem("Recebimentos inclu\u00eddos com sucesso!");
            this.getButtonSalvar().setEnabled(true);
            this.getButtonRecalcular().setEnabled(true);
            this.getButtonAjuda().setEnabled(true);
            this.getButtonSair().setEnabled(true);
            this.getBBPluginChoiceAutoConvenio().removeAll();
            this.limparTodosCampos();
            this.popular();
            this.getButtonSalvar().setEnabled(true);
            this.getButtonAjuda().setEnabled(true);
            this.getButtonRecalcular().setEnabled(true);
            this.getButtonSair().setEnabled(true);
            return;
        }
        catch (Throwable t) {
            Util.exibirMensagemErro(t);
            this.getButtonSalvar().setEnabled(true);
            this.getButtonRecalcular().setEnabled(true);
            this.getButtonAjuda().setEnabled(true);
            this.getButtonSair().setEnabled(true);
            return;
        }
    }

    public void checkboxAdicionarData_ItemStateChanged(ItemEvent itemEvent) {
        this.getBBPluginMaskedTextFieldData().setText("");
        this.getBBPluginMaskedTextFieldData().setEnabled(false);
        this.getBBPluginMaskedTextFieldDiaMes().setEnabled(true);
        this.getCheckboxDia().setEnabled(true);
        this.getCheckboxMes().setEnabled(true);
    }

    public void checkboxAdicionarValor_ItemStateChanged(ItemEvent itemEvent) {
        this.getTextFieldValorFixo().setText("");
        this.getTextFieldValorFixo().setEnabled(false);
        this.getTextFieldValorVariavel().setEnabled(true);
        this.getCheckboxReal().setEnabled(true);
        this.getCheckboxPercentual().setEnabled(true);
    }

    public void checkboxAlteraData_ItemStateChanged(ItemEvent itemEvent) {
        if (this.getCheckboxAlteraData().getState()) {
            this.limparData();
            this.habilitarCamposData(true);
            this.getCheckboxAdicionarData().setState(true);
            this.getCheckboxDia().setState(true);
            this.getBBPluginMaskedTextFieldData().setText("");
            this.getBBPluginMaskedTextFieldData().setEnabled(false);
        } else {
            this.limparData();
            this.habilitarCamposData(false);
        }
    }

    public void checkboxAlteraValor_ItemStateChanged(ItemEvent itemEvent) {
        if (this.getCheckboxAlteraValor().getState()) {
            this.limparValor();
            this.habilitarCamposValor(true);
            this.getCheckboxAdicionarValor().setState(true);
            this.getCheckboxReal().setState(true);
            this.getTextFieldValorVariavel().setText("");
            this.getTextFieldValorFixo().setEnabled(false);
        } else {
            this.limparValor();
            this.habilitarCamposValor(false);
        }
    }

    public void checkboxFixar_ItemStateChanged(ItemEvent itemEvent) {
        this.getTextFieldValorVariavel().setText("");
        this.getTextFieldValorVariavel().setEnabled(false);
        this.getCheckboxReal().setState(false);
        this.getCheckboxReal().setEnabled(false);
        this.getCheckboxPercentual().setState(false);
        this.getCheckboxPercentual().setEnabled(false);
        this.getTextFieldValorFixo().setEnabled(true);
    }

    public void checkboxFixarData_ItemStateChanged(ItemEvent itemEvent) {
        this.getBBPluginMaskedTextFieldDiaMes().setText("");
        this.getBBPluginMaskedTextFieldDiaMes().setEnabled(false);
        this.getCheckboxDia().setState(false);
        this.getCheckboxDia().setEnabled(false);
        this.getCheckboxMes().setState(false);
        this.getCheckboxMes().setEnabled(false);
        this.getBBPluginMaskedTextFieldData().setEnabled(true);
    }

    private void connEtoC1(ItemEvent arg1) {
        try {
            this.bBPluginChoiceAutoConvenio_ItemStateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC10(ItemEvent arg1) {
        try {
            this.checkboxAdicionarData_ItemStateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC11(ItemEvent arg1) {
        try {
            this.checkboxFixarData_ItemStateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC12(ItemEvent arg1) {
        try {
            this.checkboxAdicionarValor_ItemStateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC13(ItemEvent arg1) {
        try {
            this.checkboxFixar_ItemStateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ItemEvent arg1) {
        try {
            this.bBPluginChoiceRemessa_ItemStateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ListboxEvent arg1) {
        try {
            this.multiColumnListboxMovimento_RowSelected(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ActionEvent arg1) {
        try {
            this.buttonRetirarCliente_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(ActionEvent arg1) {
        try {
            this.buttonSair_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(ActionEvent arg1) {
        try {
            this.buttonSalvar_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC7(ActionEvent arg1) {
        try {
            this.buttonRecalcular_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC8(ItemEvent arg1) {
        try {
            this.checkboxAlteraData_ItemStateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC9(ItemEvent arg1) {
        try {
            this.checkboxAlteraValor_ItemStateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP1SetTarget() {
        try {
            this.getCheckboxAdicionarData().setCheckboxGroup(this.getCheckboxGroupData());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP2SetTarget() {
        try {
            this.getCheckboxFixarData().setCheckboxGroup(this.getCheckboxGroupData());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP3SetTarget() {
        try {
            this.getCheckboxDia().setCheckboxGroup(this.getCheckboxGroupDiaMes());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP4SetTarget() {
        try {
            this.getCheckboxMes().setCheckboxGroup(this.getCheckboxGroupDiaMes());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP5SetTarget() {
        try {
            this.getCheckboxAdicionarValor().setCheckboxGroup(this.getCheckboxGroupValor());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP6SetTarget() {
        try {
            this.getCheckboxFixarValor().setCheckboxGroup(this.getCheckboxGroupValor());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP7SetTarget() {
        try {
            this.getCheckboxReal().setCheckboxGroup(this.getCheckboxGroupRealPercentual());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP8SetTarget() {
        try {
            this.getCheckboxPercentual().setCheckboxGroup(this.getCheckboxGroupRealPercentual());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public boolean criticarCampos() throws Throwable {
        if (this.getBBPluginChoiceAutoConvenio().getSelectedIndex() < 0) {
            this.getRoteador().exibirMensagem("O Conv\u00eanio deve ser Selecionado!");
            return false;
        }
        if (this.getBBPluginChoiceAutoRemessa().getSelectedIndex() < 1) {
            this.getRoteador().exibirMensagem("A Remessa deve ser Selecionada!");
            return false;
        }
        if (this.getCheckboxAlteraData().getState() && (this.getCheckboxAdicionarData().getState() ? !this.criticarDataVariavel() : this.getCheckboxFixarData().getState() && !this.criticarDataFixa())) {
            return false;
        }
        if (this.getCheckboxAlteraValor().getState() && (this.getCheckboxAdicionarValor().getState() ? !this.criticarValorVariavel() : this.getCheckboxFixarValor().getState() && !this.criticarValorFixo())) {
            return false;
        }
        if (this.getMultiColumnListboxMovimento().getRowCount() < 1) {
            this.getRoteador().exibirMensagem("N\u00e3o existem Recebimentos para inclus\u00e3o. Selecione uma Remessa para inclus\u00e3o dos Recebimentos");
            return false;
        }
        return true;
    }

    public boolean criticarDataFixa() throws Throwable {
        String data = this.getBBPluginMaskedTextFieldData().getText();
        String dia = data.substring(0, 2).trim();
        String mes = data.substring(2, 4).trim();
        String ano = data.substring(4).trim();
        if (dia.equals("") || mes.equals("") || ano.equals("")) {
            this.getRoteador().exibirMensagem("A Data Deve Ser Informada!");
            return false;
        }
        Data dataRec = new Data();
        dataRec.set(Integer.parseInt(dia), Integer.parseInt(mes), Integer.parseInt(ano));
        Data dataMov = new Data();
        dataMov.set(Integer.parseInt(dia), Integer.parseInt(mes), Integer.parseInt(ano));
        Data dt = new Data();
        if (dataMov.compararCom(dt) < 0) {
            this.getBBPluginMaskedTextFieldData().requestFocus();
            this.getRoteador().exibirMensagem("A Data deve ser maior ou igual a data atual.");
            return false;
        }
        if (!dataMov.isDiaUtil()) {
            this.getBBPluginMaskedTextFieldData().setText(String.valueOf(dataMov.getProximaDataUtil().getFormatada().substring(0, 2)) + dataMov.getProximaDataUtil().getFormatada().substring(3, 5) + dataMov.getProximaDataUtil().getFormatada().substring(6));
            this.getRoteador().exibirMensagem("Recebimento para dia n\u00e3o \u00fatil. A data foi alterada para o pr\u00f3ximo dia \u00fatil: " + dataMov.getProximaDataUtil().getFormatada());
        }
        return true;
    }

    public boolean criticarDataVariavel() throws Throwable {
        if (this.getBBPluginMaskedTextFieldDiaMes().getText().trim().equals("") || Integer.valueOf(this.getBBPluginMaskedTextFieldDiaMes().getText().trim()) < 1) {
            this.getTextFieldValorFixo().requestFocus();
            this.getRoteador().exibirMensagem("A quantidade de dias/meses deve ser informada!");
            return false;
        }
        if (this.getCheckboxDia().getState()) {
            if (Integer.valueOf(this.getBBPluginMaskedTextFieldDiaMes().getText().trim()) > 180) {
                this.getTextFieldValorFixo().requestFocus();
                this.getRoteador().exibirMensagem("A quantidade m\u00e1xima de dias que pode ser adicionada \u00e9 180");
                return false;
            }
        } else if (this.getCheckboxMes().getState() && Integer.valueOf(this.getBBPluginMaskedTextFieldDiaMes().getText().trim()) > 6) {
            this.getTextFieldValorFixo().requestFocus();
            this.getRoteador().exibirMensagem("A quantidade m\u00e1xima de meses que pode ser adicionada \u00e9 6");
            return false;
        }
        return true;
    }

    public boolean criticarValorFixo() throws Throwable {
        if (this.getTextFieldValorFixo().getText().trim().equals("") || Double.valueOf(this.getTextFieldValorFixo().getText()) < 0.0) {
            this.getRoteador().exibirMensagem("O Valor Fixo Deve Ser Informado!");
            this.getTextFieldValorFixo().requestFocus();
            return false;
        }
        if (Double.valueOf(this.getTextFieldValorFixo().getText()) == 0.0) {
            return this.getRoteador().exibirMensagemConfirmacao("Aten\u00e7\u00e3o!", "Os recebimentos ser\u00e3o gravados com valor zerado. Confirma?");
        }
        return true;
    }

    public boolean criticarValorVariavel() throws Throwable {
        if (this.getTextFieldValorVariavel().getText().trim().equals("") || Double.valueOf(this.getTextFieldValorVariavel().getText()) < 0.0) {
            this.getRoteador().exibirMensagem("O Valor/Percentual Deve Ser Informado!");
            this.getTextFieldValorVariavel().requestFocus();
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean existemRecebimentos() throws Throwable {
        if (this.getBBPluginChoiceAutoConvenio().getSelectedItem() != null && this.getBBPluginChoiceAutoConvenio().getSelectedItem().trim().compareTo("") != 0) {
            RecebimentoDBT recebimentoDBT = new RecebimentoDBT();
            recebimentoDBT.getIdentificadorDBT().getConvenioDBT().setNumeroConvenioDBT(this.getBBPluginChoiceAutoConvenio().getSelectedCodigo());
            recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().setCodigoPessoaIdentificadorRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().setCodigoIdentificadorRel("DBT" + this.getBBPluginChoiceAutoConvenio().getSelectedCodigo());
            if (this.getBBPluginChoiceAutoRemessa().getSelectedItem() != null && this.getBBPluginChoiceAutoRemessa().getSelectedItem().trim().compareTo("") != 0) {
                recebimentoDBT.getRemessaRecebimentoDBT().setNumeroConvenioFK(this.getBBPluginChoiceAutoConvenio().getSelectedCodigo());
                recebimentoDBT.getRemessaRecebimentoDBT().setNumeroRemessa(Integer.parseInt(this.getBBPluginChoiceAutoRemessa().getSelectedCodigo()));
                this.setCursor(new Cursor(3));
                this.vetorRecebimentos = ControleMovimento.getControleMovimento().obterListaRecebimentosRemessaAnterior(recebimentoDBT);
                this.setCursor(new Cursor(0));
                if (this.vetorRecebimentos.size() > 0) return true;
                this.getRoteador().exibirMensagem("N\u00e3o existem recebimentos para a remessa selecionada");
                return false;
            }
            this.getRoteador().exibirMensagem("A remessa deve ser selecionada");
            return false;
        }
        this.getRoteador().exibirMensagem("O conv\u00eanio deve ser selecionado");
        return false;
    }

    public void gerarMovimento() throws Throwable {
        RecebimentoDBT recebimentoDBT = new RecebimentoDBT();
        IBarraProgresso barraProgresso = this.getRoteador().getFramePlugin().obterBarraProgresso();
        barraProgresso.inicializar("Incluindo Recebimentos. Aguarde...", this.getMultiColumnListboxMovimento().getRowCount(), false);
        barraProgresso.setValorMaximo(this.getMultiColumnListboxMovimento().getRowCount());
        int i = 0;
        while (i < this.getMultiColumnListboxMovimento().getRowCount()) {
            Object[] o = this.getMultiColumnListboxMovimento().getRow(i);
            recebimentoDBT.setNumeroRecebimentoDBT(0);
            recebimentoDBT.setIdRegistro("");
            recebimentoDBT.getCliente().getPessoa().setCodigoPessoa((String)o[0]);
            recebimentoDBT.getConvenio().setNumeroConvenioDBT(this.getBBPluginChoiceAutoConvenio().getSelectedCodigo());
            recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().setCodigoPessoaIdentificadorRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().setCodigoPessoaRel((String)o[0]);
            recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().setCodigoIdentificador("DBT" + this.getBBPluginChoiceAutoConvenio().getSelectedCodigo());
            recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().setNumeroIdentificador((String)o[3]);
            recebimentoDBT.getIdentificadorDBT().getConvenioDBT().setNumeroConvenioDBT(this.getBBPluginChoiceAutoConvenio().getSelectedCodigo());
            recebimentoDBT.setCodigoSituacaoRecebimentoRel("G");
            recebimentoDBT.getSituacaoRecebimento().setCodigoSituacaoRecebimento("G");
            recebimentoDBT.setValorRecebimento(Double.valueOf(Util.desformatarValor((String)o[10])) / 100.0);
            recebimentoDBT.setDataRecebimento(Util.strdataToDate((String)o[9]));
            ControleMovimento.getControleMovimento().setIndicadorOperacao('I');
            ControleMovimento.getControleMovimento().incluirRecebimento(recebimentoDBT);
            barraProgresso.add(1);
            ++i;
        }
        barraProgresso.finalizar();
    }

    private BBPluginChoiceAuto getBBPluginChoiceAutoConvenio() {
        if (this.ivjBBPluginChoiceAutoConvenio == null) {
            try {
                this.ivjBBPluginChoiceAutoConvenio = new BBPluginChoiceAuto();
                this.ivjBBPluginChoiceAutoConvenio.setName("BBPluginChoiceAutoConvenio");
                this.ivjBBPluginChoiceAutoConvenio.setToolTipText("Informe o Conv\u00eanio para gera\u00e7\u00e3o dos recebimentos");
                this.ivjBBPluginChoiceAutoConvenio.setBackground(Color.white);
                this.ivjBBPluginChoiceAutoConvenio.setBounds(86, 13, 557, 23);
                this.ivjBBPluginChoiceAutoConvenio.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBBPluginChoiceAutoConvenio;
    }

    private BBPluginChoiceAuto getBBPluginChoiceAutoRemessa() {
        if (this.ivjBBPluginChoiceAutoRemessa == null) {
            try {
                this.ivjBBPluginChoiceAutoRemessa = new BBPluginChoiceAuto();
                this.ivjBBPluginChoiceAutoRemessa.setName("BBPluginChoiceAutoRemessa");
                this.ivjBBPluginChoiceAutoRemessa.setToolTipText("Selecione a Remessa para gera\u00e7\u00e3o dos recebimentos");
                this.ivjBBPluginChoiceAutoRemessa.setBackground(Color.white);
                this.ivjBBPluginChoiceAutoRemessa.setBounds(86, 40, 557, 20);
                this.ivjBBPluginChoiceAutoRemessa.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBBPluginChoiceAutoRemessa;
    }

    private BBPluginLabel getBBPluginLabelConvenio() {
        if (this.ivjBBPluginLabelConvenio == null) {
            try {
                this.ivjBBPluginLabelConvenio = new BBPluginLabel();
                this.ivjBBPluginLabelConvenio.setName("BBPluginLabelConvenio");
                this.ivjBBPluginLabelConvenio.setText("Conv\u00eanio:");
                this.ivjBBPluginLabelConvenio.setBounds(22, 14, 55, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBBPluginLabelConvenio;
    }

    private BBPluginLabel getBBPluginLabelRemessa() {
        if (this.ivjBBPluginLabelRemessa == null) {
            try {
                this.ivjBBPluginLabelRemessa = new BBPluginLabel();
                this.ivjBBPluginLabelRemessa.setName("BBPluginLabelRemessa");
                this.ivjBBPluginLabelRemessa.setText("Remessa:");
                this.ivjBBPluginLabelRemessa.setBounds(22, 40, 55, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBBPluginLabelRemessa;
    }

    private BBPluginMaskedTextField getBBPluginMaskedTextFieldData() {
        if (this.ivjBBPluginMaskedTextFieldData == null) {
            try {
                this.ivjBBPluginMaskedTextFieldData = new BBPluginMaskedTextField();
                this.ivjBBPluginMaskedTextFieldData.setName("BBPluginMaskedTextFieldData");
                this.ivjBBPluginMaskedTextFieldData.setToolTipText("Informe uma data fixa para todos os recebimentos");
                this.ivjBBPluginMaskedTextFieldData.setReturnLiterals(false);
                this.ivjBBPluginMaskedTextFieldData.setTamanhoMaximo(10);
                this.ivjBBPluginMaskedTextFieldData.setMask("##/##/####");
                this.ivjBBPluginMaskedTextFieldData.setReturnBlanks(true);
                this.ivjBBPluginMaskedTextFieldData.setTransferirFocoPorEnter(true);
                this.ivjBBPluginMaskedTextFieldData.setBounds(96, 58, 112, 21);
                this.ivjBBPluginMaskedTextFieldData.setBlankChar(' ');
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBBPluginMaskedTextFieldData;
    }

    private BBPluginMaskedTextField getBBPluginMaskedTextFieldDiaMes() {
        if (this.ivjBBPluginMaskedTextFieldDiaMes == null) {
            try {
                this.ivjBBPluginMaskedTextFieldDiaMes = new BBPluginMaskedTextField();
                this.ivjBBPluginMaskedTextFieldDiaMes.setName("BBPluginMaskedTextFieldDiaMes");
                this.ivjBBPluginMaskedTextFieldDiaMes.setToolTipText("Informe o n\u00famero de dias/meses para serem adicionados as datas ");
                this.ivjBBPluginMaskedTextFieldDiaMes.setForeground(Color.black);
                this.ivjBBPluginMaskedTextFieldDiaMes.setFormaPreenchimento(1);
                this.ivjBBPluginMaskedTextFieldDiaMes.setTamanhoMaximo(2);
                this.ivjBBPluginMaskedTextFieldDiaMes.setCaracterPreenchimento("0");
                this.ivjBBPluginMaskedTextFieldDiaMes.setMask("##");
                this.ivjBBPluginMaskedTextFieldDiaMes.setReturnBlanks(true);
                this.ivjBBPluginMaskedTextFieldDiaMes.setReturnLiterals(false);
                this.ivjBBPluginMaskedTextFieldDiaMes.setTransferirFocoPorEnter(true);
                this.ivjBBPluginMaskedTextFieldDiaMes.setBounds(96, 24, 112, 20);
                this.ivjBBPluginMaskedTextFieldDiaMes.setBlankChar(' ');
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBBPluginMaskedTextFieldDiaMes;
    }

    private BorderPanel getBorderPanelData() {
        if (this.ivjBorderPanelData == null) {
            try {
                this.ivjBorderPanelData = new BorderPanel();
                this.ivjBorderPanelData.setName("BorderPanelData");
                this.ivjBorderPanelData.setLayout(null);
                this.ivjBorderPanelData.setText("");
                this.ivjBorderPanelData.setForeground(new Color(0, 64, 127));
                this.ivjBorderPanelData.setTextFont(new Font("sansserif", 1, 14));
                this.ivjBorderPanelData.setColor(new Color(0, 64, 127));
                this.ivjBorderPanelData.setBounds(9, 75, 319, 92);
                this.getBorderPanelData().add((Component)this.getCheckboxAlteraData(), this.getCheckboxAlteraData().getName());
                this.getBorderPanelData().add((Component)this.getCheckboxAdicionarData(), this.getCheckboxAdicionarData().getName());
                this.getBorderPanelData().add((Component)this.getBBPluginMaskedTextFieldDiaMes(), this.getBBPluginMaskedTextFieldDiaMes().getName());
                this.getBorderPanelData().add((Component)this.getCheckboxDia(), this.getCheckboxDia().getName());
                this.getBorderPanelData().add((Component)this.getCheckboxMes(), this.getCheckboxMes().getName());
                this.getBorderPanelData().add((Component)this.getCheckboxFixarData(), this.getCheckboxFixarData().getName());
                this.getBorderPanelData().add((Component)this.getBBPluginMaskedTextFieldData(), this.getBBPluginMaskedTextFieldData().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBorderPanelData;
    }

    private BorderPanel getBorderPanelMovimento() {
        if (this.ivjBorderPanelMovimento == null) {
            try {
                this.ivjBorderPanelMovimento = new BorderPanel();
                this.ivjBorderPanelMovimento.setName("BorderPanelMovimento");
                this.ivjBorderPanelMovimento.setLayout(null);
                this.ivjBorderPanelMovimento.setText("Recebimentos");
                this.ivjBorderPanelMovimento.setTextFont(new Font("sansserif", 1, 14));
                this.ivjBorderPanelMovimento.setForeground(new Color(0, 64, 127));
                this.ivjBorderPanelMovimento.setColor(new Color(0, 64, 127));
                this.ivjBorderPanelMovimento.setBounds(9, 170, 644, 239);
                this.getBorderPanelMovimento().add((Component)this.getMultiColumnListboxMovimento(), this.getMultiColumnListboxMovimento().getName());
                this.getBorderPanelMovimento().add((Component)this.getlabelQuantidade(), this.getlabelQuantidade().getName());
                this.getBorderPanelMovimento().add((Component)this.gettxtQuantidade(), this.gettxtQuantidade().getName());
                this.getBorderPanelMovimento().add((Component)this.getlabelValorTotal(), this.getlabelValorTotal().getName());
                this.getBorderPanelMovimento().add((Component)this.gettxtValorTotal(), this.gettxtValorTotal().getName());
                this.getBorderPanelMovimento().add((Component)this.getLabelInformacao(), this.getLabelInformacao().getName());
                this.getBorderPanelMovimento().add((Component)this.getButtonRetirarCliente(), this.getButtonRetirarCliente().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBorderPanelMovimento;
    }

    private BorderPanel getBorderPanelValor() {
        if (this.ivjBorderPanelValor == null) {
            try {
                this.ivjBorderPanelValor = new BorderPanel();
                this.ivjBorderPanelValor.setName("BorderPanelValor");
                this.ivjBorderPanelValor.setLayout(null);
                this.ivjBorderPanelValor.setText("");
                this.ivjBorderPanelValor.setTextFont(new Font("sansserif", 1, 14));
                this.ivjBorderPanelValor.setForeground(new Color(0, 64, 127));
                this.ivjBorderPanelValor.setColor(new Color(0, 64, 127));
                this.ivjBorderPanelValor.setBounds(334, 75, 319, 92);
                this.getBorderPanelValor().add((Component)this.getCheckboxAlteraValor(), this.getCheckboxAlteraValor().getName());
                this.getBorderPanelValor().add((Component)this.getCheckboxAdicionarValor(), this.getCheckboxAdicionarValor().getName());
                this.getBorderPanelValor().add((Component)this.getTextFieldValorVariavel(), this.getTextFieldValorVariavel().getName());
                this.getBorderPanelValor().add((Component)this.getCheckboxReal(), this.getCheckboxReal().getName());
                this.getBorderPanelValor().add((Component)this.getCheckboxPercentual(), this.getCheckboxPercentual().getName());
                this.getBorderPanelValor().add((Component)this.getCheckboxFixarValor(), this.getCheckboxFixarValor().getName());
                this.getBorderPanelValor().add((Component)this.getTextFieldValorFixo(), this.getTextFieldValorFixo().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBorderPanelValor;
    }

    private BBPluginButtonAjuda getButtonAjuda() {
        if (this.ivjButtonAjuda == null) {
            try {
                this.ivjButtonAjuda = new BBPluginButtonAjuda();
                this.ivjButtonAjuda.setName("ButtonAjuda");
                this.ivjButtonAjuda.setArquivoHTML("inclusaorecebimentosremessa.htm");
                this.ivjButtonAjuda.setLabel("Ajuda");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonAjuda;
    }

    private BBPluginButton getButtonRecalcular() {
        if (this.ivjButtonRecalcular == null) {
            try {
                this.ivjButtonRecalcular = new BBPluginButton();
                this.ivjButtonRecalcular.setName("ButtonRecalcular");
                this.ivjButtonRecalcular.setToolTipText("Recalcula os recebimentos com base nas altera\u00e7\u00f5es de data e valor selecionados");
                this.ivjButtonRecalcular.setLabel("Recalcular Recebimentos");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonRecalcular;
    }

    private BBPluginButton getButtonRetirarCliente() {
        if (this.ivjButtonRetirarCliente == null) {
            try {
                this.ivjButtonRetirarCliente = new BBPluginButton();
                this.ivjButtonRetirarCliente.setName("ButtonRetirarCliente");
                this.ivjButtonRetirarCliente.setToolTipText("N\u00e3o gera recebimento para cliente selecionado");
                this.ivjButtonRetirarCliente.setBounds(510, 191, 119, 20);
                this.ivjButtonRetirarCliente.setEnabled(false);
                this.ivjButtonRetirarCliente.setLabel("Retirar");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonRetirarCliente;
    }

    private BBPluginButton getButtonSair() {
        if (this.ivjButtonSair == null) {
            try {
                this.ivjButtonSair = new BBPluginButton();
                this.ivjButtonSair.setName("ButtonSair");
                this.ivjButtonSair.setLabel("Sair");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonSair;
    }

    private BBPluginButton getButtonSalvar() {
        if (this.ivjButtonSalvar == null) {
            try {
                this.ivjButtonSalvar = new BBPluginButton();
                this.ivjButtonSalvar.setName("ButtonSalvar");
                this.ivjButtonSalvar.setToolTipText("Inclui Recebimentos");
                this.ivjButtonSalvar.setLabel("Incluir Recebimentos");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonSalvar;
    }

    private Checkbox getCheckboxAdicionarData() {
        if (this.ivjCheckboxAdicionarData == null) {
            try {
                this.ivjCheckboxAdicionarData = new Checkbox();
                this.ivjCheckboxAdicionarData.setName("CheckboxAdicionarData");
                this.ivjCheckboxAdicionarData.setBounds(17, 24, 78, 23);
                this.ivjCheckboxAdicionarData.setLabel("Adicionar");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCheckboxAdicionarData;
    }

    private Checkbox getCheckboxAdicionarValor() {
        if (this.ivjCheckboxAdicionarValor == null) {
            try {
                this.ivjCheckboxAdicionarValor = new Checkbox();
                this.ivjCheckboxAdicionarValor.setName("CheckboxAdicionarValor");
                this.ivjCheckboxAdicionarValor.setBounds(17, 24, 78, 23);
                this.ivjCheckboxAdicionarValor.setLabel("Adicionar");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCheckboxAdicionarValor;
    }

    private Checkbox getCheckboxAlteraData() {
        if (this.ivjCheckboxAlteraData == null) {
            try {
                this.ivjCheckboxAlteraData = new Checkbox();
                this.ivjCheckboxAlteraData.setName("CheckboxAlteraData");
                this.ivjCheckboxAlteraData.setFont(new Font("dialog", 1, 14));
                this.ivjCheckboxAlteraData.setBounds(17, -6, 115, 23);
                this.ivjCheckboxAlteraData.setLabel("Alterar Datas");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCheckboxAlteraData;
    }

    private Checkbox getCheckboxAlteraValor() {
        if (this.ivjCheckboxAlteraValor == null) {
            try {
                this.ivjCheckboxAlteraValor = new Checkbox();
                this.ivjCheckboxAlteraValor.setName("CheckboxAlteraValor");
                this.ivjCheckboxAlteraValor.setFont(new Font("dialog", 1, 14));
                this.ivjCheckboxAlteraValor.setBounds(17, -6, 129, 23);
                this.ivjCheckboxAlteraValor.setLabel("Alterar Valores");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCheckboxAlteraValor;
    }

    private Checkbox getCheckboxDia() {
        if (this.ivjCheckboxDia == null) {
            try {
                this.ivjCheckboxDia = new Checkbox();
                this.ivjCheckboxDia.setName("CheckboxDia");
                this.ivjCheckboxDia.setFont(new Font("dialog", 0, 10));
                this.ivjCheckboxDia.setBounds(213, 12, 91, 23);
                this.ivjCheckboxDia.setLabel("Dia(s)");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCheckboxDia;
    }

    private Checkbox getCheckboxFixarData() {
        if (this.ivjCheckboxFixarData == null) {
            try {
                this.ivjCheckboxFixarData = new Checkbox();
                this.ivjCheckboxFixarData.setName("CheckboxFixarData");
                this.ivjCheckboxFixarData.setBounds(17, 58, 78, 23);
                this.ivjCheckboxFixarData.setLabel("Fixar em");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCheckboxFixarData;
    }

    private Checkbox getCheckboxFixarValor() {
        if (this.ivjCheckboxFixarValor == null) {
            try {
                this.ivjCheckboxFixarValor = new Checkbox();
                this.ivjCheckboxFixarValor.setName("CheckboxFixarValor");
                this.ivjCheckboxFixarValor.setBounds(17, 58, 78, 23);
                this.ivjCheckboxFixarValor.setLabel("Fixar em");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCheckboxFixarValor;
    }

    private CheckboxGroup getCheckboxGroupData() {
        if (this.ivjCheckboxGroupData == null) {
            try {
                this.ivjCheckboxGroupData = new CheckboxGroup();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCheckboxGroupData;
    }

    private CheckboxGroup getCheckboxGroupDiaMes() {
        if (this.ivjCheckboxGroupDiaMes == null) {
            try {
                this.ivjCheckboxGroupDiaMes = new CheckboxGroup();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCheckboxGroupDiaMes;
    }

    private CheckboxGroup getCheckboxGroupRealPercentual() {
        if (this.ivjCheckboxGroupRealPercentual == null) {
            try {
                this.ivjCheckboxGroupRealPercentual = new CheckboxGroup();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCheckboxGroupRealPercentual;
    }

    private CheckboxGroup getCheckboxGroupValor() {
        if (this.ivjCheckboxGroupValor == null) {
            try {
                this.ivjCheckboxGroupValor = new CheckboxGroup();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCheckboxGroupValor;
    }

    private Checkbox getCheckboxMes() {
        if (this.ivjCheckboxMes == null) {
            try {
                this.ivjCheckboxMes = new Checkbox();
                this.ivjCheckboxMes.setName("CheckboxMes");
                this.ivjCheckboxMes.setFont(new Font("dialog", 0, 10));
                this.ivjCheckboxMes.setBounds(213, 32, 91, 23);
                this.ivjCheckboxMes.setLabel("M\u00eas(Meses)");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCheckboxMes;
    }

    private Checkbox getCheckboxPercentual() {
        if (this.ivjCheckboxPercentual == null) {
            try {
                this.ivjCheckboxPercentual = new Checkbox();
                this.ivjCheckboxPercentual.setName("CheckboxPercentual");
                this.ivjCheckboxPercentual.setFont(new Font("dialog", 0, 10));
                this.ivjCheckboxPercentual.setBounds(237, 36, 46, 19);
                this.ivjCheckboxPercentual.setLabel("%");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCheckboxPercentual;
    }

    private Checkbox getCheckboxReal() {
        if (this.ivjCheckboxReal == null) {
            try {
                this.ivjCheckboxReal = new Checkbox();
                this.ivjCheckboxReal.setName("CheckboxReal");
                this.ivjCheckboxReal.setFont(new Font("dialog", 0, 10));
                this.ivjCheckboxReal.setBounds(237, 14, 46, 23);
                this.ivjCheckboxReal.setLabel("R$");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCheckboxReal;
    }

    private BBPluginLabel getLabelInformacao() {
        if (this.ivjLabelInformacao == null) {
            try {
                this.ivjLabelInformacao = new BBPluginLabel();
                this.ivjLabelInformacao.setName("LabelInformacao");
                this.ivjLabelInformacao.setFont(new Font("monospaced", 2, 12));
                this.ivjLabelInformacao.setText("Para alterar os recebimentos utilize a op\u00e7\u00e3o: Recebimentos/Manuten\u00e7\u00e3o");
                this.ivjLabelInformacao.setBounds(15, 214, 611, 16);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLabelInformacao;
    }

    private BBPluginLabel getlabelQuantidade() {
        if (this.ivjlabelQuantidade == null) {
            try {
                this.ivjlabelQuantidade = new BBPluginLabel();
                this.ivjlabelQuantidade.setName("labelQuantidade");
                this.ivjlabelQuantidade.setText("Quantidade:");
                this.ivjlabelQuantidade.setBounds(15, 191, 75, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlabelQuantidade;
    }

    private BBPluginLabel getlabelValorTotal() {
        if (this.ivjlabelValorTotal == null) {
            try {
                this.ivjlabelValorTotal = new BBPluginLabel();
                this.ivjlabelValorTotal.setName("labelValorTotal");
                this.ivjlabelValorTotal.setText("Valor Total:");
                this.ivjlabelValorTotal.setBounds(260, 191, 63, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlabelValorTotal;
    }

    private MultiColumnListbox getMultiColumnListboxMovimento() {
        if (this.ivjMultiColumnListboxMovimento == null) {
            try {
                this.ivjMultiColumnListboxMovimento = new MultiColumnListbox();
                this.ivjMultiColumnListboxMovimento.setName("MultiColumnListboxMovimento");
                this.ivjMultiColumnListboxMovimento.setCaptionBarForeground(new Color(0, 64, 127));
                this.ivjMultiColumnListboxMovimento.setSelectionForeground(SystemColor.activeCaptionText);
                this.ivjMultiColumnListboxMovimento.setBackground(Color.white);
                this.ivjMultiColumnListboxMovimento.setCaptionBarHeight(20);
                this.ivjMultiColumnListboxMovimento.setForeground(new Color(0, 64, 127));
                this.ivjMultiColumnListboxMovimento.setVerticalSeparatorVisible(true);
                this.ivjMultiColumnListboxMovimento.setHorizontalSeparatorVisible(true);
                this.ivjMultiColumnListboxMovimento.setContinuousDrag(true);
                this.ivjMultiColumnListboxMovimento.setSeparatorColor(Color.lightGray);
                this.ivjMultiColumnListboxMovimento.setBounds(13, 21, 619, 167);
                this.ivjMultiColumnListboxMovimento.setSelectionBackground(new Color(0, 64, 127));
                this.ivjMultiColumnListboxMovimento.addColumn("CodigoPessoa");
                this.ivjMultiColumnListboxMovimento.addColumn("CodigoIdentificador");
                this.ivjMultiColumnListboxMovimento.addColumn("CodigoPessoaIdentificador");
                this.ivjMultiColumnListboxMovimento.addColumn("NumeroIdentificadorDBT");
                this.ivjMultiColumnListboxMovimento.addColumn("Nome");
                this.ivjMultiColumnListboxMovimento.addColumn("Identifica\u00e7\u00e3o P/D\u00e9bito");
                this.ivjMultiColumnListboxMovimento.addColumn("Banco");
                this.ivjMultiColumnListboxMovimento.addColumn("Ag\u00eancia");
                this.ivjMultiColumnListboxMovimento.addColumn("Conta");
                this.ivjMultiColumnListboxMovimento.addColumn("Data");
                this.ivjMultiColumnListboxMovimento.addColumn("Valor");
                ListboxColumn column = this.ivjMultiColumnListboxMovimento.getColumnInfo(0);
                column.setVisible(false);
                column.setWidth(0);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(1);
                column.setVisible(false);
                column.setWidth(0);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(2);
                column.setVisible(false);
                column.setWidth(0);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(3);
                column.setVisible(false);
                column.setWidth(0);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(4);
                column.setWidth(200);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(5);
                column.setWidth(200);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(6);
                column.setWidth(50);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(7);
                column.setWidth(70);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(8);
                column.setWidth(100);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(9);
                column.setWidth(100);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(10);
                column.setWidth(100);
                column.setSorter(new SelectionSorter());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMultiColumnListboxMovimento;
    }

    private Panel getPanelBotoes() {
        if (this.ivjPanelBotoes == null) {
            try {
                this.ivjPanelBotoes = new Panel();
                this.ivjPanelBotoes.setName("PanelBotoes");
                this.ivjPanelBotoes.setLayout(this.getPanelBotoesGridLayout());
                this.ivjPanelBotoes.setBounds(14, 414, 637, 24);
                this.getPanelBotoes().add((Component)this.getButtonRecalcular(), this.getButtonRecalcular().getName());
                this.getPanelBotoes().add((Component)this.getButtonSalvar(), this.getButtonSalvar().getName());
                this.getPanelBotoes().add((Component)this.getButtonAjuda(), this.getButtonAjuda().getName());
                this.getPanelBotoes().add((Component)this.getButtonSair(), this.getButtonSair().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPanelBotoes;
    }

    private GridLayout getPanelBotoesGridLayout() {
        GridLayout ivjPanelBotoesGridLayout = null;
        try {
            ivjPanelBotoesGridLayout = new GridLayout();
            ivjPanelBotoesGridLayout.setHgap(0);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjPanelBotoesGridLayout;
    }

    private BBPluginMaskedTextField getTextFieldValorFixo() {
        if (this.ivjTextFieldValorFixo == null) {
            try {
                this.ivjTextFieldValorFixo = new BBPluginMaskedTextField();
                this.ivjTextFieldValorFixo.setName("TextFieldValorFixo");
                this.ivjTextFieldValorFixo.setToolTipText("Informe um valor fixo para todos os recebimentos");
                this.ivjTextFieldValorFixo.setReturnLiterals(false);
                this.ivjTextFieldValorFixo.setMask("###.###.###,##");
                this.ivjTextFieldValorFixo.setInputDirection(InputDirection.LEFT);
                this.ivjTextFieldValorFixo.setBounds(98, 58, 132, 20);
                this.ivjTextFieldValorFixo.setEditable(true);
                this.ivjTextFieldValorFixo.setBlankChar(' ');
                this.ivjTextFieldValorFixo.setBackground(Color.white);
                this.ivjTextFieldValorFixo.setForeground(Color.black);
                this.ivjTextFieldValorFixo.setTamanhoMaximo(50);
                this.ivjTextFieldValorFixo.setMoveCursor(false);
                this.ivjTextFieldValorFixo.setReturnBlanks(true);
                this.ivjTextFieldValorFixo.setFont(new Font("monospaced", 0, 12));
                this.ivjTextFieldValorFixo.setTransferirFocoPorEnter(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTextFieldValorFixo;
    }

    private BBPluginMaskedTextField getTextFieldValorVariavel() {
        if (this.ivjTextFieldValorVariavel == null) {
            try {
                this.ivjTextFieldValorVariavel = new BBPluginMaskedTextField();
                this.ivjTextFieldValorVariavel.setName("TextFieldValorVariavel");
                this.ivjTextFieldValorVariavel.setToolTipText("Informe o valor para os recebimentos");
                this.ivjTextFieldValorVariavel.setReturnLiterals(false);
                this.ivjTextFieldValorVariavel.setMask("###.###.###,##");
                this.ivjTextFieldValorVariavel.setInputDirection(InputDirection.LEFT);
                this.ivjTextFieldValorVariavel.setBounds(98, 24, 132, 20);
                this.ivjTextFieldValorVariavel.setEditable(true);
                this.ivjTextFieldValorVariavel.setBlankChar(' ');
                this.ivjTextFieldValorVariavel.setBackground(Color.white);
                this.ivjTextFieldValorVariavel.setForeground(Color.black);
                this.ivjTextFieldValorVariavel.setTamanhoMaximo(50);
                this.ivjTextFieldValorVariavel.setMoveCursor(false);
                this.ivjTextFieldValorVariavel.setReturnBlanks(true);
                this.ivjTextFieldValorVariavel.setFont(new Font("monospaced", 0, 12));
                this.ivjTextFieldValorVariavel.setTransferirFocoPorEnter(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTextFieldValorVariavel;
    }

    private BBPluginLabel gettxtQuantidade() {
        if (this.ivjtxtQuantidade == null) {
            try {
                this.ivjtxtQuantidade = new BBPluginLabel();
                this.ivjtxtQuantidade.setName("txtQuantidade");
                this.ivjtxtQuantidade.setAlignment(2);
                this.ivjtxtQuantidade.setText("0");
                this.ivjtxtQuantidade.setBounds(87, 191, 58, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjtxtQuantidade;
    }

    private BBPluginLabel gettxtValorTotal() {
        if (this.ivjtxtValorTotal == null) {
            try {
                this.ivjtxtValorTotal = new BBPluginLabel();
                this.ivjtxtValorTotal.setName("txtValorTotal");
                this.ivjtxtValorTotal.setAlignment(2);
                this.ivjtxtValorTotal.setText("0,00");
                this.ivjtxtValorTotal.setBounds(330, 191, 109, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjtxtValorTotal;
    }

    public void habilitarCamposData(boolean estado) {
        this.getBBPluginMaskedTextFieldDiaMes().setEnabled(estado);
        this.getBBPluginMaskedTextFieldData().setEnabled(estado);
        this.getCheckboxDia().setEnabled(estado);
        this.getCheckboxAdicionarData().setEnabled(estado);
        this.getCheckboxFixarData().setEnabled(estado);
        this.getCheckboxMes().setEnabled(estado);
    }

    public void habilitarCamposValor(boolean estado) {
        this.getTextFieldValorFixo().setEnabled(estado);
        this.getTextFieldValorVariavel().setEnabled(estado);
        this.getCheckboxFixarValor().setEnabled(estado);
        this.getCheckboxAdicionarValor().setEnabled(estado);
        this.getCheckboxReal().setEnabled(estado);
        this.getCheckboxPercentual().setEnabled(estado);
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() throws Exception {
        this.getBBPluginChoiceAutoConvenio().addItemListener(this.ivjEventHandler);
        this.getBBPluginChoiceAutoRemessa().addItemListener(this.ivjEventHandler);
        this.getMultiColumnListboxMovimento().addListboxListener(this.ivjEventHandler);
        this.getButtonRetirarCliente().addActionListener(this.ivjEventHandler);
        this.getButtonSair().addActionListener(this.ivjEventHandler);
        this.getButtonSalvar().addActionListener(this.ivjEventHandler);
        this.getButtonRecalcular().addActionListener(this.ivjEventHandler);
        this.getCheckboxAlteraData().addItemListener(this.ivjEventHandler);
        this.getCheckboxAlteraValor().addItemListener(this.ivjEventHandler);
        this.getCheckboxAdicionarData().addItemListener(this.ivjEventHandler);
        this.getCheckboxFixarData().addItemListener(this.ivjEventHandler);
        this.getCheckboxAdicionarValor().addItemListener(this.ivjEventHandler);
        this.getCheckboxFixarValor().addItemListener(this.ivjEventHandler);
        this.connPtoP1SetTarget();
        this.connPtoP2SetTarget();
        this.connPtoP3SetTarget();
        this.connPtoP4SetTarget();
        this.connPtoP5SetTarget();
        this.connPtoP6SetTarget();
        this.connPtoP7SetTarget();
        this.connPtoP8SetTarget();
    }

    private void initialize() {
        try {
            this.setName("MovimentoCadastroRemessa");
            this.setCentralizado(true);
            this.setBorda(true);
            this.setLayout(null);
            this.setSize(662, 481);
            this.setModal(true);
            this.add((Component)this.getBBPluginChoiceAutoConvenio(), this.getBBPluginChoiceAutoConvenio().getName());
            this.add((Component)this.getBBPluginChoiceAutoRemessa(), this.getBBPluginChoiceAutoRemessa().getName());
            this.add((Component)this.getBorderPanelData(), this.getBorderPanelData().getName());
            this.add((Component)this.getBorderPanelValor(), this.getBorderPanelValor().getName());
            this.add((Component)this.getBorderPanelMovimento(), this.getBorderPanelMovimento().getName());
            this.add((Component)this.getPanelBotoes(), this.getPanelBotoes().getName());
            this.add((Component)this.getBBPluginLabelConvenio(), this.getBBPluginLabelConvenio().getName());
            this.add((Component)this.getBBPluginLabelRemessa(), this.getBBPluginLabelRemessa().getName());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.getBBPluginChoiceAutoConvenio().removeAll();
        this.limparTodosCampos();
        this.habilitarCamposData(false);
        this.habilitarCamposValor(false);
    }

    public void limparData() {
        this.getBBPluginMaskedTextFieldDiaMes().setText("");
        this.getBBPluginMaskedTextFieldData().setText("");
        this.getCheckboxDia().setState(false);
        this.getCheckboxAdicionarData().setState(false);
        this.getCheckboxFixarData().setState(false);
        this.getCheckboxMes().setState(false);
    }

    public void limparTodosCampos() {
        this.getBBPluginChoiceAutoRemessa().removeAll();
        this.getMultiColumnListboxMovimento().removeAllRows();
        this.gettxtValorTotal().setText("0,00");
        this.gettxtQuantidade().setText("0");
        this.limparData();
        this.limparValor();
        this.getCheckboxAlteraData().setState(false);
        this.getCheckboxAlteraValor().setState(false);
        this.habilitarCamposData(false);
        this.habilitarCamposValor(false);
    }

    public void limparValor() {
        this.getTextFieldValorFixo().setText("");
        this.getTextFieldValorVariavel().setText("");
        this.getCheckboxFixarValor().setState(false);
        this.getCheckboxAdicionarValor().setState(false);
        this.getCheckboxReal().setState(false);
        this.getCheckboxPercentual().setState(false);
    }

    public static void main(String[] args) {
        try {
            Frame frame = new Frame();
            MovimentoCadastroRemessa aMovimentoCadastroRemessa = new MovimentoCadastroRemessa();
            frame.add("Center", aMovimentoCadastroRemessa);
            ((Component)frame).setSize(aMovimentoCadastroRemessa.getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            ((Component)frame).setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Ocorreu uma exce\u00e7\u00e3o no main() do br.com.bb.plugins.interfaces.infraestrutura.PanelBB");
            exception.printStackTrace(System.out);
        }
    }

    public void multiColumnListboxMovimento_RowSelected(ListboxEvent arg1) {
        this.getButtonRetirarCliente().setEnabled(true);
    }

    public void popular() {
        try {
            this.popularChoiceConvenio();
            this.popularChoiceRemessa();
        }
        catch (Throwable e) {
            this.getRoteador().exibirMensagemErro(e);
        }
    }

    public void popularChoiceConvenio() throws Throwable {
        try {
            this.getBBPluginChoiceAutoConvenio().removeAll();
            ConvenioDBT convenio = new ConvenioDBT();
            convenio.setCodigoPessoaConvenenteDBT(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            this.getBBPluginChoiceAutoConvenio().add(ControleConvenente.getControleConvenente().obterListaConvenioDBT(convenio));
        }
        catch (Throwable t) {
            this.getRoteador().exibirMensagemErro(t);
        }
    }

    public void popularChoiceRemessa() throws Throwable {
        try {
            RemessaRecebimentoDBT remessaRecebimentoDBT = new RemessaRecebimentoDBT();
            remessaRecebimentoDBT.setNumeroConvenioFK(this.getBBPluginChoiceAutoConvenio().getSelectedCodigo());
            this.getBBPluginChoiceAutoRemessa().removeAll();
            this.getBBPluginChoiceAutoRemessa().add("");
            this.getBBPluginChoiceAutoRemessa().add(ControleRemessaRecebimentos.getControleRemessaRecebimentos().obterListaRemessa(remessaRecebimentoDBT));
        }
        catch (Throwable t) {
            this.getRoteador().exibirMensagemErro(t);
        }
    }

    public void popularGridMovimento() {
        try {
            RecebimentoDBT recebimentoDBT = new RecebimentoDBT();
            IBarraProgresso barraProgresso = this.getRoteador().getFramePlugin().obterBarraProgresso();
            barraProgresso.inicializar("Gerando recebimentos. Aguarde...", this.vetorRecebimentos.size(), false);
            int tamanhoVetorRecebimentos = this.vetorRecebimentos.size();
            barraProgresso.setValorMaximo(tamanhoVetorRecebimentos);
            this.getMultiColumnListboxMovimento().removeAllRows();
            this.gettxtQuantidade().setText("");
            this.gettxtValorTotal().setText("0,00");
            Object[][] recDBT = new String[this.vetorRecebimentos.size()][11];
            double total = 0.0;
            int qtd = 0;
            int i = 0;
            while (i < tamanhoVetorRecebimentos) {
                recebimentoDBT = (RecebimentoDBT)this.vetorRecebimentos.elementAt(i);
                recDBT[i][0] = recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaRel();
                recDBT[i][1] = recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().getCodigoIdentificador();
                recDBT[i][2] = recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaIdentificadorRel();
                recDBT[i][3] = recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador();
                recDBT[i][4] = recebimentoDBT.getCliente().getPessoa().getNomePessoa();
                recDBT[i][5] = Util.formatarString(recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador(), recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().getIdentificador().getMascara());
                recDBT[i][6] = "001";
                recDBT[i][7] = Util.formatarConta(recebimentoDBT.getIdentificadorDBT().getContaCorrente().getAgencia().getCodigoPrefixoAgencia());
                recDBT[i][8] = Util.formatarConta(recebimentoDBT.getIdentificadorDBT().getContaCorrente().getnumeroContaCorrente());
                recDBT[i][9] = Util.formatarData(recebimentoDBT.getDataRecebimento());
                recDBT[i][10] = Util.formatarValor(recebimentoDBT.getValorRecebimento(), 2);
                ++qtd;
                total += recebimentoDBT.getValorRecebimento();
                barraProgresso.add(1);
                ++i;
            }
            this.getMultiColumnListboxMovimento().addRows(recDBT);
            this.gettxtValorTotal().setText(Util.formatarValor(total, 2));
            this.gettxtQuantidade().setText(String.valueOf(qtd));
            barraProgresso.finalizar();
        }
        catch (Throwable e) {
            this.getRoteador().exibirMensagemErro(e);
        }
    }

    public void recalcularData() {
        try {
            if (this.getMultiColumnListboxMovimento().getRowCount() > 0) {
                IBarraProgresso barra = this.getRoteador().obterBarraProgresso();
                barra.setMensagem("Recalculando a data dos recebimentos. Aguarde...");
                barra.setValorMaximo(this.getMultiColumnListboxMovimento().getRowCount());
                boolean dataUtil = true;
                int i = 0;
                while (i < this.getMultiColumnListboxMovimento().getRowCount()) {
                    Object[] o = this.getMultiColumnListboxMovimento().getRow(i);
                    if (this.getCheckboxAlteraData().getState()) {
                        if (this.getCheckboxFixarData().getState()) {
                            o[9] = String.valueOf(this.getBBPluginMaskedTextFieldData().getText().substring(0, 2)) + "/" + this.getBBPluginMaskedTextFieldData().getText().substring(2, 4) + "/" + this.getBBPluginMaskedTextFieldData().getText().substring(4);
                        } else if (this.getCheckboxAdicionarData().getState()) {
                            Data novaDataMov;
                            String novoAnoMov;
                            String novoMesMov;
                            String novoDiaMov;
                            String diaMov = o[9].toString().substring(0, 2).trim();
                            String mesMov = o[9].toString().substring(3, 5).trim();
                            String anoMov = o[9].toString().substring(6).trim();
                            GregorianCalendar dataMov = new GregorianCalendar();
                            dataMov.set(Integer.parseInt(anoMov), Integer.parseInt(mesMov) - 1, Integer.parseInt(diaMov));
                            if (this.getCheckboxDia().getState()) {
                                dataMov.add(5, Integer.parseInt(this.getBBPluginMaskedTextFieldDiaMes().getText().trim()));
                                novoDiaMov = Util.formatarData(dataMov.getTime()).substring(0, 2).trim();
                                novoMesMov = Util.formatarData(dataMov.getTime()).substring(3, 5).trim();
                                novoAnoMov = Util.formatarData(dataMov.getTime()).substring(6).trim();
                                novaDataMov = new Data();
                                novaDataMov.set(Integer.parseInt(novoDiaMov), Integer.parseInt(novoMesMov), Integer.parseInt(novoAnoMov));
                                if (!novaDataMov.isDiaUtil()) {
                                    o[9] = novaDataMov.getProximaDataUtil().getFormatada();
                                    dataUtil = false;
                                } else {
                                    o[9] = novaDataMov.getFormatada();
                                }
                            } else if (this.getCheckboxMes().getState()) {
                                dataMov.add(2, Integer.parseInt(this.getBBPluginMaskedTextFieldDiaMes().getText().trim()));
                                novoDiaMov = Util.formatarData(dataMov.getTime()).substring(0, 2).trim();
                                novoMesMov = Util.formatarData(dataMov.getTime()).substring(3, 5).trim();
                                novoAnoMov = Util.formatarData(dataMov.getTime()).substring(6).trim();
                                novaDataMov = new Data();
                                novaDataMov.set(Integer.parseInt(novoDiaMov), Integer.parseInt(novoMesMov), Integer.parseInt(novoAnoMov));
                                if (!novaDataMov.isDiaUtil()) {
                                    o[9] = novaDataMov.getProximaDataUtil().getFormatada();
                                    dataUtil = false;
                                } else {
                                    o[9] = novaDataMov.getFormatada();
                                }
                            }
                        }
                        this.getMultiColumnListboxMovimento().replaceRow(o, i);
                    }
                    barra.setValor(i);
                    ++i;
                }
                if (!dataUtil) {
                    this.getRoteador().exibirMensagem("Ao recalcular os recebimentos, algumas datas resultaram em dia n\u00e3o \u00fatil. Essas datas foram alteradas para o pr\u00f3ximo dia \u00fatil");
                }
                barra.finalizar();
            }
        }
        catch (Throwable t) {
            this.getRoteador().exibirMensagemErro(t);
        }
    }

    public void recalcularRecebimentos() {
        this.recalcularData();
        this.recalcularValor();
    }

    public void recalcularValor() {
        try {
            if (this.getMultiColumnListboxMovimento().getRowCount() > 0) {
                IBarraProgresso barra = this.getRoteador().obterBarraProgresso();
                barra.setMensagem("Recalculando o valor dos recebimentos. Aguarde...");
                barra.setValorMaximo(this.getMultiColumnListboxMovimento().getRowCount());
                double total = 0.0;
                double novoValor = 0.0;
                int i = 0;
                while (i < this.getMultiColumnListboxMovimento().getRowCount()) {
                    Object[] o = this.getMultiColumnListboxMovimento().getRow(i);
                    if (this.getCheckboxAlteraValor().getState()) {
                        if (this.getCheckboxFixarValor().getState()) {
                            o[10] = Util.formatarValor(Double.valueOf(this.getTextFieldValorFixo().getText().trim()) / 100.0, 2);
                            total += Double.valueOf(this.getTextFieldValorFixo().getText()) / 100.0;
                        } else if (this.getCheckboxAdicionarValor().getState()) {
                            if (this.getCheckboxReal().getState()) {
                                novoValor = Double.valueOf(Util.desformatarValor(o[10].toString())) / 100.0 + Double.valueOf(this.getTextFieldValorVariavel().getText().trim()) / 100.0;
                                o[10] = Util.formatarValor(novoValor, 2);
                                total += novoValor;
                            } else if (this.getCheckboxPercentual().getState()) {
                                novoValor = Double.valueOf(Util.desformatarValor(o[10].toString())) / 100.0 + Double.valueOf(Util.desformatarValor(o[10].toString())) / 100.0 * (Double.valueOf(this.getTextFieldValorVariavel().getText()) / 100.0) / 100.0;
                                o[10] = Util.formatarValor(novoValor, 2);
                                total += novoValor;
                            }
                        }
                        this.getMultiColumnListboxMovimento().replaceRow(o, i);
                    }
                    barra.setValor(i);
                    ++i;
                }
                if (this.getCheckboxAlteraValor().getState()) {
                    this.gettxtValorTotal().setText(Util.formatarValor(total, 2));
                }
                barra.finalizar();
            }
        }
        catch (Throwable t) {
            this.getRoteador().exibirMensagemErro(t);
        }
    }

    class IvjEventHandler
    implements ListboxListener,
    ActionListener,
    ItemListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MovimentoCadastroRemessa.this.getButtonRetirarCliente()) {
                MovimentoCadastroRemessa.this.connEtoC4(e);
            }
            if (e.getSource() == MovimentoCadastroRemessa.this.getButtonSair()) {
                MovimentoCadastroRemessa.this.connEtoC5(e);
            }
            if (e.getSource() == MovimentoCadastroRemessa.this.getButtonSalvar()) {
                MovimentoCadastroRemessa.this.connEtoC6(e);
            }
            if (e.getSource() == MovimentoCadastroRemessa.this.getButtonRecalcular()) {
                MovimentoCadastroRemessa.this.connEtoC7(e);
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == MovimentoCadastroRemessa.this.getBBPluginChoiceAutoConvenio()) {
                MovimentoCadastroRemessa.this.connEtoC1(e);
            }
            if (e.getSource() == MovimentoCadastroRemessa.this.getBBPluginChoiceAutoRemessa()) {
                MovimentoCadastroRemessa.this.connEtoC2(e);
            }
            if (e.getSource() == MovimentoCadastroRemessa.this.getCheckboxAlteraData()) {
                MovimentoCadastroRemessa.this.connEtoC8(e);
            }
            if (e.getSource() == MovimentoCadastroRemessa.this.getCheckboxAlteraValor()) {
                MovimentoCadastroRemessa.this.connEtoC9(e);
            }
            if (e.getSource() == MovimentoCadastroRemessa.this.getCheckboxAdicionarData()) {
                MovimentoCadastroRemessa.this.connEtoC10(e);
            }
            if (e.getSource() == MovimentoCadastroRemessa.this.getCheckboxFixarData()) {
                MovimentoCadastroRemessa.this.connEtoC11(e);
            }
            if (e.getSource() == MovimentoCadastroRemessa.this.getCheckboxAdicionarValor()) {
                MovimentoCadastroRemessa.this.connEtoC12(e);
            }
            if (e.getSource() == MovimentoCadastroRemessa.this.getCheckboxFixarValor()) {
                MovimentoCadastroRemessa.this.connEtoC13(e);
            }
        }

        public void rowDeselected(ListboxEvent arg1) {
        }

        public void rowSelected(ListboxEvent arg1) {
            if (arg1.getSource() == MovimentoCadastroRemessa.this.getMultiColumnListboxMovimento()) {
                MovimentoCadastroRemessa.this.connEtoC3(arg1);
            }
        }
    }
}

