/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.negocio.recebimentosdeterceiros;

import br.com.bb.plugins.interfaces.infraestrutura.ILinhaGerenciadorListas;
import br.com.bb.plugins.negocio.comum.Convenente;
import br.com.bb.plugins.negocio.comum.Identificacao;
import br.com.bb.plugins.negocio.comum.Identificador;
import br.com.bb.plugins.negocio.comum.RelacaoPessoaPlugin;
import br.com.bb.plugins.utilitarios.Util;

public class ConvenenteDBT
implements ILinhaGerenciadorListas {
    private Convenente convenente = new Convenente();
    private Identificacao identificacao = new Identificacao();
    private String codigoIdentificadorProprio = "";
    private String indicadorIdentificadorProprio = "";
    private Identificador identificadorProprio = new Identificador();
    private RelacaoPessoaPlugin relacaoPessoaPlugin = new RelacaoPessoaPlugin();
    private Identificador identificadorFavorecidos = null;

    public String getCodigoIdentificadorProprio() {
        return this.codigoIdentificadorProprio;
    }

    public Convenente getConvenente() {
        return this.convenente;
    }

    public Identificacao getIdentificacao() {
        return this.identificacao;
    }

    public Identificador getIdentificadorFavorecidos() {
        return this.identificadorFavorecidos;
    }

    public Identificador getIdentificadorProprio() {
        return this.identificadorProprio;
    }

    public String getIndicadorIdentificadorProprio() {
        return this.indicadorIdentificadorProprio;
    }

    public String[] getLinhaGerenciadorListas() {
        String[] linha = new String[4];
        linha[0] = this.getConvenente().getPessoa().getCodigoPessoa();
        linha[1] = this.getIdentificacao().getNumeroIdentificador();
        if (this.getIdentificacao().getNumeroIdentificador() != null) {
            linha[2] = Util.formatarString(this.getIdentificacao().getNumeroIdentificador(), this.identificacao.getIdentificador().getMascara());
        }
        linha[3] = this.getConvenente().getPessoa().getNomePessoa();
        return linha;
    }

    public RelacaoPessoaPlugin getRelacaoPessoaPlugin() {
        return this.relacaoPessoaPlugin;
    }

    public void setCodigoIdentificadorProprio(String newCodigoIdentificadorProprio) {
        this.codigoIdentificadorProprio = newCodigoIdentificadorProprio;
    }

    public void setConvenente(Convenente newConvenente) {
        this.convenente = newConvenente;
    }

    public void setIdentificacao(Identificacao newIdentificacao) {
        this.identificacao = newIdentificacao;
    }

    public void setIdentificadorFavorecidos(Identificador newIdentificadorFavorecidos) {
        this.identificadorFavorecidos = newIdentificadorFavorecidos;
    }

    public void setIdentificadorProprio(Identificador newIdentificadorProprio) {
        this.identificadorProprio = newIdentificadorProprio;
    }

    public void setIndicadorIdentificadorProprio(String newIndicadorIdentificadorProprio) {
        this.indicadorIdentificadorProprio = newIndicadorIdentificadorProprio;
    }

    public void setRelacaoPessoaPlugin(RelacaoPessoaPlugin newRelacaoPessoaPlugin) {
        this.relacaoPessoaPlugin = newRelacaoPessoaPlugin;
    }
}

