/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.negocio.recebimentosdeterceiros;

import br.com.bb.plugins.interfaces.infraestrutura.ILinhaGerenciadorListas;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ClienteDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ConvenioDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.IdentificadorDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.RemessaRecebimentoDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.SituacaoRecebimento;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.TipoOcorrenciaRecebimentoDBT;
import br.com.bb.plugins.utilitarios.Util;
import java.util.Date;

public class RecebimentoDBT
implements ILinhaGerenciadorListas {
    private int numeroRecebimentoDBT;
    private double valorRecebimento;
    private Date dataRecebimento;
    private Date dataRemessaRel;
    private int numeroRemessaRel;
    private String codigoSituacaoRecebimentoRel;
    private ClienteDBT cliente = new ClienteDBT();
    private ConvenioDBT convenio = new ConvenioDBT();
    private RemessaRecebimentoDBT remessaRecebimentoDBT = new RemessaRecebimentoDBT();
    private SituacaoRecebimento situacaoRecebimento = new SituacaoRecebimento();
    private TipoOcorrenciaRecebimentoDBT tipoOcorrenciaRecebimentoDBT = new TipoOcorrenciaRecebimentoDBT();
    private IdentificadorDBT identificadorDBT = new IdentificadorDBT();
    private String codigoBancoLiquidacao = "";
    private String codigoPrefixoAgenciaLiquidacao = "";
    private String numeroContaCorrenteLiquidacao = "";
    private String idRegistro = "";
    private double valorDebitoEfetuado;
    private Date dataDebitoEfetuado;

    public ClienteDBT getCliente() {
        return this.cliente;
    }

    public String getCodigoBancoLiquidacao() {
        return this.codigoBancoLiquidacao;
    }

    public String getCodigoPrefixoAgenciaLiquidacao() {
        return this.codigoPrefixoAgenciaLiquidacao;
    }

    public String getCodigoSituacaoRecebimentoRel() {
        return this.codigoSituacaoRecebimentoRel;
    }

    public ConvenioDBT getConvenio() {
        return this.convenio;
    }

    public Date getDataDebitoEfetuado() {
        return this.dataDebitoEfetuado;
    }

    public Date getDataRecebimento() {
        return this.dataRecebimento;
    }

    public Date getDataRemessaRel() {
        return this.dataRemessaRel;
    }

    public IdentificadorDBT getIdentificadorDBT() {
        return this.identificadorDBT;
    }

    public String getIdRegistro() {
        return this.idRegistro;
    }

    public String[] getLinhaGerenciadorListas() {
        String[] linha = new String[16];
        try {
            linha[0] = String.valueOf(this.getNumeroRecebimentoDBT());
            String mascara = "";
            if (this.cliente.getPessoa().getTipoPessoa().getCodigoTipoPessoa() != 0) {
                linha[1] = this.cliente.getIdentificacao().getNumeroIdentificador() != null ? Util.formatarString(this.cliente.getIdentificacao().getNumeroIdentificador(), this.cliente.getIdentificacao().getIdentificador().getMascara()) : "";
            }
            linha[2] = this.cliente.getPessoa().getNomePessoa();
            linha[3] = this.cliente.getIdentificacaoPropria().getNumeroIdentificador() != null ? Util.formatarString(this.cliente.getIdentificacaoPropria().getNumeroIdentificador(), this.cliente.getIdentificacaoPropria().getIdentificador().getMascara()) : "";
            linha[4] = this.convenio.getNumeroConvenioDBT();
            linha[5] = Util.formatarString(this.identificadorDBT.getIdentificacaoDBT().getNumeroIdentificador(), this.identificadorDBT.getIdentificacaoDBT().getIdentificador().getMascara());
            if (!this.getCodigoSituacaoRecebimentoRel().equals("D")) {
                linha[6] = "001";
                linha[7] = Util.formatarConta(this.getIdentificadorDBT().getContaCorrente().getcodigoPrefixoAgenciaRel());
                linha[8] = Util.formatarConta(this.getIdentificadorDBT().getContaCorrente().getnumeroContaCorrente());
                linha[9] = Util.formatarData(this.getDataRecebimento());
                linha[10] = Util.formatarValor(this.getValorRecebimento(), 2);
                linha[14] = String.valueOf(this.getValorRecebimento());
            } else {
                linha[6] = this.getCodigoBancoLiquidacao();
                linha[7] = Util.formatarConta(this.getCodigoPrefixoAgenciaLiquidacao());
                linha[8] = Util.formatarConta(this.getNumeroContaCorrenteLiquidacao());
                linha[9] = this.getDataDebitoEfetuado() != null && !this.getDataDebitoEfetuado().equals("") ? Util.formatarData(this.getDataDebitoEfetuado()) : "";
                linha[10] = this.getValorDebitoEfetuado() > 0.0 ? Util.formatarValor(this.getValorDebitoEfetuado(), 2) : "";
                linha[14] = this.getValorDebitoEfetuado() > 0.0 ? String.valueOf(this.getValorDebitoEfetuado()) : "";
            }
            linha[11] = this.situacaoRecebimento.getTextoDescricao();
            linha[12] = Util.formatarData(this.getDataRemessaRel());
            linha[13] = this.getNumeroRemessaRel() != 0 ? String.valueOf(this.getNumeroRemessaRel()) : "";
            linha[15] = this.getIdentificadorDBT().getMembroGrupoRecebimentoDBT().getGrupo().getTextoDescricao() != null && !this.getIdentificadorDBT().getMembroGrupoRecebimentoDBT().getGrupo().getTextoDescricao().equals("") ? this.getIdentificadorDBT().getMembroGrupoRecebimentoDBT().getGrupo().getTextoDescricao() : "";
        }
        catch (Throwable t) {
            Util.exibirMensagemErro(t);
        }
        return linha;
    }

    public String getNumeroContaCorrenteLiquidacao() {
        return this.numeroContaCorrenteLiquidacao;
    }

    public int getNumeroRecebimentoDBT() {
        return this.numeroRecebimentoDBT;
    }

    public int getNumeroRemessaRel() {
        return this.numeroRemessaRel;
    }

    public RemessaRecebimentoDBT getRemessaRecebimentoDBT() {
        return this.remessaRecebimentoDBT;
    }

    public SituacaoRecebimento getSituacaoRecebimento() {
        return this.situacaoRecebimento;
    }

    public TipoOcorrenciaRecebimentoDBT getTipoOcorrenciaRecebimentoDBT() {
        return this.tipoOcorrenciaRecebimentoDBT;
    }

    public double getValorDebitoEfetuado() {
        return this.valorDebitoEfetuado;
    }

    public double getValorRecebimento() {
        return this.valorRecebimento;
    }

    public void setCliente(ClienteDBT newCliente) {
        this.cliente = newCliente;
    }

    public void setCodigoBancoLiquidacao(String newCodigoBancoLiquidacao) {
        this.codigoBancoLiquidacao = newCodigoBancoLiquidacao;
    }

    public void setCodigoPrefixoAgenciaLiquidacao(String newCodigoPrefixoAgenciaLiquidacao) {
        this.codigoPrefixoAgenciaLiquidacao = newCodigoPrefixoAgenciaLiquidacao;
    }

    public void setCodigoSituacaoRecebimentoRel(String newCodigoSituacaoRecebimentoRel) {
        this.codigoSituacaoRecebimentoRel = newCodigoSituacaoRecebimentoRel;
    }

    public void setConvenio(ConvenioDBT newConvenio) {
        this.convenio = newConvenio;
    }

    public void setDataDebitoEfetuado(Date newDataDebitoEfetuado) {
        this.dataDebitoEfetuado = newDataDebitoEfetuado;
    }

    public void setDataRecebimento(Date newDataRecebimento) {
        this.dataRecebimento = newDataRecebimento;
    }

    public void setDataRemessaRel(Date newDataRemessaRel) {
        this.dataRemessaRel = newDataRemessaRel;
    }

    public void setIdentificadorDBT(IdentificadorDBT newIdentificadorDBT) {
        this.identificadorDBT = newIdentificadorDBT;
    }

    public void setIdRegistro(String newIdRegistro) {
        this.idRegistro = newIdRegistro;
    }

    public void setNumeroContaCorrenteLiquidacao(String newNumeroContaCorrenteLiquidacao) {
        this.numeroContaCorrenteLiquidacao = newNumeroContaCorrenteLiquidacao;
    }

    public void setNumeroRecebimentoDBT(int newNumeroRecebimentoDBT) {
        this.numeroRecebimentoDBT = newNumeroRecebimentoDBT;
    }

    public void setNumeroRemessaRel(int newNumeroRemessaRel) {
        this.numeroRemessaRel = newNumeroRemessaRel;
    }

    public void setRemessaRecebimentoDBT(RemessaRecebimentoDBT newRemessaRecebimentoDBT) {
        this.remessaRecebimentoDBT = newRemessaRecebimentoDBT;
    }

    public void setSituacaoRecebimento(SituacaoRecebimento newSituacaoRecebimento) {
        this.situacaoRecebimento = newSituacaoRecebimento;
    }

    public void setTipoOcorrenciaRecebimentoDBT(TipoOcorrenciaRecebimentoDBT newTipoOcorrenciaRecebimentoDBT) {
        this.tipoOcorrenciaRecebimentoDBT = newTipoOcorrenciaRecebimentoDBT;
    }

    public void setValorDebitoEfetuado(double newValorDebitoEfetuado) {
        this.valorDebitoEfetuado = newValorDebitoEfetuado;
    }

    public void setValorRecebimento(double newValorRecebimento) {
        this.valorRecebimento = newValorRecebimento;
    }
}

