/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.persistencia.recebimentosdeterceiros;

import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.negocio.infraestrutura.Filtro;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.IdentificadorDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.RecebimentoDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.RemessaRecebimentoDBT;
import br.com.bb.plugins.persistencia.comum.Persistencia;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ClienteDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ConvenioDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.IdentificadorDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.RemessaRecebimentoBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.SituacaoRecebimentoBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.TipoOcorrenciaRecebimentoBD;
import br.com.bb.plugins.utilitarios.Util;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;

public class RecebimentoDBTBD
extends Persistencia {
    private static RecebimentoDBTBD recebimentoDBTBD;

    protected RecebimentoDBTBD() {
    }

    public int abrirLista() throws SQLException {
        String query = "SELECT RecebimentoDBT.*  FROM RecebimentoDBT  WHERE (((RecebimentoDBT.codigoPessoaIdentificadorFK)='" + ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa() + "'))";
        return this.adicionarLista(query);
    }

    public int abrirListaMovimento(Filtro filtro) throws Throwable {
        String condicao;
        String query = "SELECT DISTINCT RecebimentoDBT.*, Pessoa.textoNome, Identificacao.numeroIdentificador, IdentificadorClienteDBT.codigoPrefixoAgenciaFK, IdentificadorClienteDBT.numeroContaCorrenteFK  FROM RelacaoPessoaPlugin, IdentificadorClienteDBT, Identificacao, Pessoa, RecebimentoDBT, GrupoClienteRecebimento, MembroGrupoClienteRecebimento  WHERE IdentificadorClienteDBT.codigoPessoaFK = Identificacao.codigoPessoaFK  AND IdentificadorClienteDBT.codigoIdentificadorFK = Identificacao.codigoIdentificadorFK  AND IdentificadorClienteDBT.codigoPessoaIdentificadorFK = Identificacao.codigoPessoaIdentificadorFK  AND IdentificadorClienteDBT.numeroIdentificadorFK = Identificacao.numeroIdentificador  AND Identificacao.codigoPessoaFK = Pessoa.codigoPessoa  AND Identificacao.codigoPessoaFK = RecebimentoDBT.codigoPessoaFK  AND Identificacao.codigoIdentificadorFK = RecebimentoDBT.codigoIdentificadorFK  AND Identificacao.codigoPessoaIdentificadorFK = RecebimentoDBT.codigoPessoaIdentificadorFK  AND Identificacao.numeroIdentificador = RecebimentoDBT.numeroIdentificadorFK  AND  RelacaoPessoaPlugin.codigoPessoaFK = RecebimentoDBT.codigoPessoaFK ";
        if (filtro.getCampo("CodigoGrupo") != null) {
            query = String.valueOf(query) + "AND RelacaoPessoaPlugin.codigoPessoaConvenenteFK = GrupoClienteRecebimento.codigoPessoaFK";
        }
        if ((condicao = this.montarCondicao(filtro)).length() > 0) {
            query = String.valueOf(query) + condicao;
        }
        return this.adicionarLista(query);
    }

    public void adicionar(Object objetoNegocio) throws SQLException {
        RecebimentoDBT recebimento = (RecebimentoDBT)objetoNegocio;
        int novoCodigo = this.calculaNovoCodigo();
        String idRegistro = "";
        idRegistro = this.calculaIDRegistro(novoCodigo);
        recebimento.setNumeroRecebimentoDBT(novoCodigo);
        recebimento.setIdRegistro(idRegistro);
        String query = "";
        query = String.valueOf(query) + " INSERT INTO RecebimentoDBT (numeroRecebimentoDBT, valor, data, dataRemessaFK, numeroRemessaFK, codigoPessoaFK, codigoSituacaoRecebimentoFK, codigoIdentificadorFK, codigoPessoaIdentificadorFK, numeroIdentificadorFK, numeroConvenioDBT, dataDebitoEfetuado, valorDebitoEfetuado, IDRegistro) VALUES (" + recebimento.getNumeroRecebimentoDBT() + ", " + recebimento.getValorRecebimento() + ", " + this.dataSql(recebimento.getDataRecebimento()) + ", " + this.dataSql(recebimento.getDataRemessaRel()) + ", " + recebimento.getNumeroRemessaRel() + ", '" + recebimento.getCliente().getPessoa().getCodigoPessoa() + "', '" + recebimento.getCodigoSituacaoRecebimentoRel() + "', '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoIdentificador() + "', '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaIdentificadorRel() + "', '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador() + "', '" + recebimento.getConvenio().getNumeroConvenioDBT() + "', " + this.dataSql(recebimento.getDataDebitoEfetuado()) + ", " + recebimento.getValorDebitoEfetuado() + ", '" + idRegistro + "') ";
        this.executar(query);
    }

    public void alterar(Object objetoNegocio) throws SQLException {
        RecebimentoDBT recebimento = (RecebimentoDBT)objetoNegocio;
        String query = "";
        query = String.valueOf(query) + " UPDATE RecebimentoDBT  SET valor = " + recebimento.getValorRecebimento() + ", data = " + this.dataSql(recebimento.getDataRecebimento()) + ", dataRemessaFK = " + this.dataSql(recebimento.getDataRemessaRel()) + ", numeroRemessaFK = " + recebimento.getNumeroRemessaRel() + ", codigoPessoaFK = '" + recebimento.getCliente().getPessoa().getCodigoPessoa() + "', codigoSituacaoRecebimentoFK = '" + recebimento.getCodigoSituacaoRecebimentoRel() + "', codigoIdentificadorFK = '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoIdentificadorRel() + "', codigoPessoaIdentificadorFK = '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaIdentificadorRel() + "', numeroIdentificadorFK = '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador() + "', codigoTipoRetornoFK = " + this.nuloSeVazio(recebimento.getTipoOcorrenciaRecebimentoDBT().getCodigoTipoRetorno()) + ", codigoRetornoFK = " + this.nuloSeVazio(recebimento.getTipoOcorrenciaRecebimentoDBT().getCodigoRetorno()) + ", dataDebitoEfetuado = " + this.dataSql(recebimento.getDataDebitoEfetuado()) + ", valorDebitoEfetuado = " + recebimento.getValorDebitoEfetuado() + ", codigoBancoLiquidacao = '001' " + ", codigoPrefixoAgenciaLiquidacao = '" + this.vazioSeNulo(recebimento.getCodigoPrefixoAgenciaLiquidacao()) + "', numeroContaCorrenteLiquidacao = '" + this.vazioSeNulo(recebimento.getNumeroContaCorrenteLiquidacao()) + "', IDRegistro = " + this.nuloSeVazio(recebimento.getIdRegistro()) + " WHERE numeroRecebimentoDBT = " + recebimento.getNumeroRecebimentoDBT() + " ";
        this.executar(query);
    }

    public void alterarEstadoTodaRemessa(String codigoSituacaoRecebimento, int numeroRemessa) throws SQLException {
        String query = "UPDATE RecebimentoDBT  SET codigoSituacaoRecebimentoFK = '" + codigoSituacaoRecebimento + "', " + " dataRemessaFK = null, " + " numeroRemessaFK = 0 " + " WHERE numeroRemessaFK = " + numeroRemessa;
        this.executar(query);
    }

    public String calculaIDRegistro(int numeroRecebimento) throws SQLException {
        String numeroRec = "";
        numeroRec = Integer.toString(numeroRecebimento);
        try {
            numeroRec = Util.strZero(numeroRec, 7);
        }
        catch (Throwable t) {
            throw (SQLException)t;
        }
        Date agora = new Date();
        String idRegistro = String.valueOf(Math.random());
        idRegistro = idRegistro.trim().substring(idRegistro.trim().length() - 5, idRegistro.trim().length());
        idRegistro = String.valueOf(idRegistro) + String.valueOf(agora.getTime());
        idRegistro = String.valueOf(idRegistro) + numeroRec;
        return idRegistro;
    }

    public int calculaNovoCodigo() throws SQLException {
        String query = "SELECT max(numeroRecebimentoDBT) FROM RecebimentoDBT";
        this.conectar();
        int novoCodigo = 0;
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        if (rs.next()) {
            String ultimoCodigo = rs.getString(1);
            novoCodigo = ultimoCodigo == null ? 0 : Integer.parseInt(ultimoCodigo);
            ++novoCodigo;
            rs.close();
            stmt.close();
        } else {
            rs.close();
            stmt.close();
            novoCodigo = 1;
        }
        return novoCodigo;
    }

    public static RecebimentoDBTBD getRecebimentoDBTBD() {
        if (recebimentoDBTBD == null) {
            recebimentoDBTBD = new RecebimentoDBTBD();
        }
        return recebimentoDBTBD;
    }

    public void lerRegistro(Object objetoNegocio, ResultSet rs) throws SQLException {
        RecebimentoDBT recebimento = (RecebimentoDBT)objetoNegocio;
        recebimento.setNumeroRecebimentoDBT(rs.getInt("numeroRecebimentoDBT"));
        recebimento.setValorRecebimento(rs.getDouble("valor"));
        recebimento.setDataRecebimento(rs.getDate("data"));
        recebimento.setDataRemessaRel(rs.getDate("dataRemessaFK"));
        recebimento.setNumeroRemessaRel(rs.getInt("numeroRemessaFK"));
        recebimento.setCodigoBancoLiquidacao(rs.getString("codigoBancoLiquidacao"));
        recebimento.setCodigoPrefixoAgenciaLiquidacao(rs.getString("codigoPrefixoAgenciaLiquidacao"));
        recebimento.setNumeroContaCorrenteLiquidacao(rs.getString("numeroContaCorrenteLiquidacao"));
        recebimento.setDataDebitoEfetuado(rs.getDate("dataDebitoEfetuado"));
        recebimento.setValorDebitoEfetuado(rs.getDouble("valorDebitoEfetuado"));
        recebimento.setCodigoSituacaoRecebimentoRel(rs.getString("codigoSituacaoRecebimentoFK"));
        recebimento.getSituacaoRecebimento().setCodigoSituacaoRecebimento(recebimento.getCodigoSituacaoRecebimentoRel());
        SituacaoRecebimentoBD.getSituacaoRecebimentoBD().obter(recebimento.getSituacaoRecebimento());
        recebimento.getConvenio().setNumeroConvenioDBT(rs.getString("numeroConvenioDBT"));
        ConvenioDBTBD.getConvenioDBTBD().obter(recebimento.getConvenio());
        recebimento.getCliente().getPessoa().setCodigoPessoa(rs.getString("codigoPessoaFK"));
        ClienteDBTBD.getClienteDBTBD().obter(recebimento.getCliente());
        recebimento.getIdentificadorDBT().getIdentificacaoDBT().setCodigoPessoaRel(recebimento.getCliente().getPessoa().getCodigoPessoa());
        recebimento.getIdentificadorDBT().getIdentificacaoDBT().setCodigoIdentificadorRel(rs.getString("codigoIdentificadorFK"));
        recebimento.getIdentificadorDBT().getIdentificacaoDBT().setCodigoPessoaIdentificadorRel(rs.getString("codigoPessoaIdentificadorFK"));
        byte[] ByteIdentificacaoDBT = rs.getBytes("numeroIdentificadorFK");
        String strIdentificacaoDBT = new String(ByteIdentificacaoDBT);
        recebimento.getIdentificadorDBT().getIdentificacaoDBT().setNumeroIdentificador(strIdentificacaoDBT);
        IdentificadorDBTBD.getIdentificadorDBTBD().obter(recebimento.getIdentificadorDBT());
        recebimento.getTipoOcorrenciaRecebimentoDBT().setCodigoRetorno(String.valueOf(rs.getInt("codigoRetornoFK")));
        recebimento.getTipoOcorrenciaRecebimentoDBT().setCodigoTipoRetorno(String.valueOf(rs.getInt("codigoTipoRetornoFK")));
        if (!recebimento.getTipoOcorrenciaRecebimentoDBT().getCodigoRetorno().equals("0")) {
            TipoOcorrenciaRecebimentoBD.getTipoOcorrenciaRecebimentoBD().obter(recebimento.getTipoOcorrenciaRecebimentoDBT());
        }
        recebimento.getRemessaRecebimentoDBT().setDataRemessa(recebimento.getDataRemessaRel());
        recebimento.getRemessaRecebimentoDBT().setNumeroRemessa(recebimento.getNumeroRemessaRel());
        recebimento.getRemessaRecebimentoDBT().setNumeroConvenioFK(recebimento.getConvenio().getNumeroConvenioDBT());
        if (recebimento.getRemessaRecebimentoDBT().getNumeroRemessa() != 0 && recebimento.getRemessaRecebimentoDBT().getDataRemessa() != null) {
            RemessaRecebimentoBD.getRemessaRecebimentoBD().obter(recebimento.getRemessaRecebimentoDBT());
        }
        recebimento.setIdRegistro(rs.getString("IDRegistro"));
    }

    public Object lerRegistro(ResultSet rs) throws SQLException {
        RecebimentoDBT recebimento = new RecebimentoDBT();
        this.lerRegistro(recebimento, rs);
        return recebimento;
    }

    public boolean localizado(Object objetoNegocio) throws SQLException {
        RecebimentoDBT recebimento = (RecebimentoDBT)objetoNegocio;
        String query = "SELECT * FROM RecebimentoDBT WHERE";
        String condicao = "";
        if (recebimento.getIdRegistro() != null && recebimento.getIdRegistro().trim().length() > 0) {
            condicao = String.valueOf(condicao) + " AND IDRegistro = '" + recebimento.getIdRegistro().trim() + "'";
        }
        if (recebimento.getNumeroRecebimentoDBT() > 0) {
            condicao = String.valueOf(condicao) + " AND numeroRecebimentoDBT = " + recebimento.getNumeroRecebimentoDBT();
        }
        condicao = condicao.trim().length() > 4 ? condicao.substring(4) : " numeroRecebimentoDBT = 0";
        return !this.isConsultaVazia(query = String.valueOf(query) + condicao);
    }

    public boolean localizadoDuplicidade(Object objetoNegocio) throws SQLException {
        RecebimentoDBT recebimento = (RecebimentoDBT)objetoNegocio;
        String query = "SELECT RecebimentoDBT.numeroRecebimentoDBT, RecebimentoDBT.codigoPessoaFK, RecebimentoDBT.codigoPessoaIdentificadorFK, RecebimentoDBT.codigoIdentificadorFK, RecebimentoDBT.numeroIdentificadorFK, RecebimentoDBT.numeroConvenioDBT, RecebimentoDBT.data, RecebimentoDBT.valor, RecebimentoDBT.codigoSituacaoRecebimentoFK  FROM RecebimentoDBT  WHERE (((RecebimentoDBT.codigoPessoaFK)='" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaRel() + "') " + " AND ((RecebimentoDBT.codigoPessoaIdentificadorFK)='" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaIdentificadorRel() + "') " + " AND ((RecebimentoDBT.codigoIdentificadorFK)='" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoIdentificador() + "') " + " AND ((RecebimentoDBT.numeroIdentificadorFK)='" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador() + "') " + " AND ((RecebimentoDBT.numeroConvenioDBT)='" + recebimento.getConvenio().getNumeroConvenioDBT() + "') " + " AND ((RecebimentoDBT.data)=" + this.dataSql(recebimento.getDataRecebimento()) + ") " + " AND ((RecebimentoDBT.valor)=" + recebimento.getValorRecebimento() + ") " + " AND ((RecebimentoDBT.codigoSituacaoRecebimentoFK)='G'))";
        if (recebimento.getNumeroRecebimentoDBT() != 0) {
            query = String.valueOf(query) + " AND numeroRecebimentoDBT <> " + recebimento.getNumeroRecebimentoDBT() + " ";
        }
        return !this.isConsultaVazia(query);
    }

    public String montarCondicao(Filtro filtro) throws Throwable {
        String condicao = "";
        if (filtro.getCampo("Convenio") != null) {
            condicao = String.valueOf(condicao) + " AND IdentificadorClienteDBT.numeroConvenioDBTFK = '" + filtro.getCampo("Convenio") + "' ";
        }
        if (filtro.getCampo("Situacao") != null) {
            condicao = String.valueOf(condicao) + " AND RecebimentoDBT.codigoSituacaoRecebimentoFK = '" + filtro.getCampo("Situacao") + "'";
        }
        if (filtro.getCampo("CodigoGrupo") != null) {
            condicao = filtro.getCampo("CodigoGrupo").equals("NULO") ? String.valueOf(condicao) + " and MembroGrupoClienteRecebimento.codigoGrupoClienteRecebimentoFK is Null " : String.valueOf(condicao) + " AND MembroGrupoClienteRecebimento.codigoGrupoClienteRecebimentoFK = " + filtro.getCampo("CodigoGrupo");
        }
        if (filtro.getCampo("CNPJ") != null && filtro.getCampo("CNPJ").compareTo("00000000000000") != 0 && filtro.getCampo("CNPJ").trim().length() > 0) {
            condicao = String.valueOf(condicao) + " and Identificacao.codigoPessoaIdentificadorFK ='0000002' ";
            condicao = String.valueOf(condicao) + " and Identificacao.codigoIdentificadorFK='CNPJ' ";
            condicao = String.valueOf(condicao) + " and Identificacao.numeroIdentificador ='" + filtro.getCampo("CNPJ") + "' ";
        } else if (filtro.getCampo("CPF") != null && filtro.getCampo("CPF").compareTo("00000000000") != 0 && filtro.getCampo("CPF").trim().length() > 0) {
            condicao = String.valueOf(condicao) + " and Identificacao.codigoPessoaIdentificadorFK ='0000002' ";
            condicao = String.valueOf(condicao) + " and Identificacao.codigoIdentificadorFK='CPF' ";
            condicao = String.valueOf(condicao) + " and Identificacao.numeroIdentificador ='" + filtro.getCampo("CPF") + "' ";
        }
        if (filtro.getCampo("IdentificadorDBT") != null && filtro.getCampo("IdentificadorDBT").compareTo("") != 0) {
            if (filtro.getCampo("Convenio") != null) {
                condicao = String.valueOf(condicao) + " and Identificacao.codigoIdentificadorFK='" + filtro.getCampo("codigoIdentificadorDBT").trim() + "'";
                condicao = String.valueOf(condicao) + " and Identificacao.numeroIdentificador='" + filtro.getCampo("identificadorDBT") + "'";
            } else {
                condicao = String.valueOf(condicao) + " and Identificacao.numeroIdentificador='" + filtro.getCampo("identificadorDBT") + "'";
            }
        }
        if (filtro.getCampo("IdentificadorProprio") != null && filtro.getCampo("IdentificadorProprio").compareTo("") != 0) {
            condicao = String.valueOf(condicao) + " and Identificacao.codigoPessoaIdentificadorFK ='" + ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa() + "' ";
            condicao = String.valueOf(condicao) + " and Identificacao.codigoIdentificadorFK = '" + filtro.getCampo("codigoIdentificadorProprio").trim() + "' ";
            condicao = String.valueOf(condicao) + " and Identificacao.numeroIdentificador = '" + filtro.getCampo("IdentificadorProprio") + "' ";
        }
        if (filtro.getCampo("NomePessoa") != null) {
            condicao = String.valueOf(condicao) + " AND Pessoa.textoNome Like '%" + filtro.getCampo("NomePessoa") + "%' ";
        }
        if (filtro.getCampo("CodigoPessoaBanco") != null) {
            condicao = String.valueOf(condicao) + " AND IdentificadorClienteDBT.codigoPessoaBancoFK = '" + filtro.getCampo("CodigoPessoaBanco") + "' ";
        }
        condicao = String.valueOf(condicao) + " and RelacaoPessoaPlugin.codigoPessoaConvenenteFK = '" + ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa() + "' and RelacaoPessoaPlugin.codigoPluginFK = '" + ControleAplicacao.getPlugin().getCodigoPlugin() + "' ";
        if (filtro.getCampo("PrefixoAgencia") != null) {
            condicao = String.valueOf(condicao) + " AND IdentificadorClienteDBT.codigoPrefixoAgenciaFK = '" + filtro.getCampo("PrefixoAgencia") + "' ";
        }
        if (filtro.getCampo("NumeroConta") != null) {
            condicao = String.valueOf(condicao) + " AND IdentificadorClienteDBT.numeroContaCorrenteFK = '" + filtro.getCampo("NumeroConta") + "' ";
        }
        if (filtro.getCampo("DataIn\u00edcio") != null) {
            condicao = String.valueOf(condicao) + " AND RecebimentoDBT.data >= " + this.dataSql(Util.strdataToDate(filtro.getCampo("DataIn\u00edcio")));
        }
        if (filtro.getCampo("DataFim") != null) {
            condicao = String.valueOf(condicao) + " And RecebimentoDBT.data <= " + this.dataSql(Util.strdataToDate(filtro.getCampo("DataFim")));
        }
        if (filtro.getCampo("ValorInicio") != null) {
            condicao = String.valueOf(condicao) + " AND RecebimentoDBT.valor >= " + filtro.getCampo("ValorInicio");
        }
        if (filtro.getCampo("ValorFim") != null) {
            condicao = String.valueOf(condicao) + " AND RecebimentoDBT.valor <= " + filtro.getCampo("ValorFim");
        }
        if (filtro.getCampo("DataRemessa") != null) {
            condicao = String.valueOf(condicao) + " AND RecebimentoDBT.dataRemessaFK >= " + this.dataSql(Util.strdataToDate(filtro.getCampo("DataRemessa")));
        }
        if (filtro.getCampo("NumeroRemessa") != null) {
            condicao = String.valueOf(condicao) + " AND RecebimentoDBT.numeroRemessaFK >= " + filtro.getCampo("NumeroRemessa");
        }
        condicao = String.valueOf(condicao) + " AND RecebimentoDBT.codigoPessoaIdentificadorFK = '" + ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa() + "' ";
        return condicao;
    }

    public void obter(Object objetoNegocio) throws SQLException {
        RecebimentoDBT recebimento = (RecebimentoDBT)objetoNegocio;
        String query = "SELECT * FROM RecebimentoDBT WHERE";
        String condicao = "";
        if (recebimento.getIdRegistro() != null && recebimento.getIdRegistro().trim().length() > 0) {
            condicao = String.valueOf(condicao) + " AND IDRegistro = '" + recebimento.getIdRegistro().trim() + "'";
        }
        if (recebimento.getNumeroRecebimentoDBT() > 0) {
            condicao = String.valueOf(condicao) + " AND numeroRecebimentoDBT = " + recebimento.getNumeroRecebimentoDBT();
        }
        condicao = condicao.trim().length() > 4 ? condicao.substring(4) : " numeroRecebimentoDBT = 0";
        query = String.valueOf(query) + condicao;
        this.popularObjeto((Object)recebimento, query);
    }

    public Vector obterLista() throws SQLException {
        String query = "SELECT *  FROM RecebimentoDBT  WHERE codigoPessoaIdentificadorFK = '" + ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa() + "'";
        return this.gerarVetor(query);
    }

    public Vector obterLista(IdentificadorDBT identificador, String situacoes) throws SQLException {
        String query = "SELECT DISTINCT * FROM RecebimentoDBT ";
        String condicao = " ";
        if (identificador.getIdentificacaoDBT().getNumeroIdentificador() != null && identificador.getIdentificacaoDBT().getNumeroIdentificador().trim().compareTo("") != 0) {
            condicao = String.valueOf(condicao) + "AND numeroIdentificadorFK = '" + identificador.getIdentificacaoDBT().getNumeroIdentificador() + "' ";
        }
        if (identificador.getIdentificacaoDBT().getCodigoIdentificador() != null && identificador.getIdentificacaoDBT().getCodigoIdentificador().trim().compareTo("") != 0) {
            condicao = String.valueOf(condicao) + "AND codigoIdentificadorFK = '" + identificador.getIdentificacaoDBT().getCodigoIdentificador() + "' ";
        }
        if (situacoes != null && situacoes.trim().length() > 0) {
            condicao = String.valueOf(condicao) + "AND (";
            int i = 0;
            while (i < situacoes.length()) {
                condicao = String.valueOf(condicao) + "codigoSituacaoRecebimentoFK = '" + situacoes.substring(i, i + 1) + "' or ";
                ++i;
            }
            condicao = condicao.substring(0, condicao.length() - 3);
            condicao = String.valueOf(condicao) + " )";
        }
        if (condicao.length() > 0) {
            query = String.valueOf(query) + " WHERE " + condicao.substring(4);
        }
        return this.gerarVetor(query);
    }

    public Vector obterLista(Object objetoNegocio) throws SQLException {
        RecebimentoDBT recebimento = (RecebimentoDBT)objetoNegocio;
        String query = "SELECT DISTINCT * FROM RecebimentoDBT ";
        String condicao = " ";
        if (recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaRel() != null && recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaRel().trim().compareTo("") != 0) {
            condicao = String.valueOf(condicao) + "AND codigoPessoaFK = '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaRel() + "' ";
        }
        if (recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaIdentificadorRel() != null && recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaIdentificadorRel().trim().compareTo("") != 0) {
            condicao = String.valueOf(condicao) + "AND codigoPessoaIdentificadorFK = '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaIdentificadorRel() + "' ";
        }
        if (recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoIdentificador() != null && recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoIdentificador().trim().compareTo("") != 0) {
            condicao = String.valueOf(condicao) + "AND codigoIdentificadorFK = '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoIdentificador() + "' ";
        }
        if (recebimento.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador() != null && recebimento.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador().trim().compareTo("") != 0) {
            condicao = String.valueOf(condicao) + "AND numeroIdentificadorFK = '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador() + "' ";
        }
        if (recebimento.getConvenio().getNumeroConvenioDBT() != null && recebimento.getConvenio().getNumeroConvenioDBT().trim().compareTo("") != 0) {
            condicao = String.valueOf(condicao) + "AND numeroConvenioDBTFK = '" + recebimento.getConvenio().getNumeroConvenioDBT() + "' ";
        }
        if (condicao.length() > 0) {
            query = String.valueOf(query) + " WHERE " + condicao.substring(4);
        }
        return this.gerarVetor(query);
    }

    public Vector obterListaExpurgo(Date dataInicial, Date dataFinal, String numeroConvenio) throws SQLException {
        String query = "SELECT DISTINCT recebimento.*  FROM RecebimentoDBT, RelacaoPessoaPlugin, ConvenioDBT  WHERE RelacaoPessoaPlugin.codigoPessoaConvenenteFK = '" + ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa() + "' " + " AND RelacaoPessoaPlugin.codigoPessoaFK = RecebimentoDBT.codigoPessoaFK " + " AND dataRemessaFK between " + this.dataSql(dataInicial) + " AND " + this.dataSql(dataFinal) + " " + " AND convenio.numeroConvenioDBT = '" + numeroConvenio + "' ";
        return this.gerarVetor(query);
    }

    public void obterPorIDDBT(Object objetoNegocio) throws SQLException {
        RecebimentoDBT recebimento = (RecebimentoDBT)objetoNegocio;
        String query = "SELECT *  FROM RecebimentoDBT  WHERE numeroIdentificadorFK = '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador() + "' " + " AND codigoIdentificadorFK = '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getIdentificador().getCodigoIdentificador() + "' ";
        this.popularObjeto((Object)recebimento, query);
    }

    public void remover(Object objetoNegocio) throws SQLException {
        RecebimentoDBT recebimento = (RecebimentoDBT)objetoNegocio;
        String query = "DELETE *  FROM RecebimentoDBT  WHERE numeroRecebimentoDBT = " + recebimento.getNumeroRecebimentoDBT() + " ";
        this.executar(query);
    }

    public void removerTodosRecebimentos(Object objetoNegocio) throws SQLException {
        RecebimentoDBT recebimento = (RecebimentoDBT)objetoNegocio;
        String query = "DELETE * FROM RecebimentoDBT ";
        String condicao = " ";
        if (recebimento.getNumeroRecebimentoDBT() != 0) {
            condicao = String.valueOf(condicao) + "AND numeroRecebimentoDBT = '" + recebimento.getNumeroRecebimentoDBT() + "' ";
        }
        if (recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaRel() != null && recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaRel().trim().compareTo("") != 0) {
            condicao = String.valueOf(condicao) + "AND codigoPessoaFK = '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaRel() + "' ";
        }
        if (recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaIdentificadorRel() != null && recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaIdentificadorRel().trim().compareTo("") != 0) {
            condicao = String.valueOf(condicao) + "AND codigoPessoaIdentificadorFK = '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoPessoaIdentificadorRel() + "' ";
        }
        if (recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoIdentificador() != null && recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoIdentificador().trim().compareTo("") != 0) {
            condicao = String.valueOf(condicao) + "AND codigoIdentificadorFK = '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getCodigoIdentificador() + "' ";
        }
        if (recebimento.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador() != null && recebimento.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador().trim().compareTo("") != 0) {
            condicao = String.valueOf(condicao) + "AND numeroIdentificadorFK = '" + recebimento.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador() + "' ";
        }
        if (condicao.length() > 0) {
            query = String.valueOf(query) + " WHERE " + condicao.substring(4);
        }
        this.executar(query);
    }

    public void salvar(Object objetoNegocio) throws SQLException {
        if (!this.localizado(objetoNegocio)) {
            this.adicionar(objetoNegocio);
        } else {
            this.alterar(objetoNegocio);
        }
    }

    public boolean verificarRecuperacaoRemessa(RemessaRecebimentoDBT remessaRecebimentoDBT) throws SQLException {
        String query = "SELECT *  FROM RecebimentoDBT  WHERE numeroRemessaFK = " + remessaRecebimentoDBT.getNumeroRemessa() + " " + " AND numeroConvenioDBT = '" + remessaRecebimentoDBT.getNumeroConvenioFK() + "' " + " AND codigoSituacaoRecebimentoFK <> 'R'";
        Vector lista = this.gerarVetor(query);
        return lista.size() <= 0;
    }
}

