/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.protocol.https;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import sun.net.www.MessageHeader;
import sun.plugin.protocol.https.BrowserHttpsInputStream;
import sun.plugin.protocol.https.BrowserHttpsOutputStream;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.Trace;

public class BrowserHttpsURLConnection
extends URLConnection {
    private MessageHeader responseHeaders = null;
    private MessageHeader requestHeaders = null;
    private int nativeConnection = 0;
    InputStream ins = null;
    OutputStream outs = null;
    byte[] postResponse = null;
    boolean postResponseReady = false;

    public BrowserHttpsURLConnection(URL uRL) throws IOException {
        super(uRL);
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        String string = ResourceHandler.getMessage("opening_url") + this.url;
        Trace.netPrintln(string, 3);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.url.getHost(), this.url.getPort());
        }
        this.packageRequestHeaders();
        string = "Connecting " + this.url;
        Trace.netPrintln(string);
        this.connected = true;
    }

    private byte[] getRequestHeaders() {
        byte[] byArray = null;
        if (this.requestHeaders != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            this.requestHeaders.print(printStream);
            printStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    private void setResponseHeaders(byte[] byArray) {
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                this.responseHeaders = new MessageHeader(byteArrayInputStream);
            }
            catch (IOException iOException) {
                Trace.netPrintException(iOException);
            }
        }
    }

    protected void packageRequestHeaders() {
        if (this.getIfModifiedSince() != 0L) {
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            Date date = new Date(this.getIfModifiedSince());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
            simpleDateFormat.setTimeZone(timeZone);
            this.setRequestProperty("If-Modified-Since", simpleDateFormat.format(date));
        }
        this.setRequestPropertyIfNotSet("Content-Type", "application/x-www-form-urlencoded");
    }

    public String getHeaderField(String string) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.responseHeaders != null) {
            return this.responseHeaders.findValue(string);
        }
        return null;
    }

    public String getHeaderFieldKey(int n) {
        if (this.responseHeaders != null) {
            return this.responseHeaders.getKey(n);
        }
        return null;
    }

    public String getHeaderField(int n) {
        if (this.responseHeaders != null) {
            return this.responseHeaders.getValue(n);
        }
        return null;
    }

    public synchronized void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (this.requestHeaders == null) {
            this.requestHeaders = new MessageHeader();
        }
        this.requestHeaders.set(string, string2);
    }

    public synchronized void setRequestPropertyIfNotSet(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (this.requestHeaders == null) {
            this.requestHeaders = new MessageHeader();
        }
        this.requestHeaders.setIfNotSet(string, string2);
    }

    public String getRequestProperty(String string) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (this.requestHeaders != null) {
            return this.requestHeaders.findValue(string);
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        if (!this.connected) {
            this.connect();
        }
        if (this.ins == null) {
            String string;
            byte[] byArray = null;
            if (this.doOutput) {
                if (!this.postResponseReady) {
                    throw new UnknownServiceException("Input from HTTPS not expected until OutputStream is closed");
                }
                byArray = this.postResponse;
                this.postResponse = null;
                if (null == byArray) {
                    throw new FileNotFoundException(this.getURL().toString());
                }
                this.ins = new ByteArrayInputStream(byArray);
            } else {
                this.ins = new BufferedInputStream(new BrowserHttpsInputStream(this));
            }
            if (this.responseHeaders == null) {
                this.responseHeaders = new MessageHeader();
            }
            if ((string = this.getHeaderField("Content-Type")) == null) {
                try {
                    string = URLConnection.guessContentTypeFromStream(this.ins);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (string == null && (string = this.url.getFile().endsWith("/") ? "text/html" : URLConnection.guessContentTypeFromName(this.url.getFile())) == null) {
                    string = "content/unknown";
                }
                this.responseHeaders.add("Content-Type", string);
            }
            if (null != byArray) {
                this.responseHeaders.setIfNotSet("Content-Length", String.valueOf(byArray.length));
            }
        }
        return this.ins;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.doOutput) {
            throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
        }
        if (this.ins != null) {
            throw new ProtocolException("Cannot write output after reading input.");
        }
        if (!this.connected) {
            this.connect();
        }
        if (this.outs == null) {
            this.outs = new BrowserHttpsOutputStream(this);
        }
        return this.outs;
    }
}

