/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Iterator;
import sun.plugin.security.CertificateStore;
import sun.plugin.usability.Trace;
import sun.security.action.GetPropertyAction;

public class RootCACertificateStore
implements CertificateStore {
    private static String _filename = null;
    private KeyStore _cacerts = null;

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.securityPrintln("Loading Root CA certificates from " + _filename);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    if (RootCACertificateStore.this._cacerts == null) {
                        RootCACertificateStore.this._cacerts = KeyStore.getInstance("JKS");
                        RootCACertificateStore.this._cacerts.load(null, null);
                    }
                    FileInputStream fileInputStream = new FileInputStream(new File(_filename));
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    RootCACertificateStore.this._cacerts.load(bufferedInputStream, null);
                    bufferedInputStream.close();
                    fileInputStream.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.securityPrintln("Loaded Root CA certificates from " + _filename);
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.securityPrintln("Saving Root CA certificates in " + _filename);
    }

    public void add(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln("Adding certificate in Root CA certificate store");
        throw new KeyStoreException("Cannot add root CA certificate");
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln("Removing certificate in Root CA certificate store");
        throw new KeyStoreException("Cannot remove root CA certificate");
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln("Checking if certificate is in Root CA certificate store");
        return this._cacerts.getCertificateAlias(certificate) != null;
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln("Check if certificate can be verified using certificates in Root CA certificate store");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Certificate to be verified:\n");
        stringBuffer.append(certificate.toString());
        Trace.securityPrintln(stringBuffer.toString(), 2);
        Enumeration<String> enumeration = this._cacerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate2 = this._cacerts.getCertificate(string);
            stringBuffer.setLength(0);
            stringBuffer.append("Comparing certificate against Root CA certificate:\n");
            stringBuffer.append(certificate2.toString());
            Trace.securityPrintln(stringBuffer.toString(), 2);
            try {
                certificate.verify(certificate2.getPublicKey());
                Trace.securityPrintln("Certificate has been verified with Root CA certificates sucessfully");
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Trace.securityPrintln("Certificate has failed the verification with the Root CA certificates");
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        Trace.securityPrintln("Obtain certificate iterator in Root CA certificate store");
        throw new KeyStoreException("Cannot obtain certificate iterator in Root CA certificate");
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("java.home"));
        _filename = string + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
    }
}

